/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.taskplanner.server.job.changeclassification;

import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.plugins.taskplanner.HelpDeskTaskPlannerServerPlugin;
import com.inet.helpdesk.plugins.taskplanner.server.FilterableFieldListGenerator;
import com.inet.helpdesk.plugins.taskplanner.server.job.changeclassification.ChangeClassificationJob;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.taskplanner.server.api.DataEntry;
import com.inet.taskplanner.server.api.common.AbstractDefinition;
import com.inet.taskplanner.server.api.common.SummaryEntry;
import com.inet.taskplanner.server.api.error.ValidationException;
import com.inet.taskplanner.server.api.field.SelectInputField;
import com.inet.taskplanner.server.api.field.TextField;
import com.inet.taskplanner.server.api.job.ConditionInfo;
import com.inet.taskplanner.server.api.job.JobDefinition;
import com.inet.taskplanner.server.api.job.JobFactory;
import com.inet.taskplanner.server.api.job.JobInfo;
import com.inet.taskplanner.server.api.job.JobSummaryInfo;
import com.inet.taskplanner.server.api.result.ResultFlavor;
import com.inet.taskplanner.server.api.series.SeriesDefinition;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ChangeClassificationJobFactory
extends JobFactory<ChangeClassificationJob> {
    public static final String EXTENSION_NAME = "taskplanner.helpdesk.change-classification";

    public ChangeClassificationJobFactory() {
        super(EXTENSION_NAME);
    }

    public List<ResultFlavor> getResultFlavors(JobDefinition jobDefinition) {
        return new ArrayList<ResultFlavor>();
    }

    @Nullable
    public Map<String, String> updateValues(@Nonnull JobDefinition patchedDefinition, @Nullable JobDefinition unpatchedDefinition, @Nullable SeriesDefinition seriesDefinition, @Nonnull GUID taskID) {
        return super.updateValues((AbstractDefinition)patchedDefinition, (AbstractDefinition)unpatchedDefinition, seriesDefinition, taskID);
    }

    protected FilterableFieldListGenerator getFieldListGenerator() {
        return FilterableFieldListGenerator.getInstance();
    }

    public JobInfo getInformation(@Nullable GUID guid) {
        URL iconURL = ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/plugins/taskplanner/structure/change_classification_32.png");
        String helpKey = "taskplanner.job.change-classification";
        String name = HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ChangeClassificationName", new Object[0]);
        String description = HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ChangeClassificationDesc", new Object[0]);
        ArrayList<Object> fields = new ArrayList<Object>();
        TextField textField = new TextField("Ticket ID", HelpDeskTaskPlannerServerPlugin.MSG.getMsg("TicketIDLabel", new Object[0]));
        textField.setValue("{Ticket ID}");
        fields.add(textField);
        FilterableFieldListGenerator generator = this.getFieldListGenerator();
        ArrayList<DataEntry> classificationKeys = generator.getClassificationKeys();
        SelectInputField f = new SelectInputField(Tickets.FIELD_CLASSIFICATION_ID.getKey(), HelpDeskTaskPlannerServerPlugin.MSG.getMsg("classificationLabel", new Object[0]), 3);
        if (classificationKeys != null && classificationKeys.size() > 0) {
            f.setValue(classificationKeys.get(0).getValue());
            f.setDisplay(classificationKeys.get(0).getLabel());
        }
        fields.add(f);
        return new JobInfo(this.getExtensionName(), name, description, iconURL, helpKey, new ConditionInfo(new ArrayList()), fields, new ArrayList());
    }

    protected void validate(@Nonnull JobDefinition definition, @Nullable GUID guid) throws ValidationException {
        Map props = definition.getProperties();
        if (props.get("Ticket ID") == null || ((String)props.get("Ticket ID")).isEmpty()) {
            throw new ValidationException(new String[]{HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ErrorNoTicketEmpty", new Object[0])});
        }
        if (props.get(Tickets.FIELD_CLASSIFICATION_ID.getKey()) == null) {
            throw new ValidationException(new String[]{HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ErrorNoClassification", new Object[0])});
        }
    }

    protected void validateCondition(@Nonnull JobDefinition jobDefinition) throws ValidationException {
    }

    public boolean isAvailable() {
        UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
        return currentUserAccount != null && HDUsersAndGroups.isSupporter((UserAccount)currentUserAccount);
    }

    public JobSummaryInfo getSummary(@Nonnull JobDefinition definition) {
        ArrayList<SummaryEntry> summary = new ArrayList<SummaryEntry>();
        String classId = definition.getProperty(Tickets.FIELD_CLASSIFICATION_ID.getKey());
        String valueString = this.getFieldListGenerator().getClassificationKeys().stream().filter(k -> classId != null && classId.equals(k.getValue())).findFirst().map(DataEntry::getLabel).orElse(HelpDeskTaskPlannerServerPlugin.MSG.getMsg("CategoryNoLonger", new Object[0]));
        summary.add(new SummaryEntry("", HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ChangeClassificationSummaryLabel", new Object[]{valueString})));
        return new JobSummaryInfo(summary, new ArrayList());
    }

    protected ChangeClassificationJob createInstanceFrom(@Nonnull JobDefinition definition, @Nullable GUID taskID) {
        return new ChangeClassificationJob(definition, taskID);
    }
}

