/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.taskplanner.server.action.setticketfield;

import com.inet.config.structure.model.LocalizedKey;
import com.inet.config.structure.model.UnitConfigProperty;
import com.inet.field.SelectOption;
import com.inet.field.SelectOptionResult;
import com.inet.field.fieldtypes.FieldTypeTime;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.core.ticketmanager.ui.model.FieldEditDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.SelectEditDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.helpdesk.plugins.taskplanner.HelpDeskTaskPlannerServerPlugin;
import com.inet.helpdesk.plugins.taskplanner.server.FilterableFieldListGenerator;
import com.inet.helpdesk.plugins.taskplanner.server.HDPlaceholderUtils;
import com.inet.helpdesk.plugins.taskplanner.server.HDPlaceholders;
import com.inet.helpdesk.plugins.taskplanner.server.action.setticketfield.SetTicketFieldAction;
import com.inet.helpdesk.plugins.taskplanner.server.series.ticketcreated.TicketCreatedSeries;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.http.ClientMessageException;
import com.inet.http.servlet.ClientLocale;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.taskplanner.server.api.DataEntry;
import com.inet.taskplanner.server.api.action.ResultActionDefinition;
import com.inet.taskplanner.server.api.action.ResultActionFactory;
import com.inet.taskplanner.server.api.action.ResultActionInfo;
import com.inet.taskplanner.server.api.common.SummaryEntry;
import com.inet.taskplanner.server.api.common.SummaryInfo;
import com.inet.taskplanner.server.api.error.ValidationException;
import com.inet.taskplanner.server.api.field.BooleanField;
import com.inet.taskplanner.server.api.field.CurrencyField;
import com.inet.taskplanner.server.api.field.Field;
import com.inet.taskplanner.server.api.field.FieldCondition;
import com.inet.taskplanner.server.api.field.FloatField;
import com.inet.taskplanner.server.api.field.LabelField;
import com.inet.taskplanner.server.api.field.NumberField;
import com.inet.taskplanner.server.api.field.SelectField;
import com.inet.taskplanner.server.api.field.SelectInputField;
import com.inet.taskplanner.server.api.field.TextAreaField;
import com.inet.taskplanner.server.api.field.TextField;
import com.inet.taskplanner.server.api.field.TimeField;
import com.inet.taskplanner.server.api.result.ResultFlavor;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.net.URL;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SetTicketFieldActionFactory
extends ResultActionFactory<SetTicketFieldAction> {
    public static final String PROPERTY_FILTER_TYPE = "FilterType";
    public static final String PROPERTY_FILTER_TYPE_NONE = "FilterTypeNone";
    public static final String PROPERTY_FILTER_TYPE_CATEGORY = "FilterTypeCategory";
    public static final String PROPERTY_FILTER_TYPE_RESOURCE = "FilterTypeResource";
    public static final String PROPERTY_CATEGORY = "Category";
    public static final String PROPERTY_INCLUDE_SUB_CATEGORIES = "IncludeSubcategories";
    public static final String PROPERTY_RESOURCE = "Resource";
    public static final String EXTENSION_NAME = "result.setticketfield";
    public static final String FIELD_TO_CHANGE = "fieldToChange";
    public static final String TEXT_FIELD_VALUE_TO_SET = "textFieldValueToSet";
    public static final String TEXT_AREA_VALUE_TO_SET = "textAreaValueToSet";
    public static final String BOOLEAN_VALUE_TO_SET = "booleanValueToSet";
    public static final String DATE_VALUE_TO_SET = "dateValueToSet";
    public static final String NUMBER_VALUE_TO_SET = "numberValueToSet";
    public static final String FLOAT_VALUE_TO_SET = "floatValueToSet";
    public static final String TIME_VALUE_TO_SET = "timeValueToSet";
    public static final String CURRENCY_VALUE_TO_SET = "currValueToSet";
    public static final String USER_VALUE_TO_SET = "userValueToSet";
    public static final String WORKING_HOURS = "workingHours";
    public static final String SELECT_VALUE_TO_SET_PREFIX = "selectValueToSet";
    private ArrayList<DataEntry> categoryKeys;
    private ArrayList<DataEntry> resourceKeys;

    public SetTicketFieldActionFactory() {
        super(EXTENSION_NAME);
    }

    public List<ResultFlavor> getSupportedFlavors(ResultActionDefinition definition) {
        return Arrays.asList(ResultFlavor.NONE);
    }

    public FilterableFieldListGenerator getFieldListGenerator() {
        return FilterableFieldListGenerator.getInstance();
    }

    public ResultActionInfo getInformation(@Nullable GUID taskID) {
        String name = HelpDeskTaskPlannerServerPlugin.MSG.getMsg("SetTicketFieldCategory", new Object[0]);
        String description = HelpDeskTaskPlannerServerPlugin.MSG.getMsg("SetTicketFieldCategoryDesc", new Object[0]);
        URL iconURL = ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/plugins/taskplanner/structure/setticketfield_32.png");
        String helpKey = "taskplanner.action.set-ticket-field";
        ArrayList<Field> fields = new ArrayList<Field>();
        TextField textField = new TextField("Ticket ID", HelpDeskTaskPlannerServerPlugin.MSG.getMsg("TicketIDLabel", new Object[0]));
        HDPlaceholders.setPlaceholderDynamicallyForTextFieldInAction(taskID, textField);
        fields.add((Field)textField);
        ArrayList<LocalizedKey> fieldTypeValues = new ArrayList<LocalizedKey>();
        List fieldDefs = DynamicExtensionManager.getInstance().get(TicketFieldDefinition.class);
        Collections.sort(fieldDefs, Comparator.comparingInt(TicketFieldDefinition::getPriority));
        block45: for (TicketFieldDefinition d : fieldDefs) {
            if (d.getKey().equals(Tickets.FIELD_CATEGORY_ID.getKey())) {
                fieldTypeValues.add(new LocalizedKey(PROPERTY_FILTER_TYPE_CATEGORY, Tickets.FIELD_CATEGORY_ID.getLabel()));
                continue;
            }
            if (d.getKey().equals(Tickets.FIELD_RESOURCE_GUID.getKey())) {
                fieldTypeValues.add(new LocalizedKey(PROPERTY_FILTER_TYPE_RESOURCE, Tickets.FIELD_RESOURCE_GUID.getLabel()));
                continue;
            }
            FieldEditDefinition edit = d.getEditDefinition();
            if (edit != null && edit.isAvailable(null)) {
                String displayType;
                switch (displayType = edit.getDisplayType()) {
                    case "double": 
                    case "integer": 
                    case "timeonlyvalue": 
                    case "currency": 
                    case "textinput": 
                    case "boolean": 
                    case "textarea": 
                    case "datevalue": 
                    case "dateonlyvalue": {
                        TicketField fieldByKey = Tickets.getFieldByKey((String)edit.getFieldKey());
                        fieldTypeValues.add(new LocalizedKey(edit.getFieldKey(), fieldByKey.getLabel()));
                        break;
                    }
                    case "select": 
                    case "selecteditable": 
                    case "selectmulti": 
                    case "itilselect": {
                        if (!(edit instanceof SelectEditDefinition)) break;
                        SelectOptionResult selectOptions = ((SelectEditDefinition)edit).getSelectOptions(new ArrayList(), "", 10000, 0);
                        List options = selectOptions.getOptions();
                        if (options.size() <= 0) continue block45;
                        fieldTypeValues.add(new LocalizedKey(edit.getFieldKey(), Tickets.getFieldByKey((String)edit.getFieldKey()).getLabel()));
                        break;
                    }
                }
                continue;
            }
            if (!d.getKey().equals(Tickets.FIELD_OWNER_GUID.getKey()) || !SystemPermissionChecker.checkAccess((Permission)UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER)) continue;
            fieldTypeValues.add(new LocalizedKey(Tickets.FIELD_OWNER_GUID.getKey(), Tickets.FIELD_OWNER_GUID.getLabel()));
        }
        final SelectField fieldToChangeSelect = new SelectField(FIELD_TO_CHANGE, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("fieldChange", new Object[0]), fieldTypeValues);
        fieldToChangeSelect.setValue(Tickets.FIELD_SUBJECT.getKey());
        fields.add((Field)fieldToChangeSelect);
        FilterableFieldListGenerator generator = this.getFieldListGenerator();
        HashSet<String> list = new HashSet<String>(Arrays.asList(PROPERTY_FILTER_TYPE_CATEGORY, PROPERTY_FILTER_TYPE_RESOURCE));
        generator.addSelectionFields("SetTicketField.", ".noCustomEntry", fieldToChangeSelect, list, fields);
        fields.removeIf(f -> f.getKey().contains(PROPERTY_INCLUDE_SUB_CATEGORIES));
        fields.removeIf(f -> f.getKey().contains("IncludeSubresources"));
        this.categoryKeys = generator.getCategoryKeys();
        this.resourceKeys = generator.getResourceKeys(false, false);
        ArrayList<UnitConfigProperty.Unit> howOftenOnlyHoursMinutesUnits = new ArrayList<UnitConfigProperty.Unit>();
        howOftenOnlyHoursMinutesUnits.add(new UnitConfigProperty.Unit(0.016666666666666666, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("action.setticketfield.hours", new Object[0])));
        howOftenOnlyHoursMinutesUnits.add(new UnitConfigProperty.Unit(1.0, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("action.setticketfield.minutes", new Object[0])));
        ArrayList<UnitConfigProperty.Unit> howOftenUnits = new ArrayList<UnitConfigProperty.Unit>(howOftenOnlyHoursMinutesUnits);
        howOftenUnits.add(0, new UnitConfigProperty.Unit(6.944444444444444E-4, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("action.setticketfield.days", new Object[0])));
        howOftenUnits.add(0, new UnitConfigProperty.Unit(9.92063492063492E-5, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("action.setticketfield.weeks", new Object[0])));
        howOftenUnits.add(0, new UnitConfigProperty.Unit(2.48015873015873E-5, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("action.setticketfield.months", new Object[0])));
        NumberField dateField = new NumberField(DATE_VALUE_TO_SET, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("valueToSet", new Object[0]), howOftenUnits);
        dateField.setValue("60");
        NumberField dateFieldOnlyHoursMinutes = new NumberField(DATE_VALUE_TO_SET, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("valueToSet", new Object[0]), howOftenOnlyHoursMinutesUnits);
        dateFieldOnlyHoursMinutes.setValue("60");
        LabelField dateLabel = new LabelField("dateValueToSet.label", "", HelpDeskTaskPlannerServerPlugin.MSG.getMsg("action.setticketfield.dateExplanation", new Object[0]));
        ArrayList<FieldCondition> dateConditions = new ArrayList<FieldCondition>();
        ArrayList<FieldCondition> deadlineConditions = new ArrayList<FieldCondition>();
        BooleanField applyWorkingHours = new BooleanField(WORKING_HOURS, HelpDeskTaskPlannerServerPlugin.MSG.getMsg(WORKING_HOURS, new Object[0]), HelpDeskTaskPlannerServerPlugin.MSG.getMsg("workingHours.postText", new Object[0]));
        applyWorkingHours.setValue("false");
        ArrayList<FieldCondition> workingHourConditions = new ArrayList<FieldCondition>();
        workingHourConditions.add(FieldCondition.visible((Field)fieldToChangeSelect, (FieldCondition.OP)FieldCondition.OP.equals, (String)Tickets.FIELD_DEADLINE.getKey()));
        LabelField workingHoursLabel = new LabelField("workingHours.label", "", HelpDeskTaskPlannerServerPlugin.MSG.getMsg("workingHours.label", new Object[0]));
        applyWorkingHours.setConditions(workingHourConditions);
        workingHoursLabel.setConditions(workingHourConditions);
        NumberField intField = new NumberField(NUMBER_VALUE_TO_SET, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("valueToSet", new Object[0]));
        intField.setValue("");
        CurrencyField currField = new CurrencyField(CURRENCY_VALUE_TO_SET, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("valueToSet", new Object[0]));
        currField.setValue("");
        FloatField floatField = new FloatField(FLOAT_VALUE_TO_SET, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("valueToSet", new Object[0]));
        floatField.setValue("");
        TimeField timeField = new TimeField(TIME_VALUE_TO_SET, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("valueToSet", new Object[0]));
        timeField.setValue("");
        SelectInputField userField = new SelectInputField(USER_VALUE_TO_SET, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("valueToSet", new Object[0]), 13);
        userField.setValue("");
        userField.setAllowCustomValues(true);
        TextField textField3 = new TextField(TEXT_FIELD_VALUE_TO_SET, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("valueToSet", new Object[0]));
        textField3.setValue("");
        TextAreaField textAreaField = new TextAreaField(TEXT_AREA_VALUE_TO_SET, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("valueToSet", new Object[0]));
        textAreaField.setValue("");
        BooleanField booleanField = new BooleanField(BOOLEAN_VALUE_TO_SET, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("valueToSet", new Object[0]));
        booleanField.setValue("false");
        ArrayList<FieldCondition> conditions = new ArrayList<FieldCondition>(Arrays.asList(FieldCondition.visible((Field)fieldToChangeSelect, (FieldCondition.OP)FieldCondition.OP.equals, (String)Tickets.FIELD_SUBJECT.getKey()), FieldCondition.visible((Field)fieldToChangeSelect, (FieldCondition.OP)FieldCondition.OP.equals, (String)Tickets.FIELD_IDENTIFIER.getKey())));
        ArrayList<FieldCondition> conditionsTextArea = new ArrayList<FieldCondition>();
        ArrayList<FieldCondition> conditionsBoolean = new ArrayList<FieldCondition>();
        ArrayList<FieldCondition> conditionsInt = new ArrayList<FieldCondition>();
        ArrayList<FieldCondition> conditionsFloat = new ArrayList<FieldCondition>();
        ArrayList<FieldCondition> conditionsCurrency = new ArrayList<FieldCondition>();
        ArrayList<FieldCondition> conditionsTime = new ArrayList<FieldCondition>();
        block46: for (TicketFieldDefinition d : fieldDefs) {
            String displayType;
            FieldEditDefinition edit = d.getEditDefinition();
            if (edit == null || !edit.isAvailable(null)) continue;
            switch (displayType = edit.getDisplayType()) {
                case "double": {
                    conditionsFloat.add(FieldCondition.visible((Field)fieldToChangeSelect, (FieldCondition.OP)FieldCondition.OP.equals, (String)edit.getFieldKey()));
                    break;
                }
                case "integer": {
                    conditionsInt.add(FieldCondition.visible((Field)fieldToChangeSelect, (FieldCondition.OP)FieldCondition.OP.equals, (String)edit.getFieldKey()));
                    break;
                }
                case "timeonlyvalue": {
                    conditionsTime.add(FieldCondition.visible((Field)fieldToChangeSelect, (FieldCondition.OP)FieldCondition.OP.equals, (String)edit.getFieldKey()));
                    break;
                }
                case "currency": {
                    conditionsCurrency.add(FieldCondition.visible((Field)fieldToChangeSelect, (FieldCondition.OP)FieldCondition.OP.equals, (String)edit.getFieldKey()));
                    break;
                }
                case "boolean": {
                    conditionsBoolean.add(FieldCondition.visible((Field)fieldToChangeSelect, (FieldCondition.OP)FieldCondition.OP.equals, (String)edit.getFieldKey()));
                    break;
                }
                case "textinput": {
                    conditions.add(FieldCondition.visible((Field)fieldToChangeSelect, (FieldCondition.OP)FieldCondition.OP.equals, (String)edit.getFieldKey()));
                    break;
                }
                case "textarea": {
                    conditionsTextArea.add(FieldCondition.visible((Field)fieldToChangeSelect, (FieldCondition.OP)FieldCondition.OP.equals, (String)edit.getFieldKey()));
                    break;
                }
                case "datevalue": 
                case "dateonlyvalue": {
                    if (Tickets.FIELD_DEADLINE.getKey().equals(edit.getFieldKey())) {
                        deadlineConditions.add(FieldCondition.visible((Field)fieldToChangeSelect, (FieldCondition.OP)FieldCondition.OP.equals, (String)edit.getFieldKey()));
                        break;
                    }
                    dateConditions.add(FieldCondition.visible((Field)fieldToChangeSelect, (FieldCondition.OP)FieldCondition.OP.equals, (String)edit.getFieldKey()));
                    break;
                }
                case "select": 
                case "selecteditable": 
                case "selectmulti": 
                case "itilselect": {
                    if (!(edit instanceof SelectEditDefinition)) break;
                    SelectOptionResult selectOptions = ((SelectEditDefinition)edit).getSelectOptions(new ArrayList(), "", 10000, 0);
                    List options = selectOptions.getOptions();
                    if (options.size() <= 0) continue block46;
                    SelectInputField selectValueField = new SelectInputField("selectValueToSet." + d.getFieldKey(), HelpDeskTaskPlannerServerPlugin.MSG.getMsg("valueToSet", new Object[0]), -12345);
                    ArrayList<FieldCondition> selectValueConditions = new ArrayList<FieldCondition>();
                    selectValueConditions.add(FieldCondition.visible((Field)fieldToChangeSelect, (FieldCondition.OP)FieldCondition.OP.equals, (String)edit.getFieldKey()));
                    selectValueField.setConditions(selectValueConditions);
                    selectValueField.setAllowCustomValues(true);
                    TicketField ticketField = Tickets.getFieldByKey((String)edit.getFieldKey());
                    Object defaultValueToPick = null;
                    if (ticketField != null) {
                        defaultValueToPick = ticketField.getDefaultValue();
                    }
                    if (defaultValueToPick != null) {
                        Object defaultValueToPick_ = defaultValueToPick;
                        selectValueField.setValue(options.stream().filter(o -> defaultValueToPick_.equals(o.getValue())).findFirst().orElse((SelectOption)options.get(0)).getLabel());
                    } else {
                        selectValueField.setValue(((SelectOption)options.get(0)).getValue());
                        selectValueField.setDisplay(((SelectOption)options.get(0)).getLabel());
                    }
                    fields.add((Field)selectValueField);
                    break;
                }
            }
        }
        textField3.setConditions(conditions);
        FieldCondition alwaysFalse = FieldCondition.visible((Field)fieldToChangeSelect, (FieldCondition.OP)FieldCondition.OP.startswith, (String)"somethingnotinthefieldchangeselect");
        if (conditionsTextArea.size() == 0) {
            conditionsTextArea.add(alwaysFalse);
        }
        textAreaField.setConditions(conditionsTextArea);
        if (conditionsBoolean.size() == 0) {
            conditionsBoolean.add(alwaysFalse);
        }
        booleanField.setConditions(conditionsBoolean);
        dateField.setConditions(dateConditions);
        dateFieldOnlyHoursMinutes.setConditions(deadlineConditions);
        if (conditionsFloat.size() == 0) {
            conditionsFloat.add(alwaysFalse);
        }
        floatField.setConditions(conditionsFloat);
        if (conditionsCurrency.size() == 0) {
            conditionsCurrency.add(alwaysFalse);
        }
        currField.setConditions(conditionsCurrency);
        if (conditionsInt.size() == 0) {
            conditionsInt.add(alwaysFalse);
        }
        intField.setConditions(conditionsInt);
        if (conditionsTime.size() == 0) {
            conditionsTime.add(alwaysFalse);
        }
        timeField.setConditions(conditionsTime);
        userField.setConditions((List)new ArrayList<FieldCondition>(){
            {
                this.add(FieldCondition.visible((Field)fieldToChangeSelect, (FieldCondition.OP)FieldCondition.OP.equals, (String)Tickets.FIELD_OWNER_GUID.getKey()));
            }
        });
        fields.add((Field)textField3);
        fields.add((Field)textAreaField);
        fields.add((Field)booleanField);
        fields.add((Field)floatField);
        fields.add((Field)currField);
        fields.add((Field)intField);
        fields.add((Field)timeField);
        fields.add((Field)userField);
        boolean hadDateFieldOfSomeKind = false;
        ArrayList<FieldCondition> dateLabelConditions = new ArrayList<FieldCondition>();
        if (dateConditions.size() != 0) {
            fields.add((Field)dateField);
            hadDateFieldOfSomeKind = true;
            dateLabelConditions.addAll(dateConditions);
        }
        if (deadlineConditions.size() != 0) {
            fields.add((Field)dateFieldOnlyHoursMinutes);
            hadDateFieldOfSomeKind = true;
            dateLabelConditions.addAll(deadlineConditions);
        }
        if (hadDateFieldOfSomeKind) {
            dateLabel.setConditions(dateLabelConditions);
            fields.add((Field)dateLabel);
        }
        fields.add((Field)applyWorkingHours);
        fields.add((Field)workingHoursLabel);
        return new ResultActionInfo(this.getExtensionName(), name, description, iconURL, helpKey, fields);
    }

    protected void validate(@Nonnull ResultActionDefinition definition, @Nullable GUID taskID) throws ValidationException {
        String field;
        switch (field = definition.getProperty(FIELD_TO_CHANGE)) {
            case "FilterTypeCategory": 
            case "FilterTypeResource": {
                break;
            }
            default: {
                String c;
                if ((Tickets.FIELD_CLASSIFICATION_ID.equals(field) || Tickets.FIELD_ITIL_ID.equals(field) || Tickets.FIELD_PRIORITY_ID.equals(field)) && ((c = definition.getProperty("selectValueToSet." + field)) == null || c.isBlank())) {
                    throw new ValidationException(new String[]{HelpDeskTaskPlannerServerPlugin.MSG.getMsg("action.setticketfield.error.notpossibletoremovevalue", new Object[0])});
                }
                List fieldDefs = DynamicExtensionManager.getInstance().get(TicketFieldDefinition.class);
                for (TicketFieldDefinition d : fieldDefs) {
                    String valueString;
                    if (!d.getKey().equals(field)) continue;
                    String key = d.getKey();
                    if (d.getEditDefinition().getDisplayType().equals("datevalue") || d.getEditDefinition().getDisplayType().equals("dateonlyvalue")) {
                        valueString = definition.getProperty(DATE_VALUE_TO_SET);
                        if (this.hasPlaceholderSet(valueString, taskID)) {
                            return;
                        }
                        if ("NaN".equals(valueString)) {
                            throw new ValidationException(new String[]{HelpDeskTaskPlannerServerPlugin.MSG.getMsg("action.setticketfield.notnumber", new Object[0])});
                        }
                        if (valueString == null || valueString.trim().isEmpty()) continue;
                        try {
                            Integer.valueOf(valueString);
                            continue;
                        }
                        catch (NumberFormatException e) {
                            throw new ValidationException(new String[]{HelpDeskTaskPlannerServerPlugin.MSG.getMsg("action.setticketfield.notnumber", new Object[0])});
                        }
                    }
                    if (d.getEditDefinition() instanceof SelectEditDefinition) continue;
                    FieldEditDefinition edit = d.getEditDefinition();
                    if (edit != null && edit.isAvailable(null)) {
                        valueString = this.extractFromType(definition, d.getEditDefinition());
                        if (valueString == null || this.hasPlaceholderSet(valueString, taskID)) {
                            return;
                        }
                    } else {
                        return;
                    }
                    MutableTicketData dummyData = new MutableTicketData();
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put(key, valueString);
                    try {
                        d.getEditDefinition().updateTicketData(dummyData, map);
                    }
                    catch (Exception e) {
                        if (e instanceof NumberFormatException) {
                            throw new ValidationException(new String[]{HelpDeskTaskPlannerServerPlugin.MSG.getMsg("action.setticketfield.notnumber", new Object[0])});
                        }
                        throw new ValidationException(new String[]{e.getMessage()});
                    }
                }
            }
        }
    }

    public SummaryInfo getSummary(@Nonnull ResultActionDefinition definition) {
        String workingHoursOnlySuffix;
        String valueString;
        String field;
        ArrayList<SummaryEntry> summary = new ArrayList<SummaryEntry>();
        String ticketId = definition.getProperty("Ticket ID");
        String fieldDisplayName = field = definition.getProperty(FIELD_TO_CHANGE);
        String d = null;
        List fieldDefs = DynamicExtensionManager.getInstance().get(TicketFieldDefinition.class);
        for (String tDef : fieldDefs) {
            if (!tDef.getKey().equals(field)) continue;
            d = tDef;
            fieldDisplayName = d.getDisplayName();
        }
        switch (field) {
            case "FilterTypeCategory": {
                String catId = definition.getProperty(TicketCreatedSeries.PROPERTY_CATEGORY);
                valueString = this.categoryKeys.stream().filter(k -> k.getValue().equals(catId)).findFirst().map(DataEntry::getLabel).orElse(HelpDeskTaskPlannerServerPlugin.MSG.getMsg("CategoryNoLonger", new Object[0]));
                if (catId != null && !catId.matches("\\d+")) {
                    valueString = catId;
                }
                field = Tickets.FIELD_CATEGORY_ID.getLabel();
                break;
            }
            case "FilterTypeResource": {
                String resource = definition.getProperty("Resource.noCustomEntry");
                valueString = this.resourceKeys.stream().filter(k -> k.getValue().equals(resource)).findFirst().map(DataEntry::getLabel).orElse(HelpDeskTaskPlannerServerPlugin.MSG.getMsg("CategoryNoLonger", new Object[0]));
                if (resource != null && !resource.matches("\\d+")) {
                    valueString = resource;
                }
                field = Tickets.FIELD_RESOURCE_GUID.getLabel();
                break;
            }
            case "targettime": {
                valueString = definition.getProperty(TEXT_FIELD_VALUE_TO_SET);
                try {
                    MutableTicketData dummyData = new MutableTicketData();
                    HashMap<String, String> values = new HashMap<String, String>();
                    values.put(field, valueString);
                    d.getEditDefinition().updateTicketData(dummyData, values);
                    Integer minutes = (Integer)dummyData.get((TicketField)Tickets.FIELD_TARGET_TIME);
                    valueString = Tickets.FIELD_TARGET_TIME.valueToString(minutes);
                }
                catch (ClientMessageException dummyData) {
                    // empty catch block
                }
                field = fieldDisplayName;
                break;
            }
            default: {
                valueString = "";
                if (d != null && d.getEditDefinition() != null) {
                    if (d.getEditDefinition().getDisplayType().equals("datevalue") || d.getEditDefinition().getDisplayType().equals("dateonlyvalue")) {
                        valueString = definition.getProperty(DATE_VALUE_TO_SET);
                        if (valueString == null || valueString.trim().isEmpty()) {
                            valueString = "''";
                        } else if (!valueString.contains("[") && !valueString.contains("{")) {
                            int hours = Integer.valueOf(valueString);
                            String descriptionKey = "action.setticketfield.datedescription";
                            valueString = this.generateTimeRangeEntry(hours, descriptionKey);
                        }
                    } else if (d.getEditDefinition() instanceof SelectEditDefinition) {
                        valueString = definition.getProperty("selectValueToSet." + d.getFieldKey());
                        SelectOptionResult selectOptions = ((SelectEditDefinition)d.getEditDefinition()).getSelectOptions(new ArrayList(), "", 10000, 0);
                        List options = selectOptions.getOptions();
                        String _value = valueString;
                        valueString = options.stream().filter(o -> _value != null && _value.equals(o.getValue())).map(SelectOption::getLabel).findFirst().orElse(valueString);
                    } else {
                        valueString = this.extractFromType(definition, d.getEditDefinition());
                        String displayType = d.getEditDefinition().getDisplayType();
                        if (displayType.equals("timeonlyvalue")) {
                            if (valueString != null && !valueString.isEmpty()) {
                                valueString = FieldTypeTime.fromMillisSince1970((long)Long.valueOf(valueString));
                            }
                        } else if (displayType.equals("double") || displayType.equals("currency")) {
                            if (!(valueString == null || valueString.isBlank() || valueString.contains("{") || valueString.contains("["))) {
                                NumberFormat formatter = NumberFormat.getNumberInstance(ClientLocale.getThreadLocale());
                                formatter.setGroupingUsed(false);
                                formatter.setMaximumFractionDigits(10);
                                valueString = formatter.format(Double.valueOf(valueString));
                            }
                        } else if (displayType.equals("ticketowner") && valueString != null && !valueString.isBlank() && !valueString.startsWith("{")) {
                            GUID guid = GUID.valueOf((String)valueString);
                            UserAccount userAccount = UserManager.getInstance().getUserAccount(guid);
                            valueString = userAccount == null ? HelpDeskTaskPlannerServerPlugin.MSG.getMsg("CategoryNoLonger", new Object[0]) : userAccount.getDisplayName();
                        }
                    }
                }
                field = fieldDisplayName;
            }
        }
        String string = workingHoursOnlySuffix = "true".equals(definition.getProperty(WORKING_HOURS)) && Tickets.FIELD_DEADLINE.getKey().equals(definition.getProperty(FIELD_TO_CHANGE)) ? " " + HelpDeskTaskPlannerServerPlugin.MSG.getMsg("countingWorkingHoursOnly", new Object[0]) : "";
        if (valueString != null && !valueString.isBlank() && !valueString.equals("''")) {
            summary.add(new SummaryEntry(HelpDeskTaskPlannerServerPlugin.MSG.getMsg("SetTicketFieldTo", new Object[]{field, valueString}) + workingHoursOnlySuffix, "Ticket #" + ticketId));
        } else {
            summary.add(new SummaryEntry(HelpDeskTaskPlannerServerPlugin.MSG.getMsg("RemoveValueFromTicketField", new Object[]{field, valueString}), "Ticket #" + ticketId));
        }
        return new SummaryInfo(summary);
    }

    private String generateTimeRangeEntry(int minutes, String descriptionKey) {
        boolean negativeNum = minutes < 0;
        int howOftenNum = minutes;
        howOftenNum = Math.abs(howOftenNum);
        Object unitString = "action.setticketfield.datedescription.minute";
        if (howOftenNum >= 60 && howOftenNum % 60 == 0) {
            unitString = "action.setticketfield.datedescription.hour";
            if ((howOftenNum /= 60) >= 24 && howOftenNum % 24 == 0) {
                unitString = "action.setticketfield.datedescription.day";
                if ((howOftenNum /= 24) >= 7 && howOftenNum % 7 == 0) {
                    unitString = "action.setticketfield.datedescription.week";
                    howOftenNum /= 7;
                }
            }
        }
        if (howOftenNum > 1) {
            unitString = (String)unitString + "s";
        }
        Object suffix = "";
        String beforeOrAfterKey = HelpDeskTaskPlannerServerPlugin.MSG.getMsg(descriptionKey + (negativeNum ? ".beforeexecution" : ".afterexecution"), new Object[0]);
        suffix = " " + beforeOrAfterKey;
        Object howOftenString = howOftenNum == 1 ? "" : howOftenNum + " ";
        return HelpDeskTaskPlannerServerPlugin.MSG.getMsg(descriptionKey, new Object[]{howOftenString, HelpDeskTaskPlannerServerPlugin.MSG.getMsg((String)unitString, new Object[0])}) + (String)suffix;
    }

    protected SetTicketFieldAction createInstanceFrom(ResultActionDefinition definition, GUID taskID) {
        String value;
        String ticketId = definition.getProperty("Ticket ID");
        if (ticketId != null && ticketId.contains("Ticket ID")) {
            throw new IllegalArgumentException(HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ErrorNoTicketIDPlaceholder", new Object[0]));
        }
        String field = definition.getProperty(FIELD_TO_CHANGE);
        boolean applyWorkingHours = false;
        switch (field) {
            case "FilterTypeCategory": {
                value = new Json().toJson((Object)new SelectOption(definition.getProperty(PROPERTY_CATEGORY), ""));
                break;
            }
            case "FilterTypeResource": {
                String resIdString = definition.getProperty("Resource.noCustomEntry");
                value = new Json().toJson((Object)new SelectOption(resIdString == null ? "-1" : resIdString, ""));
                break;
            }
            default: {
                value = "";
                List fieldDefs = DynamicExtensionManager.getInstance().get(TicketFieldDefinition.class);
                for (TicketFieldDefinition d : fieldDefs) {
                    if (!d.getKey().equals(field) || d.getEditDefinition() == null) continue;
                    FieldEditDefinition editDef = d.getEditDefinition();
                    if (editDef.getDisplayType().equals("datevalue") || editDef.getDisplayType().equals("dateonlyvalue")) {
                        value = definition.getProperty(DATE_VALUE_TO_SET);
                        applyWorkingHours = Boolean.valueOf(definition.getProperty(WORKING_HOURS));
                        continue;
                    }
                    if (editDef instanceof SelectEditDefinition) {
                        value = new Json().toJson((Object)new SelectOption(definition.getProperty("selectValueToSet." + d.getFieldKey()), ""));
                        continue;
                    }
                    if (editDef.getDisplayType().equals("timeonlyvalue")) {
                        value = this.extractFromType(definition, editDef);
                        if (value == null || value.isEmpty()) continue;
                        value = FieldTypeTime.fromMillisSince1970((long)Long.valueOf(value));
                        continue;
                    }
                    value = this.extractFromType(definition, editDef);
                }
            }
        }
        return new SetTicketFieldAction(HDPlaceholderUtils.getTicketIds(ticketId), field, value, taskID, applyWorkingHours);
    }

    private String extractFromType(ResultActionDefinition definition, FieldEditDefinition editDef) {
        switch (editDef.getDisplayType()) {
            case "timeonlyvalue": {
                return definition.getProperty(TIME_VALUE_TO_SET);
            }
            case "textinput": {
                return definition.getProperty(TEXT_FIELD_VALUE_TO_SET);
            }
            case "textarea": {
                return definition.getProperty(TEXT_AREA_VALUE_TO_SET);
            }
            case "boolean": {
                return definition.getProperty(BOOLEAN_VALUE_TO_SET);
            }
            case "integer": {
                return definition.getProperty(NUMBER_VALUE_TO_SET);
            }
            case "double": {
                return definition.getProperty(FLOAT_VALUE_TO_SET);
            }
            case "currency": {
                return definition.getProperty(CURRENCY_VALUE_TO_SET);
            }
            case "ticketowner": {
                return definition.getProperty(USER_VALUE_TO_SET);
            }
        }
        return null;
    }

    public boolean isAvailable() {
        UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
        return currentUserAccount != null && HDUsersAndGroups.isSupporter((UserAccount)currentUserAccount);
    }
}

