/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.taskplanner.server.action.addticketsharing;

import com.inet.config.structure.model.LocalizedKey;
import com.inet.helpdesk.plugins.taskplanner.HelpDeskTaskPlannerServerPlugin;
import com.inet.helpdesk.plugins.taskplanner.server.HDPlaceholders;
import com.inet.helpdesk.plugins.taskplanner.server.action.addticketsharing.AddTicketSharingAction;
import com.inet.helpdesk.plugins.taskplanner.server.action.addticketsharing.UserAndGroupSelectField;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonException;
import com.inet.lib.json.JsonParameterizedType;
import com.inet.lib.util.StringFunctions;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.ServerPluginManager;
import com.inet.taskplanner.server.api.action.ResultActionDefinition;
import com.inet.taskplanner.server.api.action.ResultActionFactory;
import com.inet.taskplanner.server.api.action.ResultActionInfo;
import com.inet.taskplanner.server.api.common.SummaryEntry;
import com.inet.taskplanner.server.api.common.SummaryInfo;
import com.inet.taskplanner.server.api.error.ValidationException;
import com.inet.taskplanner.server.api.field.SelectField;
import com.inet.taskplanner.server.api.field.TextField;
import com.inet.taskplanner.server.api.result.ResultFlavor;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AddTicketSharingActionFactory
extends ResultActionFactory<AddTicketSharingAction> {
    public static final String EXTENSION_NAME = "result.addticketsharing";
    public static final String PROPERTY_ACCESS_TYPE = "accessType";
    public static final String PROPERTY_RECEIVER = "ticketSharingReceiver";

    public AddTicketSharingActionFactory() {
        super(EXTENSION_NAME);
    }

    public List<ResultFlavor> getSupportedFlavors(ResultActionDefinition definition) {
        return Arrays.asList(ResultFlavor.NONE);
    }

    public ResultActionInfo getInformation(@Nullable GUID taskID) {
        return this.getInformation(null, taskID);
    }

    public ResultActionInfo getInformation(@Nullable ResultActionDefinition definition, @Nullable GUID taskID) {
        String name = HelpDeskTaskPlannerServerPlugin.MSG.getMsg("AddTicketSharingAction.Name", new Object[0]);
        String description = HelpDeskTaskPlannerServerPlugin.MSG.getMsg("AddTicketSharingAction.Description", new Object[0]);
        URL iconURL = ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/plugins/taskplanner/structure/ticket_share_32.png");
        String helpKey = "taskplanner.action.add-ticket-sharing";
        ArrayList<Object> fields = new ArrayList<Object>();
        TextField ticketIdsField = new TextField("Ticket ID", HelpDeskTaskPlannerServerPlugin.MSG.getMsg("TicketIDLabel", new Object[0]));
        HDPlaceholders.setPlaceholderDynamicallyForTextFieldInAction(taskID, ticketIdsField);
        fields.add(ticketIdsField);
        ArrayList<LocalizedKey> accessTypes = new ArrayList<LocalizedKey>();
        accessTypes.add(new LocalizedKey("read", HelpDeskTaskPlannerServerPlugin.MSG.getMsg("AddTicketSharingAction.ReadAccessLabel", new Object[0])));
        accessTypes.add(new LocalizedKey("write", HelpDeskTaskPlannerServerPlugin.MSG.getMsg("AddTicketSharingAction.WriteAccessLabel", new Object[0])));
        SelectField accessTypeField = new SelectField(PROPERTY_ACCESS_TYPE, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("AddTicketSharingAction.AccessTypeLabel", new Object[0]), accessTypes);
        accessTypeField.setValue("read");
        accessTypeField.setLabel(HelpDeskTaskPlannerServerPlugin.MSG.getMsg("AddTicketSharingAction.ReadAccessLabel", new Object[0]));
        fields.add(accessTypeField);
        UserAndGroupSelectField receiverField = new UserAndGroupSelectField(PROPERTY_RECEIVER);
        String receiverValue = definition != null ? definition.getProperty(PROPERTY_RECEIVER) : null;
        receiverField.setValue(receiverValue != null ? receiverValue : "{}");
        fields.add((Object)receiverField);
        return new ResultActionInfo(this.getExtensionName(), name, description, iconURL, helpKey, fields);
    }

    protected void validate(@Nonnull ResultActionDefinition definition, @Nullable GUID taskID) throws ValidationException {
        ArrayList<String> errors = new ArrayList<String>();
        String ticketIds = definition.getProperty("Ticket ID");
        String accessType = definition.getProperty(PROPERTY_ACCESS_TYPE);
        String receiverJson = definition.getProperty(PROPERTY_RECEIVER);
        if (ticketIds == null || ticketIds.trim().isEmpty()) {
            errors.add(HelpDeskTaskPlannerServerPlugin.MSG.getMsg("AddTicketSharingAction.Error.NoTicketIds", new Object[0]));
        }
        try {
            Map targets = (Map)new Json().fromJson(receiverJson, (Type)new JsonParameterizedType(HashMap.class, new Type[]{String.class, ArrayList.class}));
            int count = 0;
            if (targets.get("user") != null) {
                count += ((List)targets.get("user")).size();
            }
            if (targets.get("group") != null) {
                count += ((List)targets.get("group")).size();
            }
            if (count == 0) {
                errors.add(HelpDeskTaskPlannerServerPlugin.MSG.getMsg("AddTicketSharingAction.Error.NoReceiver", new Object[0]));
            }
        }
        catch (JsonException e) {
            errors.add(HelpDeskTaskPlannerServerPlugin.MSG.getMsg("AddTicketSharingAction.Error.InvalidReceiver", new Object[0]));
        }
        if (!errors.isEmpty()) {
            throw new ValidationException(errors);
        }
    }

    public SummaryInfo getSummary(@Nonnull ResultActionDefinition definition) {
        HashSet groups;
        ArrayList<SummaryEntry> summary = new ArrayList<SummaryEntry>();
        String ticketIds = definition.getProperty("Ticket ID");
        String accessType = definition.getProperty(PROPERTY_ACCESS_TYPE);
        String receiverJson = definition.getProperty(PROPERTY_RECEIVER);
        summary.add(new SummaryEntry(HelpDeskTaskPlannerServerPlugin.MSG.getMsg("AddTicketSharingAction.Summary.TicketIds", new Object[0]), ticketIds));
        summary.add(new SummaryEntry(HelpDeskTaskPlannerServerPlugin.MSG.getMsg("AddTicketSharingAction.Summary.AccessType", new Object[0]), "read".equals(accessType) ? HelpDeskTaskPlannerServerPlugin.MSG.getMsg("AddTicketSharingAction.ReadAccessLabel", new Object[0]) : HelpDeskTaskPlannerServerPlugin.MSG.getMsg("AddTicketSharingAction.WriteAccessLabel", new Object[0])));
        Map receivers = new HashMap();
        if (!StringFunctions.isEmpty((String)receiverJson)) {
            try {
                receivers = (Map)new Json().fromJson(receiverJson, (Type)new JsonParameterizedType(HashMap.class, new Type[]{com.inet.usersandgroups.api.ui.Type.class, new JsonParameterizedType(HashSet.class, new Type[]{GUID.class})}));
            }
            catch (JsonException jsonException) {
                // empty catch block
            }
        }
        StringBuilder targetDisplay = new StringBuilder();
        UserManager userManager = UserManager.getInstance();
        UserGroupManager groupManager = UserGroupManager.getInstance();
        HashSet users = (HashSet)receivers.get(com.inet.usersandgroups.api.ui.Type.user);
        if (users == null) {
            users = new HashSet();
        }
        if ((groups = (HashSet)receivers.get(com.inet.usersandgroups.api.ui.Type.group)) == null) {
            groups = new HashSet();
        }
        int userCount = users.size();
        int groupCount = groups.size();
        if (ServerPluginManager.getInstance().isPluginLoaded("usersandgroupsmanager") && SystemPermissionChecker.checkAccess((Permission)UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER)) {
            String firstUser = "";
            String firstGroup = "";
            for (GUID userID : users) {
                if (userID == null) continue;
                UserAccount userAccount = userManager.getUserAccount(userID);
                if (userAccount != null) {
                    if (!firstUser.isEmpty()) continue;
                    firstUser = userAccount.getDisplayName();
                    continue;
                }
                --userCount;
            }
            for (GUID groupID : groups) {
                if (groupID == null) continue;
                UserGroupInfo groupInfo = groupManager.getGroup(groupID);
                if (groupInfo != null && groupInfo.isActive()) {
                    if (!firstGroup.isEmpty()) continue;
                    firstGroup = groupInfo.getDisplayName();
                    continue;
                }
                --groupCount;
            }
            if (groupCount > 0) {
                if (groupCount == 1) {
                    targetDisplay.append(HelpDeskTaskPlannerServerPlugin.MSG.getMsg("AddTicketSharingAction.Summary.SingleGroup", new Object[]{firstGroup}));
                } else {
                    targetDisplay.append(HelpDeskTaskPlannerServerPlugin.MSG.getMsg("AddTicketSharingAction.Summary.GroupAndMore", new Object[]{firstGroup, groupCount - 1}));
                }
                if (userCount > 0) {
                    targetDisplay.append(" ");
                    targetDisplay.append(HelpDeskTaskPlannerServerPlugin.MSG.getMsg("AddTicketSharingAction.Summary.And", new Object[0]));
                    targetDisplay.append(" ");
                }
            }
            if (userCount > 0) {
                if (userCount == 1) {
                    targetDisplay.append(HelpDeskTaskPlannerServerPlugin.MSG.getMsg("AddTicketSharingAction.Summary.SingleUser", new Object[]{firstUser}));
                } else {
                    targetDisplay.append(HelpDeskTaskPlannerServerPlugin.MSG.getMsg("AddTicketSharingAction.Summary.UserAndMore", new Object[]{firstUser, userCount - 1}));
                }
            }
        } else {
            if (userCount > 0) {
                targetDisplay.append(HelpDeskTaskPlannerServerPlugin.MSG.getMsg("AddTicketSharingAction.Summary.UserCount", new Object[]{userCount}));
            }
            if (groupCount > 0) {
                if (userCount > 0) {
                    targetDisplay.append(" ");
                    targetDisplay.append(HelpDeskTaskPlannerServerPlugin.MSG.getMsg("AddTicketSharingAction.Summary.And", new Object[0]));
                    targetDisplay.append(" ");
                }
                targetDisplay.append(HelpDeskTaskPlannerServerPlugin.MSG.getMsg("AddTicketSharingAction.Summary.GroupCount", new Object[]{groupCount}));
            }
        }
        if (targetDisplay.length() == 0) {
            targetDisplay.append(HelpDeskTaskPlannerServerPlugin.MSG.getMsg("AddTicketSharingAction.Error.NoReceiver", new Object[0]));
        }
        summary.add(new SummaryEntry(HelpDeskTaskPlannerServerPlugin.MSG.getMsg("AddTicketSharingAction.Summary.Receivers", new Object[0]), targetDisplay.toString()));
        return new SummaryInfo(summary);
    }

    protected AddTicketSharingAction createInstanceFrom(ResultActionDefinition definition, GUID taskID) {
        String ticketIds = definition.getProperty("Ticket ID");
        String accessType = definition.getProperty(PROPERTY_ACCESS_TYPE);
        String receiverJson = definition.getProperty(PROPERTY_RECEIVER);
        return new AddTicketSharingAction(ticketIds, accessType, receiverJson, taskID);
    }

    public boolean isAvailable() {
        UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
        return currentUserAccount != null && HDUsersAndGroups.isSupporter((UserAccount)currentUserAccount);
    }
}

