/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.taskplanner.server;

import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.plugins.forms.server.api.TaskPlannerNotifier;
import com.inet.helpdesk.plugins.taskplanner.server.trigger.formsubmitted.FormsTriggerListener;
import com.inet.id.GUID;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nonnull;

public class FormTaskPlannerNotifierImpl
implements TaskPlannerNotifier {
    private final CopyOnWriteArrayList<FormsTriggerListener> listeners = new CopyOnWriteArrayList();

    public void notifyTaskPlanner(@Nonnull GUID formId, @Nonnull Map<String, String> fieldValues) {
        HDLogger.info((Object)("TaskPlannerNotifier \u2013 received submission of form " + String.valueOf(formId) + " with values " + String.valueOf(fieldValues)));
        for (FormsTriggerListener l : this.listeners) {
            try {
                l.formSubmitted(formId, Map.copyOf(fieldValues));
            }
            catch (Exception ex) {
                HDLogger.error((Object)ex);
            }
        }
    }

    public void addListener(@Nonnull FormsTriggerListener listener) {
        this.listeners.addIfAbsent(listener);
    }

    public void removeListener(@Nonnull FormsTriggerListener listener) {
        this.listeners.remove(listener);
    }
}

