/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.taskplanner.server;

import com.inet.config.structure.model.LocalizedKey;
import com.inet.config.structure.model.UnitConfigProperty;
import com.inet.editor.HtmlConverter;
import com.inet.field.SelectOption;
import com.inet.field.SelectOptionResult;
import com.inet.fieldsettings.api.FieldSettingsChangeListener;
import com.inet.helpdesk.core.ticketfieldsettings.TicketFieldSettingsManager;
import com.inet.helpdesk.core.ticketmanager.fields.FieldVO;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.fields.category.CategoryManager;
import com.inet.helpdesk.core.ticketmanager.fields.category.CategoryVO;
import com.inet.helpdesk.core.ticketmanager.fields.classification.ClassificationManager;
import com.inet.helpdesk.core.ticketmanager.fields.itil.ItilManager;
import com.inet.helpdesk.core.ticketmanager.fields.itil.ItilVO;
import com.inet.helpdesk.core.ticketmanager.fields.location.LocationManager;
import com.inet.helpdesk.core.ticketmanager.fields.location.LocationVO;
import com.inet.helpdesk.core.ticketmanager.fields.priority.PriorityManager;
import com.inet.helpdesk.core.ticketmanager.fields.status.StatusManager;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.core.ticketmanager.ui.model.FieldEditDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.SelectEditDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.type.AssetTypeManager;
import com.inet.helpdesk.plugins.taskplanner.HelpDeskTaskPlannerServerPlugin;
import com.inet.helpdesk.plugins.ticketprocess.server.api.TicketProcessManager;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.TicketProcess;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.helpdesk.usersandgroups.groups.HelpDeskUserGroupManager;
import com.inet.http.servlet.ClientLocale;
import com.inet.http.servlet.SessionStore;
import com.inet.id.GUID;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.plugin.Executable;
import com.inet.plugin.ServerPluginManager;
import com.inet.plugin.image.UserAvatar;
import com.inet.search.SearchResult;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.taskplanner.server.api.DataEntry;
import com.inet.taskplanner.server.api.common.AbstractDefinition;
import com.inet.taskplanner.server.api.field.BooleanField;
import com.inet.taskplanner.server.api.field.CurrencyField;
import com.inet.taskplanner.server.api.field.Field;
import com.inet.taskplanner.server.api.field.FieldCondition;
import com.inet.taskplanner.server.api.field.FloatField;
import com.inet.taskplanner.server.api.field.LabelField;
import com.inet.taskplanner.server.api.field.NumberField;
import com.inet.taskplanner.server.api.field.SelectField;
import com.inet.taskplanner.server.api.field.SelectInputField;
import com.inet.taskplanner.server.api.field.TaskFieldListGenerator;
import com.inet.taskplanner.server.api.field.TextAreaField;
import com.inet.taskplanner.server.api.field.TextField;
import com.inet.taskplanner.server.api.field.TimeField;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.UserGroupField;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.takeout.EmptyTakeoutDataRenderer;
import com.inet.usersandgroups.api.takeout.TakeoutDataRenderer;
import com.inet.usersandgroups.api.ui.Type;
import com.inet.usersandgroups.api.ui.fields.FieldDefinition;
import com.inet.usersandgroups.api.ui.fields.user.UserFieldDefinition;
import com.inet.usersandgroups.api.user.UserManager;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class FilterableFieldListGenerator
implements TaskFieldListGenerator {
    public static final int ACTION_SET_UNREAD = 947474;
    public static final int ACTION_SET_READ = 947475;
    public static final String PROPERTY_FILTER_TYPE = "FilterType";
    public static final String PROPERTY_SECOND_FILTER_AND_OR_NONE = "SecondFilterAndOrNone";
    public static final String PROPERTY_SECOND_FILTER_NONE = "SecondFilterNone";
    public static final String PROPERTY_SECOND_FILTER_AND = "SecondFilterAnd";
    public static final String PROPERTY_SECOND_FILTER_OR = "SecondFilterOr";
    public static final String PROPERTY_SECOND_FILTER_TYPE = "Second.FilterType";
    public static final String PROPERTY_SECOND_PROPERTY_PREFIX = "Second.";
    public static final String PROPERTY_FILTER_TYPE_NONE = "FilterTypeNone";
    public static final String PROPERTY_FILTER_TYPE_RESOURCE = "FilterTypeResource";
    public static final String PROPERTY_FILTER_TYPE_CUSTOMER_LOCATION = "FilterTypeCustomerLocation";
    public static final String PROPERTY_FILTER_TYPE_CATEGORY = "FilterTypeCategory";
    public static final String PROPERTY_FILTER_TYPE_OWNER_FIELD = "FilterTypeOwnerField";
    public static final String PROPERTY_FILTER_TYPE_PROCESS_FILTER = "FilterTypeProcessFilter";
    public static final String PROPERTY_FILTER_TYPE_INQUIRY_TEXT = "FilterTypeInquiryText";
    public static final String ONLY_MY_RESOURCES_DATA_ENTRY_ID = "OnlyMyResourcesDataEntryId";
    public static final String NO_RESOURCE_DATA_ENTRY_ID = "NoResourceDataEntryId";
    public static final String PROPERTY_PROCESS_FILTER_NONE = "ProcessFilter.none";
    public static final String PROPERTY_PROCESS_FILTER_ANY = "ProcessFilter.anyprocess";
    public static final String PROPERTY_PROCESS_FILTER_SPECIFIC = "ProcessFilter.specific";
    public static final String PROPERTY_PROCESS = "PropProcess";
    public static final String PROPERTY_CATEGORY = "Category";
    public static final String PROPERTY_INCLUDE_SUB_CATEGORIES = "IncludeSubcategories";
    public static final String PROPERTY_INCLUDE_SUB_RESOURCES = "IncludeSubresources";
    public static final String PROPERTY_RESOURCE = "Resource";
    public static final String PROPERTY_RESOURCE_NO_CUSTOM_ENTRY_SUFFIX = ".noCustomEntry";
    public static final String PROPERTY_RESOURCE_NO_NONE_ENTRY_SUFFIX = ".noNoneEntry";
    public static final String PROPERTY_CUSTOMER_LOCATION = "CustomerLocation";
    public static final String PROPERTY_INQUIRY_TEXT = "InquiryText";
    public static final String PROPERTY_OWNER_FIELD = "OwnerField";
    public static final String PROPERTY_OWNER_FIELD_VALUE = "OwnerFieldValue";
    public static final String PROPERTY_OWNER_FIELD_DATE_VALUE = "OwnerFieldDateValue";
    public static final String NUMBERPREBOX_EQUAL = "numberprebox.equal";
    public static final String NUMBERPREBOX_NOTEQUAL = "numberprebox.notequal";
    public static final String NUMBERPREBOX_GREATER = "numberprebox.greater";
    public static final String NUMBERPREBOX_LESSTHAN = "numberprebox.lessthan";
    public static final String PROPERTY_ACTIVITY = "PropActivity";
    public static final String PROPERTY_FILTER_TYPE_LAST_MODIFIED = "FilterTypeLastModified";
    public static final String PROPERTY_FILTER_TYPE_CREATED = "FilterTypeCreated";
    public static final String PROPERTY_LAST_MODIFIED_DATE_VALUE = "LastModifiedDateValue";
    public static final String PROPERTY_CREATED_DATE_VALUE = "CreatedDateValue";
    public static final String DATE_PERIOD_1_WEEK = "1";
    public static final String DATE_PERIOD_2_WEEKS = "2";
    public static final String DATE_PERIOD_3_WEEKS = "3";
    public static final String DATE_PERIOD_4_WEEKS = "4";
    public static final String DATE_PERIOD_5_WEEKS = "5";
    public static final String DATE_PERIOD_6_WEEKS = "6";
    public static final String DATE_PERIOD_7_WEEKS = "7";
    public static final String DATE_PERIOD_8_WEEKS = "8";
    public static final String DATE_PERIOD_3_MONTHS = "3months";
    public static final String DATE_PERIOD_6_MONTHS = "6months";
    public static final String DATE_PERIOD_1_YEAR = "1year";
    public static final String DATE_PERIOD_3_YEARS = "3years";
    public static final String PROPERTY_FILTER_TYPE_READ_STATUS = "FilterTypeReadStatus";
    public static final String PROPERTY_READ_STATUS_VALUE = "ReadStatusValue";
    public static final String READ_STATUS_UNREAD = "unread";
    public static final String READ_STATUS_READ = "read";
    private static Executable fieldSettingsChangeListenerRegistrator = new Executable(){
        private FieldSettingsChangeListener l = new FieldSettingsChangeListener(){

            public void fieldSettingChanged(String fieldKey, boolean onlyPrioWasChanged) {
                if (onlyPrioWasChanged) {
                    return;
                }
                FilterableFieldListGenerator.getInstance().regenerateFilterableFieldList();
            }
        };

        public void execute() {
            TicketFieldSettingsManager instance = TicketFieldSettingsManager.getInstance();
            instance.removeChangeListener(this.l);
            instance.addChangeListener(this.l);
        }
    };
    private Map<String, ArrayList<LocalizedKey>> filterTypeValues = new HashMap<String, ArrayList<LocalizedKey>>();
    private List<LocalizedKey> ownerFieldKeys = new ArrayList<LocalizedKey>();
    private SelectField filterType;
    private SelectField secondFilterType;
    private SelectField secondFilterAndOrNone;
    static TicketProcessManager tpmInstance;

    public static FilterableFieldListGenerator getInstance() {
        List taskFieldListGenerators = ServerPluginManager.getInstance().get(TaskFieldListGenerator.class);
        for (TaskFieldListGenerator g : taskFieldListGenerators) {
            if (!(g instanceof FilterableFieldListGenerator)) continue;
            ServerPluginManager.getInstance().runIfPluginLoaded("fieldsettings", () -> fieldSettingsChangeListenerRegistrator);
            return (FilterableFieldListGenerator)g;
        }
        throw new IllegalStateException("no filterable field list generator found!");
    }

    private static DataEntry entryFrom(String key, String displayName, int typeId, int level) {
        return FilterableFieldListGenerator.entryFrom(key, key, displayName, typeId, level);
    }

    private static DataEntry entryFrom(String key, String iconKey, String displayName, int typeId, int level) {
        String icon = SessionStore.getRootURL() + "images/data/" + typeId + "/" + (typeId == 4 ? "" : iconKey);
        return new DataEntry(key, displayName, icon, level);
    }

    public static void updateResourceDisplayValueIfNecessary(AbstractDefinition definition) {
        String resIfCustomEntry;
        if (PROPERTY_FILTER_TYPE_RESOURCE.equals(definition.getProperty(PROPERTY_FILTER_TYPE))) {
            resIfCustomEntry = definition.getProperty(PROPERTY_RESOURCE);
            if (ONLY_MY_RESOURCES_DATA_ENTRY_ID.equals(resIfCustomEntry)) {
                definition.setProperty("Resource.display", HelpDeskTaskPlannerServerPlugin.MSG.getMsg("TicketCreatedSeries.onlymyresources", new Object[0]));
            } else if (NO_RESOURCE_DATA_ENTRY_ID.equals(resIfCustomEntry)) {
                definition.setProperty("Resource.display", HelpDeskTaskPlannerServerPlugin.MSG.getMsg("TicketCreatedSeries.noresource", new Object[0]));
            }
        }
        if (PROPERTY_FILTER_TYPE_RESOURCE.equals(definition.getProperty(PROPERTY_SECOND_FILTER_TYPE))) {
            resIfCustomEntry = definition.getProperty("Second.Resource");
            if (ONLY_MY_RESOURCES_DATA_ENTRY_ID.equals(resIfCustomEntry)) {
                definition.setProperty("Second.Resource.display", HelpDeskTaskPlannerServerPlugin.MSG.getMsg("TicketCreatedSeries.onlymyresources", new Object[0]));
            } else if (NO_RESOURCE_DATA_ENTRY_ID.equals(resIfCustomEntry)) {
                definition.setProperty("Second.Resource.display", HelpDeskTaskPlannerServerPlugin.MSG.getMsg("TicketCreatedSeries.noresource", new Object[0]));
            }
        }
    }

    private String currentLanguage() {
        return ClientLocale.getThreadLocale().toLanguageTag();
    }

    public List<DataEntry> getEntriesFor(String fieldType, String filter, String customValue) {
        if (fieldType.startsWith(PROPERTY_SECOND_PROPERTY_PREFIX)) {
            fieldType = fieldType.substring(PROPERTY_SECOND_PROPERTY_PREFIX.length());
        }
        if (fieldType.endsWith("." + Tickets.FIELD_OWNER_GUID.getKey()) || fieldType.equals("userValueToSet")) {
            ArrayList<SearchExpression> additionalExpressions = new ArrayList<SearchExpression>();
            additionalExpressions.add((SearchExpression)new SearchCondition("useraccountid", SearchCondition.SearchTermOperator.StartsWith, (Object)""));
            return this.searchUsers(filter, additionalExpressions);
        }
        List<DataEntry> allEntries = this.getAllEntriesFor(fieldType);
        if (allEntries == null) {
            List fieldDefs = DynamicExtensionManager.getInstance().get(TicketFieldDefinition.class);
            Collections.sort(fieldDefs, Comparator.comparingInt(TicketFieldDefinition::getPriority));
            for (TicketFieldDefinition d : fieldDefs) {
                FieldEditDefinition editDef;
                if (!fieldType.endsWith("." + d.getKey()) && !fieldType.equals(d.getKey()) || !((editDef = d.getEditDefinition()) instanceof SelectEditDefinition)) continue;
                SelectOptionResult selectOptions = ((SelectEditDefinition)editDef).getSelectOptions(new ArrayList(), "", 10000, 0);
                List options = selectOptions.getOptions();
                int typeID = -12345;
                if (Tickets.FIELD_CATEGORY_ID.getKey().equals(d.getKey())) {
                    typeID = 4;
                } else if (Tickets.FIELD_CLASSIFICATION_ID.getKey().equals(d.getKey())) {
                    typeID = 3;
                } else if (Tickets.FIELD_ITIL_ID.getKey().equals(d.getKey())) {
                    typeID = 7;
                } else if (Tickets.FIELD_PRIORITY_ID.getKey().equals(d.getKey())) {
                    typeID = 2;
                }
                int typeID_ = typeID;
                return options.stream().map(o -> FilterableFieldListGenerator.entryFrom(o.getValue(), o.getLabel(), typeID_, 0)).collect(Collectors.toList());
            }
            return null;
        }
        return allEntries.stream().filter(e -> e.getLabel().toLowerCase().contains(filter.toLowerCase())).collect(Collectors.toList());
    }

    protected List<DataEntry> searchUsers(String filter, ArrayList<SearchExpression> additionalExpressions) {
        SearchResult search = UserManager.getInstance().searchAsUser(filter, additionalExpressions, new ArrayList(), 50, null);
        return search.getEntries().stream().map(e -> {
            String icon = "data:image/png;base64," + Base64.getEncoder().encodeToString(UserAvatar.getCircleAvatar((GUID)((GUID)e.getId()), (int)32));
            return new DataEntry(String.valueOf(e.getId()), HtmlConverter.html2text((String)e.getFirstResultLine()), icon, 0);
        }).collect(Collectors.toList());
    }

    private List<DataEntry> getAllEntriesFor(String fieldType) {
        switch (fieldType) {
            case "Category": {
                return this.getCategoryKeys();
            }
            case "CustomerLocation": {
                return this.getCustomerLocationKeys();
            }
            case "Resource": {
                return this.getResourceKeys(true, true);
            }
            case "Resource.noNoneEntry": {
                return this.getResourceKeys(true, false);
            }
            case "Resource.noCustomEntry": {
                return this.getResourceKeys(false, false);
            }
            case "statusFilter": {
                return this.getStatusKeys();
            }
            case "deviceTypeFilter": {
                if (ServerPluginManager.getInstance().isPluginLoaded("inventory")) {
                    return this.getDeviceTypeKeys();
                }
                return null;
            }
            case "PROPERTY_ACTION_TO_TRIGGER_ON": {
                return this.getActionKeys();
            }
            case "PROPERTY_ACTION_TO_APPLY": {
                Predicate<ActionVO> toExclude = FilterableFieldListGenerator.getActionsToExcludeForApply();
                ActionManager instance = ActionManager.getInstance();
                ArrayList<DataEntry> actionKeys = this.getActionKeys();
                actionKeys.add(new DataEntry("947474", HelpDeskTaskPlannerServerPlugin.MSG.getMsg("action.setunread", new Object[0]), "", 0));
                actionKeys.add(new DataEntry("947475", HelpDeskTaskPlannerServerPlugin.MSG.getMsg("action.setread", new Object[0]), "", 0));
                return actionKeys.stream().filter(e -> {
                    int id = Integer.valueOf(e.getValue());
                    if (id == 947474 || id == 947475) {
                        return true;
                    }
                    ActionVO actionVO = (ActionVO)instance.get(id);
                    return actionVO != null && !((ActionVO)instance.get(id)).isInternal() && !toExclude.test(actionVO);
                }).collect(Collectors.toList());
            }
        }
        return null;
    }

    private static Predicate<ActionVO> getActionsToExcludeForApply() {
        HashSet<Integer> excludeIds = new HashSet<Integer>();
        excludeIds.add(-21);
        excludeIds.add(-6);
        excludeIds.add(6);
        excludeIds.add(8);
        excludeIds.add(-1);
        excludeIds.add(-13);
        excludeIds.add(-19);
        excludeIds.add(-37);
        excludeIds.add(-214);
        excludeIds.add(-38);
        return action -> excludeIds.contains(action.getId()) || action.getStatusID() == 101;
    }

    public List<DataEntry> getEntriesFor(String fieldType) {
        return this.getEntriesFor(fieldType, "", "");
    }

    private List<DataEntry> getDeviceTypeKeys() {
        List all = AssetTypeManager.getInstance().getAll(true);
        ArrayList keys = all.stream().sorted((a1, a2) -> FilterableFieldListGenerator.getCollator().compare(a1.getDisplayValue(), a2.getDisplayValue())).map(e -> {
            String displayName = "".equals(e.getDisplayValue()) ? HelpDeskTaskPlannerServerPlugin.MSG.getMsg("novalue", new Object[0]) : e.getDisplayValue();
            return FilterableFieldListGenerator.entryFrom("" + e.getId(), displayName, 14, 0);
        }).collect(Collectors.toCollection(ArrayList::new));
        keys.add(new DataEntry("", HelpDeskTaskPlannerServerPlugin.MSG.getMsg("WorkflowFilter.any", new Object[0]), null, 0));
        return keys;
    }

    private void regenerateFilterableFieldList() {
        this.filterTypeValues.clear();
        this.generateFilterableFieldList(true);
    }

    public List<Field> generateFilterableFieldList() {
        return this.generateFilterableFieldList(true);
    }

    public List<Field> generateFilterableFieldList(boolean includeNone) {
        HashSet<String> filterTypes = new HashSet<String>(Arrays.asList(PROPERTY_FILTER_TYPE_RESOURCE, PROPERTY_FILTER_TYPE_CATEGORY, PROPERTY_FILTER_TYPE_INQUIRY_TEXT, PROPERTY_FILTER_TYPE_READ_STATUS, PROPERTY_FILTER_TYPE_OWNER_FIELD, PROPERTY_FILTER_TYPE_CUSTOMER_LOCATION, PROPERTY_FILTER_TYPE_PROCESS_FILTER, PROPERTY_FILTER_TYPE_LAST_MODIFIED, PROPERTY_FILTER_TYPE_CREATED));
        ArrayList<Field> fields = new ArrayList<Field>();
        ArrayList<LocalizedKey> keysWeHave = this.filterTypeValues.getOrDefault(this.currentLanguage(), new ArrayList());
        ArrayList<LocalizedKey> localizedFilterTypes = this.generateFieldChooserKeys(keysWeHave, filterTypes);
        keysWeHave = localizedFilterTypes;
        localizedFilterTypes.removeIf(l -> Tickets.FIELD_ADDITIONAL_ACCESS.getKey().equals(l.getKey()));
        if (!SystemPermissionChecker.checkAccess((Permission)UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER)) {
            localizedFilterTypes.removeIf(l -> Tickets.FIELD_OWNER_GUID.getKey().equals(l.getKey()));
        }
        this.filterTypeValues.put(this.currentLanguage(), localizedFilterTypes);
        this.filterType = new SelectField(PROPERTY_FILTER_TYPE, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("FilterTypeLabel", new Object[0]), keysWeHave);
        this.filterType.setValue(PROPERTY_FILTER_TYPE_NONE);
        fields.add((Field)this.filterType);
        String suffix = includeNone ? "" : PROPERTY_RESOURCE_NO_NONE_ENTRY_SUFFIX;
        this.addSelectionFields("", "", suffix, this.filterType, filterTypes, fields);
        if (filterTypes.contains(PROPERTY_FILTER_TYPE_LAST_MODIFIED)) {
            this.addDateFilterFields("", this.filterType, PROPERTY_FILTER_TYPE_LAST_MODIFIED, "LastModified", fields);
        }
        if (filterTypes.contains(PROPERTY_FILTER_TYPE_CREATED)) {
            this.addDateFilterFields("", this.filterType, PROPERTY_FILTER_TYPE_CREATED, "Created", fields);
        }
        ArrayList<LocalizedKey> andOrNone = new ArrayList<LocalizedKey>();
        andOrNone.add(new LocalizedKey(PROPERTY_SECOND_FILTER_NONE, HelpDeskTaskPlannerServerPlugin.MSG.getMsg(PROPERTY_SECOND_FILTER_NONE, new Object[0])));
        andOrNone.add(new LocalizedKey(PROPERTY_SECOND_FILTER_AND, HelpDeskTaskPlannerServerPlugin.MSG.getMsg(PROPERTY_SECOND_FILTER_AND, new Object[0])));
        andOrNone.add(new LocalizedKey(PROPERTY_SECOND_FILTER_OR, HelpDeskTaskPlannerServerPlugin.MSG.getMsg(PROPERTY_SECOND_FILTER_OR, new Object[0])));
        this.secondFilterAndOrNone = new SelectField(PROPERTY_SECOND_FILTER_AND_OR_NONE, "", andOrNone);
        this.secondFilterAndOrNone.setValue(PROPERTY_SECOND_FILTER_NONE);
        ArrayList<FieldCondition> showSecondFilterAndOrNone = new ArrayList<FieldCondition>();
        showSecondFilterAndOrNone.add(FieldCondition.visible((Field)this.filterType, (FieldCondition.OP)FieldCondition.OP.notequal, (String)PROPERTY_FILTER_TYPE_NONE));
        this.secondFilterAndOrNone.setConditions(showSecondFilterAndOrNone);
        fields.add((Field)this.secondFilterAndOrNone);
        this.secondFilterType = new SelectField(PROPERTY_SECOND_FILTER_TYPE, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("SecondFilterTypeLabel", new Object[0]), keysWeHave);
        this.secondFilterType.setValue(PROPERTY_FILTER_TYPE_NONE);
        ArrayList<FieldCondition> showSecondFilterType = new ArrayList<FieldCondition>();
        showSecondFilterType.add(FieldCondition.visible((Field)this.filterType, (FieldCondition.OP)FieldCondition.OP.notequal, (String)PROPERTY_FILTER_TYPE_NONE));
        showSecondFilterType.add(FieldCondition.disabled((Field)this.secondFilterAndOrNone, (FieldCondition.OP)FieldCondition.OP.equals, (String)PROPERTY_SECOND_FILTER_NONE));
        this.secondFilterType.setConditions(showSecondFilterType);
        fields.add((Field)this.secondFilterType);
        int fieldIndex = fields.size();
        this.addSelectionFields("", PROPERTY_SECOND_PROPERTY_PREFIX, suffix, this.secondFilterType, filterTypes, fields);
        fields.subList(fieldIndex, fields.size()).forEach(field -> {
            List conditions = field.getConditions();
            ArrayList<FieldCondition> conds = new ArrayList<FieldCondition>(conditions == null ? new ArrayList() : conditions);
            conds.add(FieldCondition.disabled((Field)this.secondFilterAndOrNone, (FieldCondition.OP)FieldCondition.OP.equals, (String)PROPERTY_SECOND_FILTER_NONE));
            field.setConditions(conds);
        });
        if (filterTypes.contains(PROPERTY_FILTER_TYPE_LAST_MODIFIED)) {
            this.addDateFilterFields(PROPERTY_SECOND_PROPERTY_PREFIX, this.secondFilterType, PROPERTY_FILTER_TYPE_LAST_MODIFIED, "LastModified", fields);
        }
        if (filterTypes.contains(PROPERTY_FILTER_TYPE_CREATED)) {
            this.addDateFilterFields(PROPERTY_SECOND_PROPERTY_PREFIX, this.secondFilterType, PROPERTY_FILTER_TYPE_CREATED, "Created", fields);
        }
        return fields;
    }

    private void addDateFilterFields(String propertyKeyPrefix, SelectField filterType, String filterTypeConstant, String baseName, List<Field> fields) {
        ArrayList<LocalizedKey> modeOptions = new ArrayList<LocalizedKey>();
        modeOptions.add(new LocalizedKey("within", HelpDeskTaskPlannerServerPlugin.MSG.getMsg("dateFilter.mode.within", new Object[0])));
        modeOptions.add(new LocalizedKey("before", HelpDeskTaskPlannerServerPlugin.MSG.getMsg("dateFilter.mode.before", new Object[0])));
        SelectField modeField = new SelectField(propertyKeyPrefix + baseName + "DateMode", HelpDeskTaskPlannerServerPlugin.MSG.getMsg("dateFilter.mode.label", new Object[0]), modeOptions);
        modeField.setValue("within");
        modeField.setConditions(Arrays.asList(FieldCondition.visible((Field)filterType, (FieldCondition.OP)FieldCondition.OP.equals, (String)filterTypeConstant)));
        fields.add((Field)modeField);
        String dateChoicesKey = propertyKeyPrefix + (baseName.equals("LastModified") ? PROPERTY_LAST_MODIFIED_DATE_VALUE : PROPERTY_CREATED_DATE_VALUE);
        SelectField dateChoicesField = FilterableFieldListGenerator.generateDateChoicesPicker(dateChoicesKey, "");
        dateChoicesField.setConditions(Arrays.asList(FieldCondition.visible((Field)filterType, (FieldCondition.OP)FieldCondition.OP.equals, (String)filterTypeConstant)));
        fields.add((Field)dateChoicesField);
    }

    public ArrayList<LocalizedKey> generateFieldChooserKeys(ArrayList<LocalizedKey> keysWeHave, Set<String> filterTypes) {
        HashSet<LocalizedKey> currList = new HashSet<LocalizedKey>(keysWeHave);
        currList.add(new LocalizedKey(PROPERTY_FILTER_TYPE_NONE, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("FilterType.None", new Object[0])));
        if (filterTypes.contains(PROPERTY_FILTER_TYPE_RESOURCE)) {
            currList.add(new LocalizedKey(PROPERTY_FILTER_TYPE_RESOURCE, Tickets.FIELD_RESOURCE_GUID.getLabel()));
        }
        if (filterTypes.contains(PROPERTY_FILTER_TYPE_CUSTOMER_LOCATION)) {
            currList.add(new LocalizedKey(PROPERTY_FILTER_TYPE_CUSTOMER_LOCATION, HDUsersAndGroups.FIELD_LOCATION_ID.getLabel()));
        }
        if (filterTypes.contains(PROPERTY_FILTER_TYPE_CATEGORY)) {
            currList.add(new LocalizedKey(PROPERTY_FILTER_TYPE_CATEGORY, Tickets.FIELD_CATEGORY_ID.getLabel()));
        }
        if (filterTypes.contains(PROPERTY_FILTER_TYPE_INQUIRY_TEXT)) {
            currList.add(new LocalizedKey(PROPERTY_FILTER_TYPE_INQUIRY_TEXT, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("FilterType.inquiryText", new Object[0])));
        }
        if (filterTypes.contains(PROPERTY_FILTER_TYPE_READ_STATUS)) {
            currList.add(new LocalizedKey(PROPERTY_FILTER_TYPE_READ_STATUS, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("FilterType.readStatus", new Object[0])));
        }
        if (filterTypes.contains(PROPERTY_FILTER_TYPE_OWNER_FIELD)) {
            currList.add(new LocalizedKey(PROPERTY_FILTER_TYPE_OWNER_FIELD, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ownerfield.choose", new Object[0])));
        }
        if (filterTypes.contains(PROPERTY_FILTER_TYPE_LAST_MODIFIED)) {
            currList.add(new LocalizedKey(PROPERTY_FILTER_TYPE_LAST_MODIFIED, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("FilterType.lastModified", new Object[0])));
        }
        if (filterTypes.contains(PROPERTY_FILTER_TYPE_CREATED)) {
            currList.add(new LocalizedKey(PROPERTY_FILTER_TYPE_CREATED, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("FilterType.created", new Object[0])));
        }
        if (ServerPluginManager.getInstance().isPluginLoaded("ticketprocess") && filterTypes.contains(PROPERTY_FILTER_TYPE_PROCESS_FILTER)) {
            currList.add(new LocalizedKey(PROPERTY_FILTER_TYPE_PROCESS_FILTER, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ProcessFilter.choose", new Object[0])));
        }
        this.addDynamicTicketFields(currList);
        currList.add(new LocalizedKey(Tickets.FIELD_ADDITIONAL_ACCESS.getKey(), Tickets.FIELD_ADDITIONAL_ACCESS.getLabel()));
        ArrayList localizedFilterTypes = currList.stream().sorted((o1, o2) -> {
            if (o1.getKey().equals(PROPERTY_FILTER_TYPE_NONE)) {
                return -1;
            }
            if (o2.getKey().equals(PROPERTY_FILTER_TYPE_NONE)) {
                return 1;
            }
            return FilterableFieldListGenerator.getCollator().compare(o1.getDisplayName(), o2.getDisplayName());
        }).collect(Collectors.toCollection(ArrayList::new));
        return localizedFilterTypes;
    }

    private void addDynamicTicketFields(Set<LocalizedKey> currList) {
        List fieldDefs = DynamicExtensionManager.getInstance().get(TicketFieldDefinition.class);
        Collections.sort(fieldDefs, Comparator.comparingInt(TicketFieldDefinition::getPriority));
        block19: for (TicketFieldDefinition d : fieldDefs) {
            String displayType;
            FieldEditDefinition edit = d.getEditDefinition();
            if (edit == null || !edit.isAvailable(null) || Tickets.FIELD_CATEGORY_ID.getKey().equals(edit.getFieldKey()) || Tickets.FIELD_RESOURCE_GUID.getKey().equals(edit.getFieldKey())) continue;
            switch (displayType = edit.getDisplayType()) {
                case "double": 
                case "integer": 
                case "timeonlyvalue": 
                case "currency": 
                case "textinput": 
                case "boolean": 
                case "textarea": 
                case "datevalue": 
                case "dateonlyvalue": {
                    TicketField<Object> fieldByKey = this.getByKey(edit);
                    currList.add(new LocalizedKey(edit.getFieldKey(), d.getLabel()));
                    break;
                }
                case "select": 
                case "selecteditable": 
                case "selectmulti": 
                case "itilselect": {
                    if (!(edit instanceof SelectEditDefinition)) break;
                    SelectOptionResult selectOptions = ((SelectEditDefinition)edit).getSelectOptions(new ArrayList(), "", 10000, 0);
                    List options = selectOptions.getOptions();
                    if (options.size() <= 0) continue block19;
                    currList.add(new LocalizedKey(edit.getFieldKey(), this.getByKey(edit).getLabel()));
                    break;
                }
            }
        }
        if (SystemPermissionChecker.checkAccess((Permission)UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER)) {
            currList.add(new LocalizedKey(Tickets.FIELD_OWNER_GUID.getKey(), HelpDeskTaskPlannerServerPlugin.MSG.getMsg("owner.choose", new Object[0])));
        }
    }

    protected TicketField<Object> getByKey(FieldEditDefinition edit) {
        return Tickets.getFieldByKey((String)edit.getFieldKey());
    }

    public void addSelectionFields(String labelKeyPrefix, String propertyKeySuffix, SelectField filterType, Set<String> filterTypes, List<Field> fields) {
        this.addSelectionFields(labelKeyPrefix, "", propertyKeySuffix, filterType, filterTypes, fields);
    }

    public void addSelectionFields(String labelKeyPrefix, String propertyKeyPrefix, String propertyKeySuffix, SelectField filterType, Set<String> filterTypes, List<Field> fields) {
        SelectInputField field;
        if (filterTypes.contains(PROPERTY_FILTER_TYPE_RESOURCE)) {
            SelectInputField field2 = new SelectInputField(propertyKeyPrefix + PROPERTY_RESOURCE + propertyKeySuffix, HelpDeskTaskPlannerServerPlugin.MSG.getMsg(labelKeyPrefix + PROPERTY_RESOURCE, new Object[0]), 1);
            field2.setConditions(Arrays.asList(FieldCondition.visible((Field)filterType, (FieldCondition.OP)FieldCondition.OP.equals, (String)PROPERTY_FILTER_TYPE_RESOURCE)));
            field2.setAllowCustomValues(true);
            ArrayList<DataEntry> resourceKeys = this.getResourceKeys(false, false);
            if (resourceKeys.size() > 0) {
                String resId = resourceKeys.get(0).getValue();
                field2.setValue(resId);
                field2.setDisplay(resourceKeys.get(0).getLabel());
            }
            BooleanField includeSub = new BooleanField(propertyKeyPrefix + PROPERTY_INCLUDE_SUB_RESOURCES, HelpDeskTaskPlannerServerPlugin.MSG.getMsg(PROPERTY_INCLUDE_SUB_RESOURCES, new Object[0]));
            List<FieldCondition> resConditions = Arrays.asList(FieldCondition.visible((Field)filterType, (FieldCondition.OP)FieldCondition.OP.equals, (String)PROPERTY_FILTER_TYPE_RESOURCE));
            includeSub.setConditions(resConditions);
            fields.add((Field)field2);
            fields.add((Field)includeSub);
        }
        if (filterTypes.contains(PROPERTY_FILTER_TYPE_CUSTOMER_LOCATION)) {
            List locations = LocationManager.getInstance().getAll(true);
            field = new SelectInputField(propertyKeyPrefix + PROPERTY_CUSTOMER_LOCATION, HelpDeskTaskPlannerServerPlugin.MSG.getMsg(labelKeyPrefix + PROPERTY_CUSTOMER_LOCATION, new Object[0]), 5);
            field.setConditions(Arrays.asList(FieldCondition.visible((Field)filterType, (FieldCondition.OP)FieldCondition.OP.equals, (String)PROPERTY_FILTER_TYPE_CUSTOMER_LOCATION)));
            field.setAllowCustomValues(true);
            if (locations.size() > 0) {
                LocationVO locationVO = (LocationVO)locations.get(0);
                field.setValue("" + locationVO.getId());
                field.setDisplay(locationVO.getDisplayValue());
            }
            fields.add((Field)field);
        }
        if (filterTypes.contains(PROPERTY_FILTER_TYPE_CATEGORY)) {
            List all = CategoryManager.getInstance().getAll(true);
            field = new SelectInputField(propertyKeyPrefix + PROPERTY_CATEGORY, HelpDeskTaskPlannerServerPlugin.MSG.getMsg(labelKeyPrefix + PROPERTY_CATEGORY, new Object[0]), 4);
            List<FieldCondition> catConditions = Arrays.asList(FieldCondition.visible((Field)filterType, (FieldCondition.OP)FieldCondition.OP.equals, (String)PROPERTY_FILTER_TYPE_CATEGORY));
            field.setAllowCustomValues(true);
            field.setConditions(catConditions);
            if (all.size() > 0) {
                String label = ((CategoryVO)all.get(0)).getDisplayValue();
                field.setValue("" + ((CategoryVO)all.get(0)).getId());
                field.setDisplay(label.isEmpty() ? HelpDeskTaskPlannerServerPlugin.MSG.getMsg("novalue", new Object[0]) : label);
            }
            BooleanField includeSub = new BooleanField(propertyKeyPrefix + PROPERTY_INCLUDE_SUB_CATEGORIES, HelpDeskTaskPlannerServerPlugin.MSG.getMsg(PROPERTY_INCLUDE_SUB_CATEGORIES, new Object[0]));
            List<FieldCondition> onlyIfNotEmpty = Arrays.asList(FieldCondition.visible((Field)field, (FieldCondition.OP)FieldCondition.OP.notequal, (String)"0"));
            includeSub.setConditions(onlyIfNotEmpty);
            includeSub.setValue("true");
            fields.add((Field)field);
            fields.add((Field)includeSub);
        }
        if (filterTypes.contains(PROPERTY_FILTER_TYPE_INQUIRY_TEXT)) {
            TextField inquiryField = new TextField(propertyKeyPrefix + PROPERTY_INQUIRY_TEXT, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("inquiryText.contains", new Object[0]));
            inquiryField.setConditions(Arrays.asList(FieldCondition.visible((Field)filterType, (FieldCondition.OP)FieldCondition.OP.equals, (String)PROPERTY_FILTER_TYPE_INQUIRY_TEXT)));
            fields.add((Field)inquiryField);
        }
        if (filterTypes.contains(PROPERTY_FILTER_TYPE_READ_STATUS)) {
            ArrayList<LocalizedKey> readStatusValues = new ArrayList<LocalizedKey>();
            readStatusValues.add(new LocalizedKey(READ_STATUS_UNREAD, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ReadStatus.unread", new Object[0])));
            readStatusValues.add(new LocalizedKey(READ_STATUS_READ, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ReadStatus.read", new Object[0])));
            SelectField readStatusField = new SelectField(propertyKeyPrefix + PROPERTY_READ_STATUS_VALUE, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("FilterType.readStatus", new Object[0]), readStatusValues);
            readStatusField.setValue(READ_STATUS_UNREAD);
            readStatusField.setConditions(Arrays.asList(FieldCondition.visible((Field)filterType, (FieldCondition.OP)FieldCondition.OP.equals, (String)PROPERTY_FILTER_TYPE_READ_STATUS)));
            fields.add((Field)readStatusField);
        }
        if (filterTypes.contains(PROPERTY_FILTER_TYPE_OWNER_FIELD)) {
            ArrayList data;
            List<FieldDefinition> fieldDefinitions = this.getEligibleUserFieldDefinitions();
            this.ownerFieldKeys = data = fieldDefinitions.stream().map(f -> new LocalizedKey(f.getFieldKey(), f.getLabel())).collect(Collectors.toCollection(ArrayList::new));
            SelectField s = new SelectField(propertyKeyPrefix + PROPERTY_OWNER_FIELD, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ownerfield.choose", new Object[0]), data);
            s.setConditions(Arrays.asList(FieldCondition.visible((Field)filterType, (FieldCondition.OP)FieldCondition.OP.equals, (String)PROPERTY_FILTER_TYPE_OWNER_FIELD)));
            s.setValue(((LocalizedKey)data.get(0)).getKey());
            fields.add((Field)s);
            List dateFields = fieldDefinitions.stream().filter(f -> "fieldtype_date".equals(f.getDisplayType()) || "fieldtype_date_time".equals(f.getDisplayType())).collect(Collectors.toList());
            fieldDefinitions.removeAll(dateFields);
            List<FieldCondition> dateConditions = dateFields.size() > 0 ? dateFields.stream().map(f -> FieldCondition.visible((Field)s, (FieldCondition.OP)FieldCondition.OP.equals, (String)f.getFieldKey())).collect(Collectors.toList()) : List.of(FieldCondition.visible((Field)s, (FieldCondition.OP)FieldCondition.OP.equals, (String)"somethingwhichiscertainlyNOTafieldkey"));
            List notDateConditions = fieldDefinitions.stream().map(f -> FieldCondition.visible((Field)s, (FieldCondition.OP)FieldCondition.OP.equals, (String)f.getFieldKey())).collect(Collectors.toList());
            TextField ownerField = new TextField(propertyKeyPrefix + PROPERTY_OWNER_FIELD_VALUE, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ownerfield.contains", new Object[0]));
            ownerField.setConditions(notDateConditions);
            fields.add((Field)ownerField);
            SelectField dateChoicesPicker = FilterableFieldListGenerator.generateDateChoicesPicker(propertyKeyPrefix + PROPERTY_OWNER_FIELD_DATE_VALUE, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("withinWeeksLabel", new Object[0]));
            dateChoicesPicker.setConditions(dateConditions);
            fields.add((Field)dateChoicesPicker);
        }
        if (ServerPluginManager.getInstance().isPluginLoaded("ticketprocess")) {
            ArrayList<LocalizedKey> pFilterTypeValues = new ArrayList<LocalizedKey>();
            pFilterTypeValues.add(new LocalizedKey(PROPERTY_PROCESS_FILTER_ANY, HelpDeskTaskPlannerServerPlugin.MSG.getMsg(PROPERTY_PROCESS_FILTER_ANY, new Object[0])));
            pFilterTypeValues.add(new LocalizedKey(PROPERTY_PROCESS_FILTER_NONE, HelpDeskTaskPlannerServerPlugin.MSG.getMsg(PROPERTY_PROCESS_FILTER_NONE, new Object[0])));
            pFilterTypeValues.add(new LocalizedKey(PROPERTY_PROCESS_FILTER_SPECIFIC, HelpDeskTaskPlannerServerPlugin.MSG.getMsg(PROPERTY_PROCESS_FILTER_SPECIFIC, new Object[0])));
            SelectField processField = new SelectField(propertyKeyPrefix + PROPERTY_FILTER_TYPE_PROCESS_FILTER, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ProcessFilter.name", new Object[0]), pFilterTypeValues);
            processField.setValue(PROPERTY_PROCESS_FILTER_ANY);
            processField.setConditions(Arrays.asList(FieldCondition.visible((Field)filterType, (FieldCondition.OP)FieldCondition.OP.equals, (String)PROPERTY_FILTER_TYPE_PROCESS_FILTER)));
            ArrayList<LocalizedKey> values = new ArrayList<LocalizedKey>();
            SelectField specificProcessField = new SelectField(propertyKeyPrefix + PROPERTY_PROCESS, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ProcessFilter.specific.whichprocess", new Object[0]), values);
            TicketProcessManager ticketProcessManager = FilterableFieldListGenerator.getTPMInstance();
            ArrayList processes = ticketProcessManager != null ? ticketProcessManager.getProcesses().stream().sorted(new Comparator<TicketProcess>(){

                @Override
                public int compare(TicketProcess o1, TicketProcess o2) {
                    Collator collator = Collator.getInstance();
                    collator.setStrength(1);
                    collator.setDecomposition(1);
                    return collator.compare(o1.getName(), o2.getName());
                }
            }).collect(Collectors.toList()) : new ArrayList();
            List<FieldCondition> visibleCondition = Arrays.asList(FieldCondition.visible((Field)processField, (FieldCondition.OP)FieldCondition.OP.equals, (String)PROPERTY_PROCESS_FILTER_SPECIFIC));
            specificProcessField.setConditions(visibleCondition);
            processes.forEach(p -> values.add(new LocalizedKey(p.getId().toString(), p.getName())));
            fields.add((Field)processField);
            if (values.size() > 0) {
                specificProcessField.setValue(((LocalizedKey)values.get(0)).getKey());
                fields.add((Field)specificProcessField);
                values.forEach(k -> {
                    TicketProcess process = processes.stream().filter(p -> p.getId().toString().equals(k.getKey())).findFirst().orElse(null);
                    if (process == null) {
                        return;
                    }
                    ArrayList<LocalizedKey> activityValues = new ArrayList<LocalizedKey>();
                    process.getActivities().forEach(activity -> activityValues.add(new LocalizedKey(activity.getId().toString(), activity.getName())));
                    process.getParallelTickets().forEach(t -> t.getActivities().forEach(activity -> activityValues.add(new LocalizedKey(activity.getId().toString(), HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ProcessFilter.specific.activityInParallelTicket", new Object[]{activity.getName(), t.getName()})))));
                    activityValues.add(0, new LocalizedKey("", HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ProcessFilter.anyactivity", new Object[0])));
                    SelectField activityField = new SelectField(propertyKeyPrefix + "." + String.valueOf(process.getId()) + ".PropActivity", HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ProcessFilter.specific.whichactivity", new Object[0]), activityValues);
                    List<FieldCondition> activityVisibleCondition = Arrays.asList(FieldCondition.visible((Field)specificProcessField, (FieldCondition.OP)FieldCondition.OP.equals, (String)k.getKey()));
                    activityField.setValue("");
                    activityField.setConditions(activityVisibleCondition);
                    fields.add((Field)activityField);
                });
            } else {
                LabelField label = new LabelField("noprocesses", HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ProcessFilter.specific.whichprocess", new Object[0]), HelpDeskTaskPlannerServerPlugin.MSG.getMsg("StartProcess.NoProcessesAvailable", new Object[0]));
                label.setConditions(visibleCondition);
                fields.add((Field)label);
            }
        }
        if (!PROPERTY_RESOURCE_NO_CUSTOM_ENTRY_SUFFIX.equals(propertyKeySuffix)) {
            List fieldDefs = DynamicExtensionManager.getInstance().get(TicketFieldDefinition.class);
            Collections.sort(fieldDefs, Comparator.comparingInt(TicketFieldDefinition::getPriority));
            for (TicketFieldDefinition d : fieldDefs) {
                FieldEditDefinition edit = d.getEditDefinition();
                if (edit == null || !edit.isAvailable(null) || Tickets.FIELD_CATEGORY_ID.getKey().equals(edit.getFieldKey()) || Tickets.FIELD_RESOURCE_GUID.getKey().equals(edit.getFieldKey())) continue;
                List<Field> customFieldFields = this.generateFieldsFor(propertyKeyPrefix, edit);
                for (Field customField : customFieldFields) {
                    customField.setConditions(Arrays.asList(FieldCondition.visible((Field)filterType, (FieldCondition.OP)FieldCondition.OP.equals, (String)edit.getFieldKey())));
                    fields.add(customField);
                }
            }
            if (SystemPermissionChecker.checkAccess((Permission)UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER)) {
                SelectInputField ownerSelect = new SelectInputField("fflg." + propertyKeyPrefix + Tickets.FIELD_OWNER_GUID.getKey(), HelpDeskTaskPlannerServerPlugin.MSG.getMsg(labelKeyPrefix + "Owner", new Object[0]), 13);
                ownerSelect.setPlaceholder(HelpDeskTaskPlannerServerPlugin.MSG.getMsg("owner.placeholder", new Object[0]));
                ownerSelect.setConditions(Arrays.asList(FieldCondition.visible((Field)filterType, (FieldCondition.OP)FieldCondition.OP.equals, (String)Tickets.FIELD_OWNER_GUID.getKey())));
                ownerSelect.setValue("");
                ownerSelect.setAllowCustomValues(true);
                fields.add((Field)ownerSelect);
            }
        }
    }

    public static boolean isAllowedForCurrentUser(@Nonnull Map<Type, Set<GUID>> restrictedTo) {
        GUID accountID = UserManager.getInstance().getCurrentUserAccountID();
        if (accountID != null) {
            for (Map.Entry<Type, Set<GUID>> selectedMember : restrictedTo.entrySet()) {
                Set groupsForUser;
                if (!(selectedMember.getKey() == Type.user ? selectedMember.getValue().contains(accountID) : (groupsForUser = UserGroupManager.getInstance().getGroupsForUser(accountID)).stream().anyMatch(g -> ((Set)selectedMember.getValue()).contains(g.getID())))) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    List<FieldDefinition> getEligibleUserFieldDefinitions() {
        List fieldDefinitionsRaw = DynamicExtensionManager.getInstance().get(FieldDefinition.class);
        List<FieldDefinition> fieldDefinitions = fieldDefinitionsRaw.stream().sorted(Comparator.comparingInt(FieldDefinition::getPriority)).filter(f -> {
            if (f instanceof UserFieldDefinition && f.getFieldKey() != null && f.getLabel() != null && !f.getLabel().isBlank() && ((UserFieldDefinition)f).isAvailable(UserManager.getInstance().getCurrentUserAccount())) {
                TakeoutDataRenderer dataRenderer = (TakeoutDataRenderer)ServerPluginManager.getInstance().getSingleInstanceByName(TakeoutDataRenderer.class, f.getDisplayType(), true);
                return !(dataRenderer instanceof EmptyTakeoutDataRenderer);
            }
            return false;
        }).collect(Collectors.toList());
        return fieldDefinitions;
    }

    protected List<Field> generateFieldsFor(String propertyKeyPrefix, FieldEditDefinition edit) {
        ArrayList<UnitConfigProperty.Unit> howOftenOnlyHoursMinutesUnits = new ArrayList<UnitConfigProperty.Unit>();
        howOftenOnlyHoursMinutesUnits.add(new UnitConfigProperty.Unit(0.016666666666666666, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("action.setticketfield.hours", new Object[0])));
        howOftenOnlyHoursMinutesUnits.add(new UnitConfigProperty.Unit(1.0, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("action.setticketfield.minutes", new Object[0])));
        ArrayList<UnitConfigProperty.Unit> howOftenUnits = new ArrayList<UnitConfigProperty.Unit>(howOftenOnlyHoursMinutesUnits);
        howOftenUnits.add(0, new UnitConfigProperty.Unit(6.944444444444444E-4, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("action.setticketfield.days", new Object[0])));
        howOftenUnits.add(0, new UnitConfigProperty.Unit(9.92063492063492E-5, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("action.setticketfield.weeks", new Object[0])));
        howOftenUnits.add(0, new UnitConfigProperty.Unit(2.48015873015873E-5, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("action.setticketfield.months", new Object[0])));
        String uniquePrefix = "fflg." + propertyKeyPrefix;
        String key = uniquePrefix + edit.getFieldKey();
        String displayType = edit.getDisplayType();
        ArrayList<LocalizedKey> numberPreBoxValues = new ArrayList<LocalizedKey>();
        numberPreBoxValues.add(new LocalizedKey(NUMBERPREBOX_EQUAL, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("numberPre.equal", new Object[0])));
        numberPreBoxValues.add(new LocalizedKey(NUMBERPREBOX_NOTEQUAL, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("numberPre.notequal", new Object[0])));
        numberPreBoxValues.add(new LocalizedKey(NUMBERPREBOX_GREATER, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("numberPre.greater", new Object[0])));
        numberPreBoxValues.add(new LocalizedKey(NUMBERPREBOX_LESSTHAN, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("numberPre.lessthan", new Object[0])));
        SelectField preBox = new SelectField(key + ".prebox", HelpDeskTaskPlannerServerPlugin.MSG.getMsg("numberPre", new Object[0]), numberPreBoxValues);
        preBox.setValue(NUMBERPREBOX_EQUAL);
        switch (displayType) {
            case "double": {
                FloatField floatField = new FloatField(key, "");
                floatField.setValue("");
                return List.of(preBox, floatField);
            }
            case "integer": {
                NumberField intField = new NumberField(key, "");
                intField.setValue("");
                return List.of(preBox, intField);
            }
            case "currency": {
                CurrencyField currField = new CurrencyField(key, "");
                currField.setValue("");
                return List.of(preBox, currField);
            }
            case "timeonlyvalue": {
                TimeField timeField = new TimeField(key, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("if_value_is", new Object[0]));
                timeField.setValue("");
                return List.of(timeField);
            }
            case "boolean": {
                BooleanField booleanField = new BooleanField(key, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("if_value_is", new Object[0]));
                booleanField.setValue("false");
                return List.of(booleanField);
            }
            case "textinput": {
                TextField textField = new TextField(key, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("if_value_contains", new Object[0]));
                textField.setValue("");
                return List.of(textField);
            }
            case "textarea": {
                TextAreaField textAreaField = new TextAreaField(key, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("if_value_contains", new Object[0]));
                textAreaField.setValue("");
                return List.of(textAreaField);
            }
            case "datevalue": 
            case "dateonlyvalue": {
                SelectField dateChoicesPicker = FilterableFieldListGenerator.generateDateChoicesPicker(key, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("withinWeeksLabel", new Object[0]));
                return List.of(dateChoicesPicker);
            }
            case "select": 
            case "selecteditable": 
            case "selectmulti": 
            case "itilselect": {
                if (!(edit instanceof SelectEditDefinition)) break;
                SelectOptionResult selectOptions = ((SelectEditDefinition)edit).getSelectOptions(new ArrayList(), "", 10000, 0);
                List options = selectOptions.getOptions();
                int typeID = -12345;
                SelectInputField selectValueField = new SelectInputField(key, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("if_value_is", new Object[0]), typeID);
                selectValueField.setAllowCustomValues(true);
                if (options.size() > 0) {
                    SelectOption selectedOption;
                    TicketField<Object> ticketField = this.getByKey(edit);
                    Object defaultValueToPick = null;
                    if (ticketField != null) {
                        defaultValueToPick = ticketField.getDefaultValue();
                    }
                    if (defaultValueToPick != null) {
                        Object defaultValueToPick_ = defaultValueToPick;
                        selectedOption = options.stream().filter(o -> defaultValueToPick_.equals(o.getValue())).findFirst().orElse((SelectOption)options.get(0));
                    } else {
                        selectedOption = (SelectOption)options.get(0);
                    }
                    selectValueField.setValue(selectedOption.getValue());
                    selectValueField.setDisplay(selectedOption.getLabel());
                }
                return List.of(selectValueField);
            }
        }
        return List.of(new LabelField("unknown", "", HelpDeskTaskPlannerServerPlugin.MSG.getMsg("unknownType", new Object[0])));
    }

    private static SelectField generateDateChoicesPicker(String key, String pickerLabel) {
        ArrayList<LocalizedKey> values = new ArrayList<LocalizedKey>();
        values.add(new LocalizedKey(DATE_PERIOD_1_WEEK, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("weeks", new Object[]{1})));
        values.add(new LocalizedKey(DATE_PERIOD_2_WEEKS, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("weeks", new Object[]{2})));
        values.add(new LocalizedKey(DATE_PERIOD_3_WEEKS, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("weeks", new Object[]{3})));
        values.add(new LocalizedKey(DATE_PERIOD_4_WEEKS, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("weeks", new Object[]{4})));
        values.add(new LocalizedKey(DATE_PERIOD_5_WEEKS, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("weeks", new Object[]{5})));
        values.add(new LocalizedKey(DATE_PERIOD_6_WEEKS, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("weeks", new Object[]{6})));
        values.add(new LocalizedKey(DATE_PERIOD_7_WEEKS, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("weeks", new Object[]{7})));
        values.add(new LocalizedKey(DATE_PERIOD_8_WEEKS, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("weeks", new Object[]{8})));
        values.add(new LocalizedKey(DATE_PERIOD_3_MONTHS, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("months", new Object[]{3})));
        values.add(new LocalizedKey(DATE_PERIOD_6_MONTHS, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("months", new Object[]{6})));
        values.add(new LocalizedKey(DATE_PERIOD_1_YEAR, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("years", new Object[]{1})));
        values.add(new LocalizedKey(DATE_PERIOD_3_YEARS, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("years", new Object[]{3})));
        SelectField dateChoicesPicker = new SelectField(key, pickerLabel, values);
        dateChoicesPicker.setValue(DATE_PERIOD_1_WEEK);
        return dateChoicesPicker;
    }

    private static TicketProcessManager getTPMInstance() {
        if (tpmInstance != null) {
            return tpmInstance;
        }
        return (TicketProcessManager)ServerPluginManager.getInstance().getOptionalInstance(TicketProcessManager.class);
    }

    private static ArrayList<DataEntry> getRecursiveChildren(List<CategoryVO> treedata) {
        ArrayList<DataEntry> result = new ArrayList<DataEntry>();
        FilterableFieldListGenerator.addRecursiveChildren(treedata, treedata.stream().filter(v -> v.getId() == 0).collect(Collectors.toList()), result, 0);
        return result;
    }

    private static void addRecursiveChildren(List<CategoryVO> alldata, List<CategoryVO> currentLevelData, ArrayList<DataEntry> to, int level) {
        currentLevelData.forEach(e -> {
            String label = e.getDisplayValue();
            label = label.isEmpty() ? HelpDeskTaskPlannerServerPlugin.MSG.getMsg("novalue", new Object[0]) : label;
            to.add(FilterableFieldListGenerator.entryFrom("" + e.getId(), label, 4, level));
            FilterableFieldListGenerator.addRecursiveChildren(alldata, alldata.stream().filter(v -> v.getId() != 0 && v.getParentCategoryID().intValue() == e.getId() && v.getParentCategoryID().intValue() != v.getId()).collect(Collectors.toList()), to, level + 1);
        });
    }

    private ArrayList<DataEntry> getRecursiveChildren(Set<UserGroupInfo> resourceData) {
        HashMap guidToDisplayNames = new HashMap();
        resourceData.forEach(r -> guidToDisplayNames.put(r.getID(), r.getDisplayName()));
        return resourceData.stream().sorted((o1, o2) -> {
            Collator collator = FilterableFieldListGenerator.getCollator();
            GUID parent1 = o1.getParentID();
            GUID parent2 = o2.getParentID();
            if (parent1 == null && parent2 == null || parent1 != null && parent1.equals((Object)parent2)) {
                return collator.compare(o1.getDisplayName(), o2.getDisplayName());
            }
            if (o2.getID().equals((Object)parent1)) {
                return 1;
            }
            if (o1.getID().equals((Object)parent2)) {
                return -1;
            }
            String name1 = o1.getDisplayName();
            if (parent1 != null) {
                String parentName = (String)guidToDisplayNames.get(parent1);
                name1 = parentName == null ? name1 : parentName;
            }
            String name2 = o2.getDisplayName();
            if (parent2 != null) {
                String parentName = (String)guidToDisplayNames.get(parent2);
                name2 = parentName == null ? name2 : parentName;
            }
            return collator.compare(name1, name2);
        }).map(u -> {
            int level = this.levelFor((UserGroupInfo)u);
            return FilterableFieldListGenerator.entryFrom(String.valueOf(u.getValue((UserGroupField)HDUsersAndGroups.RES_FIELD_ID)), UsersAndGroups.getFullGroupDisplayName((UserGroupInfo)u), 1, level);
        }).collect(Collectors.toCollection(ArrayList::new));
    }

    private static Collator getCollator() {
        Collator collator = Collator.getInstance();
        collator.setStrength(1);
        collator.setDecomposition(1);
        return collator;
    }

    private int levelFor(UserGroupInfo u) {
        UserGroupManager groupManager = HelpDeskUserGroupManager.getInstance();
        int level = 0;
        while (u.getParentID() != null) {
            ++level;
            u = groupManager.getGroup(u.getParentID());
        }
        return level;
    }

    public ArrayList<DataEntry> getCategoryKeys() {
        List all = CategoryManager.getInstance().getAll(true);
        all.sort((o1, o2) -> o1.getPath().replace('\\', '\n').compareToIgnoreCase(o2.getPath().replace('\\', '\n')));
        return FilterableFieldListGenerator.getRecursiveChildren(all);
    }

    public ArrayList<DataEntry> getResourceKeys(boolean withCustomEntry, boolean withNoneEntry) {
        Set groups = HelpDeskUserGroupManager.getInstance().getGroups(HDUsersAndGroups.RESOURCE);
        ArrayList<DataEntry> entries = this.getRecursiveChildren(groups);
        if (withCustomEntry) {
            entries.add(0, FilterableFieldListGenerator.entryFrom(ONLY_MY_RESOURCES_DATA_ENTRY_ID, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("TicketCreatedSeries.onlymyresources", new Object[0]), 1, 0));
        }
        if (withNoneEntry) {
            entries.add(0, FilterableFieldListGenerator.entryFrom(NO_RESOURCE_DATA_ENTRY_ID, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("TicketCreatedSeries.noresource", new Object[0]), 1, 0));
        }
        return entries;
    }

    public ArrayList<DataEntry> getCustomerLocationKeys() {
        List all = LocationManager.getInstance().getAll(true);
        return all.stream().map(l -> FilterableFieldListGenerator.entryFrom("" + l.getId(), l.getDisplayValue(), 5, 0)).sorted((o1, o2) -> FilterableFieldListGenerator.getCollator().compare(o1.getLabel(), o2.getLabel())).collect(Collectors.toCollection(ArrayList::new));
    }

    public ArrayList<DataEntry> getClassificationKeys() {
        List all = ClassificationManager.getInstance().getAll(true);
        return all.stream().map(e -> {
            String displayName = e.getDisplayValue() == null || "".equals(e.getDisplayValue()) ? HelpDeskTaskPlannerServerPlugin.MSG.getMsg("novalue", new Object[0]) : e.getDisplayValue();
            return FilterableFieldListGenerator.entryFrom("" + e.getId(), displayName, 3, 0);
        }).sorted((o1, o2) -> FilterableFieldListGenerator.getCollator().compare(o1.getLabel(), o2.getLabel())).collect(Collectors.toCollection(ArrayList::new));
    }

    public ArrayList<DataEntry> getPriorityKeys() {
        List all = PriorityManager.getInstance().getAll(true);
        return all.stream().sorted(Comparator.comparingInt(FieldVO::getId).reversed()).map(e -> {
            String displayName = "".equals(e.getDisplayValue()) ? HelpDeskTaskPlannerServerPlugin.MSG.getMsg("novalue", new Object[0]) : e.getDisplayValue();
            return FilterableFieldListGenerator.entryFrom("" + e.getId(), displayName, 2, 0);
        }).collect(Collectors.toCollection(ArrayList::new));
    }

    public ArrayList<DataEntry> getStatusKeys() {
        List allStatuses = StatusManager.getInstance().getAll(true);
        return allStatuses.stream().filter(e -> e.getId() != -100 && e.getId() != -200).sorted(Comparator.comparingInt(FieldVO::getId)).map(e -> {
            String displayName = "".equals(e.getDisplayValue()) ? HelpDeskTaskPlannerServerPlugin.MSG.getMsg("novalue", new Object[0]) : e.getDisplayValue();
            return FilterableFieldListGenerator.entryFrom("" + e.getId(), displayName, 0, 0);
        }).collect(Collectors.toCollection(ArrayList::new));
    }

    public ArrayList<DataEntry> getItilKeys() {
        List all = ItilManager.getInstance().getAll(true);
        ArrayList keys = all.stream().filter(e -> FilterableFieldListGenerator.isAllowedForCurrentUser(e.getRestrictedTo())).sorted(Comparator.comparing(ItilVO::isMasterType).thenComparing((i1, i2) -> FilterableFieldListGenerator.getCollator().compare(i1.getDisplayValue(), i2.getDisplayValue()))).map(e -> {
            String displayName = "".equals(e.getDisplayValue()) ? HelpDeskTaskPlannerServerPlugin.MSG.getMsg("novalue", new Object[0]) : e.getDisplayValue();
            return FilterableFieldListGenerator.entryFrom("" + e.getId(), displayName, 7, 0);
        }).collect(Collectors.toCollection(ArrayList::new));
        return keys;
    }

    public ArrayList<DataEntry> getActionKeys() {
        ArrayList<Integer> excludeIds = new ArrayList<Integer>();
        excludeIds.add(-26);
        excludeIds.add(-29);
        excludeIds.add(4);
        excludeIds.add(-10);
        excludeIds.add(-31);
        excludeIds.add(-17);
        excludeIds.add(-15);
        excludeIds.add(-27);
        excludeIds.add(-28);
        excludeIds.add(3);
        excludeIds.add(-30);
        excludeIds.add(-35);
        excludeIds.add(-18);
        excludeIds.add(-38);
        excludeIds.add(-16);
        List all = ActionManager.getInstance().getAll(true);
        return all.stream().filter(a -> !excludeIds.contains(a.getId())).sorted((a1, a2) -> FilterableFieldListGenerator.getCollator().compare(a1.getDisplayValue(), a2.getDisplayValue())).map(e -> {
            String displayName = "".equals(e.getDisplayValue()) ? HelpDeskTaskPlannerServerPlugin.MSG.getMsg("novalue", new Object[0]) : e.getDisplayValue();
            return FilterableFieldListGenerator.entryFrom("" + e.getId(), "" + e.getStatusID(), displayName, 0, 0);
        }).collect(Collectors.toCollection(ArrayList::new));
    }

    public ArrayList<LocalizedKey> getFilterTypeValues() {
        return this.filterTypeValues.get(this.currentLanguage());
    }

    public Map<String, ArrayList<LocalizedKey>> getFilterTypeValuesMap() {
        return this.filterTypeValues;
    }

    public List<LocalizedKey> getOwnerFieldKeys() {
        return this.ownerFieldKeys;
    }

    public SelectField getFilterTypeSelectField() {
        return this.filterType;
    }
}

