/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.taskplanner.server.trigger.ticketwarning;

import com.inet.config.structure.model.LocalizedKey;
import com.inet.helpdesk.plugins.taskplanner.HelpDeskTaskPlannerServerPlugin;
import com.inet.helpdesk.plugins.taskplanner.server.FilterFieldValues;
import com.inet.helpdesk.plugins.taskplanner.server.FilterableFieldListGenerator;
import com.inet.helpdesk.plugins.taskplanner.server.HDPlaceholders;
import com.inet.helpdesk.plugins.taskplanner.server.trigger.ticketwarning.TicketWarningTrigger;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.http.servlet.ClientLocale;
import com.inet.id.GUID;
import com.inet.taskplanner.server.api.common.AbstractDefinition;
import com.inet.taskplanner.server.api.common.SummaryInfo;
import com.inet.taskplanner.server.api.error.ValidationException;
import com.inet.taskplanner.server.api.field.Field;
import com.inet.taskplanner.server.api.field.FieldCondition;
import com.inet.taskplanner.server.api.field.SelectField;
import com.inet.taskplanner.server.api.trigger.Trigger;
import com.inet.taskplanner.server.api.trigger.TriggerDefinition;
import com.inet.taskplanner.server.api.trigger.TriggerFactory;
import com.inet.taskplanner.server.api.trigger.TriggerInfo;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.net.URL;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TicketWarningTriggerFactory
extends TriggerFactory<Trigger> {
    public static final String PROPERTY_WHICH_THRESHOLD = "PROPERTY_WHICH_THRESHOLD";
    public static final String PROPERTY_WARNING_ACTION_WHEN = "PROPERTY_WARNING_ACTION_WHEN";
    public static final String PROPERTY_WARNING_ACTION_WHEN_ESCA = "PROPERTY_WARNING_ACTION_WHEN_ESCA";
    public static final String PROPERTY_THRESHOLD_ESCALATION = "Autoescalation";
    public static final String PROPERTY_THRESHOLD_DEADLINE = "Deadline";
    public static final String ACTION_CHANGE_OF_ANY_KIND = "any";
    public static final String ACTION_CHANGE_TO_NO_VALUE = "none";
    public static final String ACTION_CHANGE_TO_NO_WARNING = "green";
    public static final String ACTION_CHANGE_TO_YELLOW_WARNING = "yellow";
    public static final String ACTION_CHANGE_TO_RED_WARNING = "red";
    public static final String ACTION_CHANGE_TO_PASSED = "attention";
    public static final String EXTENSION_NAME = "trigger.helpdesk.ticketwarning";
    public static final String PLACEHOLDER_WARNING_TYPE = "ticketwarning.type";
    public static final String PLACEHOLDER_WARNING_COLOR = "ticketwarning.color";
    private FilterFieldValues fieldValues;

    public TicketWarningTriggerFactory() {
        super(EXTENSION_NAME);
    }

    public TriggerInfo getInformation(@Nullable GUID guid) {
        this.fieldValues = new FilterFieldValues(this.getFieldListGenerator());
        URL iconURL = ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/plugins/taskplanner/structure/trigger_warning_32.png");
        ArrayList<Object> fields = new ArrayList<Object>();
        ArrayList<LocalizedKey> whenToTriggerOptions = new ArrayList<LocalizedKey>();
        whenToTriggerOptions.add(new LocalizedKey(PROPERTY_THRESHOLD_ESCALATION, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("TicketWarningTrigger.WhenToTrigger.AutoEscalation", new Object[0])));
        whenToTriggerOptions.add(new LocalizedKey(PROPERTY_THRESHOLD_DEADLINE, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("TicketWarningTrigger.WhenToTrigger.Deadline", new Object[0])));
        SelectField whenToTrigger = new SelectField(PROPERTY_WHICH_THRESHOLD, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("TicketWarningTrigger.WhichThreshold", new Object[0]), whenToTriggerOptions);
        whenToTrigger.setValue(PROPERTY_THRESHOLD_ESCALATION);
        ArrayList<LocalizedKey> warningActionsDeadline = new ArrayList<LocalizedKey>();
        warningActionsDeadline.add(new LocalizedKey(ACTION_CHANGE_TO_NO_VALUE, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("TicketWarningTrigger.WarningAction.ChangeToNoValue", new Object[0])));
        warningActionsDeadline.add(new LocalizedKey(ACTION_CHANGE_TO_NO_WARNING, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("TicketWarningTrigger.WarningAction.ChangeToNoWarning", new Object[0])));
        warningActionsDeadline.add(new LocalizedKey(ACTION_CHANGE_TO_YELLOW_WARNING, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("TicketWarningTrigger.WarningAction.ChangeToYellowWarning", new Object[0])));
        warningActionsDeadline.add(new LocalizedKey(ACTION_CHANGE_TO_RED_WARNING, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("TicketWarningTrigger.WarningAction.ChangeToRedWarning", new Object[0])));
        warningActionsDeadline.add(new LocalizedKey(ACTION_CHANGE_TO_PASSED, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("TicketWarningTrigger.WarningAction.ChangeToPassed", new Object[0])));
        warningActionsDeadline.add(new LocalizedKey(ACTION_CHANGE_OF_ANY_KIND, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("TicketWarningTrigger.WarningAction.ChangeOfAnyKind", new Object[0])));
        SelectField warningActionDeadline = new SelectField(PROPERTY_WARNING_ACTION_WHEN, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("TicketWarningTrigger.WarningActionWhen", new Object[0]), warningActionsDeadline);
        List<FieldCondition> visibleConditionDeadline = Arrays.asList(FieldCondition.visible((Field)whenToTrigger, (FieldCondition.OP)FieldCondition.OP.equals, (String)PROPERTY_THRESHOLD_DEADLINE));
        warningActionDeadline.setConditions(visibleConditionDeadline);
        warningActionDeadline.setValue(ACTION_CHANGE_TO_RED_WARNING);
        ArrayList<LocalizedKey> warningActionsEsca = new ArrayList<LocalizedKey>();
        warningActionsEsca.add(new LocalizedKey(ACTION_CHANGE_TO_NO_VALUE, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("TicketWarningTrigger.WarningAction.ChangeToNoValueEsca", new Object[0])));
        warningActionsEsca.add(new LocalizedKey(ACTION_CHANGE_TO_NO_WARNING, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("TicketWarningTrigger.WarningAction.ChangeToNoWarning", new Object[0])));
        warningActionsEsca.add(new LocalizedKey(ACTION_CHANGE_TO_YELLOW_WARNING, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("TicketWarningTrigger.WarningAction.ChangeToYellowWarning", new Object[0])));
        warningActionsEsca.add(new LocalizedKey(ACTION_CHANGE_TO_RED_WARNING, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("TicketWarningTrigger.WarningAction.ChangeToRedWarning", new Object[0])));
        warningActionsEsca.add(new LocalizedKey(ACTION_CHANGE_TO_PASSED, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("TicketWarningTrigger.WarningAction.ChangeToPassedAutoEsca", new Object[0])));
        warningActionsEsca.add(new LocalizedKey(ACTION_CHANGE_OF_ANY_KIND, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("TicketWarningTrigger.WarningAction.ChangeOfAnyKind", new Object[0])));
        SelectField warningActionEsca = new SelectField(PROPERTY_WARNING_ACTION_WHEN_ESCA, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("TicketWarningTrigger.WarningActionWhen", new Object[0]), warningActionsEsca);
        List<FieldCondition> visibleConditionEsca = Arrays.asList(FieldCondition.visible((Field)whenToTrigger, (FieldCondition.OP)FieldCondition.OP.equals, (String)PROPERTY_THRESHOLD_ESCALATION));
        warningActionEsca.setConditions(visibleConditionEsca);
        warningActionEsca.setValue(ACTION_CHANGE_TO_RED_WARNING);
        fields.add(whenToTrigger);
        fields.add(warningActionDeadline);
        fields.add(warningActionEsca);
        ArrayList<Field> filterFieldChooser = this.fieldValues.getFilterFieldChooser();
        fields.addAll(filterFieldChooser);
        List<String> placeholderKeys = HDPlaceholders.getHDPlaceholderKeys();
        placeholderKeys.add(PLACEHOLDER_WARNING_TYPE);
        placeholderKeys.add(PLACEHOLDER_WARNING_COLOR);
        return new TriggerInfo(EXTENSION_NAME, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("TicketWarningTrigger.name", new Object[0]), HelpDeskTaskPlannerServerPlugin.MSG.getMsg("TicketWarningTrigger.desc", new Object[0]), iconURL, "taskplanner.trigger.ticket-warning", fields, placeholderKeys);
    }

    protected FilterableFieldListGenerator getFieldListGenerator() {
        return FilterableFieldListGenerator.getInstance();
    }

    public void validate(@Nonnull TriggerDefinition definition, GUID guid) throws ValidationException {
        String warningAction;
        Map props = definition.getProperties();
        String whenToTrigger = (String)props.get(PROPERTY_WHICH_THRESHOLD);
        String string = warningAction = PROPERTY_THRESHOLD_ESCALATION.equals(whenToTrigger) ? (String)props.get(PROPERTY_WARNING_ACTION_WHEN_ESCA) : (String)props.get(PROPERTY_WARNING_ACTION_WHEN);
        if (whenToTrigger == null || warningAction == null) {
            throw new ValidationException(new String[]{HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ErrorMissingTriggerParameters", new Object[0])});
        }
        this.fieldValues.validate((AbstractDefinition)definition, guid);
    }

    public SummaryInfo getSummary(@Nonnull TriggerDefinition definition) {
        Map props = definition.getProperties();
        String whenToTrigger = (String)props.get(PROPERTY_WHICH_THRESHOLD);
        String property = PROPERTY_THRESHOLD_ESCALATION.equals(whenToTrigger) ? (String)props.get(PROPERTY_WARNING_ACTION_WHEN_ESCA) : (String)props.get(PROPERTY_WARNING_ACTION_WHEN);
        String key = "TicketWarningTriggerFactory." + property + "." + definition.getProperty(PROPERTY_WHICH_THRESHOLD);
        String ticketCreatedSeriesSummaryInfoLabel = "TicketCreatedSeriesSummaryInfoLabel";
        return this.fieldValues.getSummary((AbstractDefinition)definition, this.currentLanguage(), HelpDeskTaskPlannerServerPlugin.MSG.getMsg(key, new Object[0]), "NewTicketTrigger.summary.label", ticketCreatedSeriesSummaryInfoLabel);
    }

    private String currentLanguage() {
        return ClientLocale.getThreadLocale().toLanguageTag();
    }

    public List<ZonedDateTime> getNextExecutionTimes(TriggerDefinition definition) {
        return super.getNextExecutionTimes(definition);
    }

    protected Trigger createInstanceFrom(@Nonnull TriggerDefinition definition, @Nullable GUID taskID) {
        return new TicketWarningTrigger(definition, taskID);
    }

    public boolean isAvailable() {
        UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
        return currentUserAccount != null && HDUsersAndGroups.isSupporter((UserAccount)currentUserAccount);
    }

    public Map<String, String> updateValues(@Nonnull TriggerDefinition definition, GUID taskID) {
        FilterableFieldListGenerator.updateResourceDisplayValueIfNecessary((AbstractDefinition)definition);
        return super.updateValues((AbstractDefinition)definition, taskID);
    }
}

