/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.taskplanner.server.trigger.formsubmitted;

import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.plugins.forms.server.api.FormsManager;
import com.inet.helpdesk.plugins.forms.server.api.TaskPlannerNotifier;
import com.inet.helpdesk.plugins.forms.server.api.model.HDForm;
import com.inet.helpdesk.plugins.taskplanner.server.FormTaskPlannerNotifierImpl;
import com.inet.helpdesk.plugins.taskplanner.server.trigger.formsubmitted.FormsTriggerListener;
import com.inet.id.GUID;
import com.inet.taskplanner.server.api.trigger.Trigger;
import com.inet.taskplanner.server.api.trigger.TriggerDefinition;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FormsTrigger
implements Trigger,
FormsTriggerListener {
    private final String whenToTrigger;
    private final String specificFormId;
    private Trigger.TriggerAction triggerAction;
    private GUID taskID;

    public FormsTrigger(@Nonnull TriggerDefinition definition, @Nullable GUID taskID) {
        this.whenToTrigger = definition.getProperties().getOrDefault("whenToTrigger", "when.any");
        this.specificFormId = (String)definition.getProperties().get("formId");
        this.taskID = taskID;
    }

    public void activate(GUID guid, Trigger.TriggerAction triggerAction) {
        this.triggerAction = triggerAction;
        this.registerListener();
    }

    protected void registerListener() {
        TaskPlannerNotifier notifier = TaskPlannerNotifier.getInstance();
        if (notifier != null && notifier instanceof FormTaskPlannerNotifierImpl) {
            ((FormTaskPlannerNotifierImpl)notifier).addListener(this);
        } else {
            HDLogger.warn((Object)"FormsTrigger activated but TaskPlannerNotifier not available.");
        }
    }

    public void deactivate() {
        this.triggerAction = null;
        this.unregisterListener();
    }

    protected void unregisterListener() {
        TaskPlannerNotifier notifier = TaskPlannerNotifier.getInstance();
        if (notifier != null && notifier instanceof FormTaskPlannerNotifierImpl) {
            ((FormTaskPlannerNotifierImpl)notifier).removeListener(this);
        }
    }

    @Override
    public void formSubmitted(@Nonnull GUID formId, @Nonnull Map<String, String> fieldValues) {
        Trigger.TriggerAction action = this.triggerAction;
        if (action == null) {
            return;
        }
        if ("when.specific".equals(this.whenToTrigger) && !formId.toString().equals(this.specificFormId)) {
            return;
        }
        HashMap<String, String> props = new HashMap<String, String>();
        fieldValues.forEach((k, v) -> props.put("form.field." + k, (String)v));
        props.put("form.id", formId.toString());
        HDForm form = FormsManager.getInstance().getForm(formId);
        if (form != null) {
            props.put("form.name", form.getName());
            props.put("form.title", form.getTitle());
        }
        action.execute(props);
    }
}

