/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.taskplanner.server.job.addattachment;

import com.inet.helpdesk.plugins.taskplanner.HelpDeskTaskPlannerServerPlugin;
import com.inet.helpdesk.plugins.taskplanner.server.job.addattachment.AddAttachmentToTicketJob;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.taskplanner.server.api.common.AbstractDefinition;
import com.inet.taskplanner.server.api.common.SummaryEntry;
import com.inet.taskplanner.server.api.error.ValidationException;
import com.inet.taskplanner.server.api.field.FileOrFolderField;
import com.inet.taskplanner.server.api.field.LabelField;
import com.inet.taskplanner.server.api.field.TextField;
import com.inet.taskplanner.server.api.job.ConditionInfo;
import com.inet.taskplanner.server.api.job.JobDefinition;
import com.inet.taskplanner.server.api.job.JobFactory;
import com.inet.taskplanner.server.api.job.JobInfo;
import com.inet.taskplanner.server.api.job.JobSummaryInfo;
import com.inet.taskplanner.server.api.result.ResultFlavor;
import com.inet.taskplanner.server.api.series.SeriesDefinition;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;

public class AddAttachmentToTicketJobFactory
extends JobFactory<AddAttachmentToTicketJob> {
    public static final String EXTENSION_NAME = "taskplanner.helpdesk.addattachmenttoticket";

    public AddAttachmentToTicketJobFactory() {
        super(EXTENSION_NAME);
    }

    public List<ResultFlavor> getResultFlavors(JobDefinition jobDefinition) {
        return new ArrayList<ResultFlavor>();
    }

    @Nullable
    public Map<String, String> updateValues(@Nonnull JobDefinition patchedDefinition, @Nullable JobDefinition unpatchedDefinition, @Nullable SeriesDefinition seriesDefinition, @Nonnull GUID taskID) {
        return super.updateValues((AbstractDefinition)patchedDefinition, (AbstractDefinition)unpatchedDefinition, seriesDefinition, taskID);
    }

    public JobInfo getInformation(@Nullable GUID guid) {
        String name = HelpDeskTaskPlannerServerPlugin.MSG.getMsg("AddAttachmentCategory", new Object[0]);
        String description = HelpDeskTaskPlannerServerPlugin.MSG.getMsg("AddAttachmentCategoryDesc", new Object[0]);
        URL iconURL = ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/plugins/taskplanner/structure/addattachment_32.png");
        String helpKey = "taskplanner.job.add-attachment-to-ticket";
        ArrayList<Object> fields = new ArrayList<Object>();
        TextField textField = new TextField("Ticket ID", HelpDeskTaskPlannerServerPlugin.MSG.getMsg("TicketIDLabel", new Object[0]));
        textField.setValue("{Ticket ID}");
        fields.add(textField);
        LabelField labelField = new LabelField("fileExplanation", "", HelpDeskTaskPlannerServerPlugin.MSG.getMsg("AddAttachmentFileExplanation", new Object[0]));
        fields.add(labelField);
        FileOrFolderField attachmentFileField = new FileOrFolderField("AttachmentFilePath", HelpDeskTaskPlannerServerPlugin.MSG.getMsg("AddAttachmentFileLabel", new Object[0]));
        attachmentFileField.setProtocols(FileOrFolderField.getAllAvailableProtocols());
        fields.add(attachmentFileField);
        return new JobInfo(this.getExtensionName(), name, description, iconURL, helpKey, new ConditionInfo(new ArrayList()), fields, new ArrayList());
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Reading local files is limited to admin users")
    protected void validate(@Nonnull JobDefinition definition, @Nullable GUID guid) throws ValidationException {
        Map props = definition.getProperties();
        if (props.get("Ticket ID") == null || ((String)props.get("Ticket ID")).isEmpty()) {
            throw new ValidationException(new String[]{HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ErrorNoTicketEmpty", new Object[0])});
        }
        String filePath = (String)props.get("AttachmentFilePath");
        if (filePath == null || filePath.isEmpty()) {
            throw new ValidationException(new String[]{HelpDeskTaskPlannerServerPlugin.MSG.getMsg("FileRequired", new Object[0])});
        }
        if (AddAttachmentToTicketJobFactory.isRestrictedPath(filePath)) {
            throw new ValidationException(new String[]{HelpDeskTaskPlannerServerPlugin.MSG.getMsg("NoConfigurationPermission", new Object[0])});
        }
        File file = new File(filePath);
        if (!file.exists()) {
            try {
                URL uRL = new URL(filePath);
            }
            catch (MalformedURLException e) {
                throw new ValidationException(new String[]{HelpDeskTaskPlannerServerPlugin.MSG.getMsg("FileNotExists", new Object[]{StringFunctions.encodeHTML((String)filePath, (boolean)false)})});
            }
        }
    }

    static boolean isRestrictedPath(@Nonnull String filePath) {
        return !filePath.toLowerCase().startsWith("drive:") && !filePath.toLowerCase().startsWith("http:") && !filePath.toLowerCase().startsWith("https:") && !filePath.toLowerCase().startsWith("ftp:") && !filePath.toLowerCase().startsWith("ftps:") && !SystemPermissionChecker.checkAccess((Permission)Permission.CONFIGURATION);
    }

    protected void validateCondition(@Nonnull JobDefinition jobDefinition) throws ValidationException {
    }

    public boolean isAvailable() {
        UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
        return currentUserAccount != null && HDUsersAndGroups.isSupporter((UserAccount)currentUserAccount);
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="No file is read here")
    public JobSummaryInfo getSummary(@Nonnull JobDefinition definition) {
        ArrayList<SummaryEntry> summary = new ArrayList<SummaryEntry>();
        String filePath = definition.getProperty("AttachmentFilePath");
        if (filePath == null) {
            summary.add(new SummaryEntry("", HelpDeskTaskPlannerServerPlugin.MSG.getMsg("AddAttachmentNeedFileSetting", new Object[0])));
            return new JobSummaryInfo(summary, new ArrayList());
        }
        File f = new File(filePath);
        if (!f.isDirectory()) {
            summary.add(new SummaryEntry(HelpDeskTaskPlannerServerPlugin.MSG.getMsg("AddAttachmentCategorySummaryInfoLabelNone", new Object[0]), HelpDeskTaskPlannerServerPlugin.MSG.getMsg("AddAttachmentCategorySummaryInfoValue", new Object[]{filePath})));
        } else {
            summary.add(new SummaryEntry(HelpDeskTaskPlannerServerPlugin.MSG.getMsg("AddAttachmentCategorySummaryInfoLabelNone", new Object[0]), HelpDeskTaskPlannerServerPlugin.MSG.getMsg("AddAttachmentCategorySummaryInfoValueMulti", new Object[]{filePath})));
        }
        return new JobSummaryInfo(summary, new ArrayList());
    }

    protected AddAttachmentToTicketJob createInstanceFrom(@Nonnull JobDefinition definition, @Nullable GUID taskID) {
        return new AddAttachmentToTicketJob(definition, taskID);
    }
}

