/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.taskplanner.server.action.startprocess;

import com.inet.config.structure.model.LocalizedKey;
import com.inet.helpdesk.plugins.taskplanner.HelpDeskTaskPlannerServerPlugin;
import com.inet.helpdesk.plugins.taskplanner.server.HDPlaceholders;
import com.inet.helpdesk.plugins.taskplanner.server.action.startprocess.StartProcessAction;
import com.inet.helpdesk.plugins.ticketprocess.server.api.TicketProcessManager;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.TicketProcess;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.plugin.ServerPluginManager;
import com.inet.taskplanner.server.api.action.ResultActionDefinition;
import com.inet.taskplanner.server.api.action.ResultActionFactory;
import com.inet.taskplanner.server.api.action.ResultActionInfo;
import com.inet.taskplanner.server.api.common.SummaryEntry;
import com.inet.taskplanner.server.api.common.SummaryInfo;
import com.inet.taskplanner.server.api.error.ValidationException;
import com.inet.taskplanner.server.api.field.LabelField;
import com.inet.taskplanner.server.api.field.SelectField;
import com.inet.taskplanner.server.api.field.TextField;
import com.inet.taskplanner.server.api.result.ResultFlavor;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.net.URL;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class StartProcessActionFactory
extends ResultActionFactory<StartProcessAction> {
    public static final String EXTENSION_NAME = "taskplanner.helpdesk.startprocess";
    public static final String PROPERTY_PROCESS_ID = "processToStart";

    public StartProcessActionFactory() {
        super(EXTENSION_NAME);
    }

    public List<ResultFlavor> getSupportedFlavors(ResultActionDefinition definition) {
        return Arrays.asList(ResultFlavor.NONE);
    }

    public ResultActionInfo getInformation(@Nullable GUID taskID) {
        String name = HelpDeskTaskPlannerServerPlugin.MSG.getMsg("StartProcessCategory", new Object[0]);
        String description = HelpDeskTaskPlannerServerPlugin.MSG.getMsg("StartProcessCategoryDesc", new Object[0]);
        URL iconURL = ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/plugins/taskplanner/structure/startprocess_32.png");
        String helpKey = "taskplanner.action.start-process";
        ArrayList<Object> fields = new ArrayList<Object>();
        TextField textField = new TextField("Ticket ID", HelpDeskTaskPlannerServerPlugin.MSG.getMsg("TicketIDLabel", new Object[0]));
        HDPlaceholders.setPlaceholderDynamicallyForTextFieldInAction(taskID, textField);
        fields.add(textField);
        TicketProcessManager ticketProcessManager = this.getTicketProcessManager();
        ArrayList values = ticketProcessManager.getProcesses().stream().map(p -> new LocalizedKey(p.getId().toString(), p.getName())).sorted(new Comparator<LocalizedKey>(){

            @Override
            public int compare(LocalizedKey o1, LocalizedKey o2) {
                Collator collator = Collator.getInstance();
                collator.setStrength(1);
                collator.setDecomposition(1);
                return collator.compare(o1.getDisplayName(), o2.getDisplayName());
            }
        }).collect(Collectors.toCollection(ArrayList::new));
        if (values.size() > 0) {
            SelectField processes = new SelectField(PROPERTY_PROCESS_ID, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("StartProcess.ProcessToStart", new Object[0]), values);
            processes.setValue(((LocalizedKey)values.get(0)).getKey());
            fields.add(processes);
        } else {
            fields.add(new LabelField("Error", "", HelpDeskTaskPlannerServerPlugin.MSG.getMsg("StartProcess.NoProcessesAvailable", new Object[0])));
        }
        return new ResultActionInfo(this.getExtensionName(), name, description, iconURL, helpKey, fields);
    }

    protected TicketProcessManager getTicketProcessManager() {
        return (TicketProcessManager)ServerPluginManager.getInstance().getSingleInstance(TicketProcessManager.class);
    }

    protected void validate(@Nonnull ResultActionDefinition definition, @Nullable GUID taskID) throws ValidationException {
        String processID = definition.getProperty(PROPERTY_PROCESS_ID);
        TicketProcessManager ticketProcessManager = this.getTicketProcessManager();
        TicketProcess process = ticketProcessManager.getProcess(GUID.valueOf((String)processID));
        if (process == null) {
            throw new ValidationException(new String[]{HelpDeskTaskPlannerServerPlugin.MSG.getMsg("StartProcess.ProcessRequired", new Object[0])});
        }
    }

    public SummaryInfo getSummary(@Nonnull ResultActionDefinition definition) {
        TicketProcess process;
        ArrayList<SummaryEntry> summary = new ArrayList<SummaryEntry>();
        String ticketId = definition.getProperty("Ticket ID");
        String processID = definition.getProperty(PROPERTY_PROCESS_ID);
        TicketProcessManager ticketProcessManager = this.getTicketProcessManager();
        TicketProcess ticketProcess = process = processID == null ? null : ticketProcessManager.getProcess(GUID.valueOf((String)processID));
        if (process == null) {
            summary.add(new SummaryEntry(HelpDeskTaskPlannerServerPlugin.MSG.getMsg("StartProcess.SummaryTitle", new Object[0]), HelpDeskTaskPlannerServerPlugin.MSG.getMsg("StartProcess.DeletedProcess", new Object[0])));
        } else {
            summary.add(new SummaryEntry(HelpDeskTaskPlannerServerPlugin.MSG.getMsg("StartProcess.SummaryTitle", new Object[0]), HelpDeskTaskPlannerServerPlugin.MSG.getMsg("StartProcess.Details", new Object[]{ticketId, process.getName()})));
        }
        return new SummaryInfo(summary);
    }

    protected StartProcessAction createInstanceFrom(@Nonnull ResultActionDefinition definition, @Nullable GUID taskID) {
        return new StartProcessAction(definition.getProperties(), taskID);
    }

    public boolean isAvailable() {
        UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
        return currentUserAccount != null && HDUsersAndGroups.isSupporter((UserAccount)currentUserAccount);
    }
}

