/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.taskplanner.setupwizard;

import com.inet.helpdesk.plugins.taskplanner.HelpDeskTaskPlannerServerPlugin;
import com.inet.setupwizard.api.AutoSetupStep;
import com.inet.setupwizard.api.EmptyStepConfig;
import com.inet.setupwizard.api.InfoMessageGetter;
import com.inet.setupwizard.api.SetupStep;
import com.inet.setupwizard.api.SetupStepPriority;
import com.inet.setupwizard.api.StepExecutionException;
import com.inet.setupwizard.api.StepExecutionProgressListener;
import com.inet.setupwizard.api.StepKey;
import com.inet.setupwizard.basicsteps.UserManagerWait;
import com.inet.shared.utils.Version;
import com.inet.taskplanner.server.api.TaskDefinition;
import com.inet.taskplanner.server.api.TaskPlanner;
import com.inet.taskplanner.server.api.series.SeriesDefinition;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class OnlyMyResourcesMigrationSetupStep
extends AutoSetupStep {
    private static final String PROPERTY_ONLY_MY_RESOURCES = "onlymyresources";
    public static final StepKey KEY = new StepKey("OnlyMyResourcesMigrationSetupStep");

    public StepKey stepKey() {
        return KEY;
    }

    public String getStepDisplayName() {
        return HelpDeskTaskPlannerServerPlugin.MSG.getMsg("TaskPlanner.migratingOnlyMyResources", new Object[0]);
    }

    public boolean hasPendingTasks() {
        return true;
    }

    protected void waitForVeto() {
        UserManagerWait.waitForUserManagerVeto((StepExecutionProgressListener)this.getStepExecutionProgressListener(), (SetupStep)this);
    }

    public void execute(EmptyStepConfig stepConfig, Map<String, String> metaData) throws StepExecutionException {
        this.waitForVeto();
        TaskPlanner tp = TaskPlanner.getInstance();
        List allTaskIDs = tp.getAllTaskIDs();
        allTaskIDs.forEach(g -> {
            TaskDefinition d = tp.getTaskDefinition(g);
            if (d == null) {
                return;
            }
            List triggers = d.getTriggers();
            triggers.forEach(t -> {
                if (Boolean.valueOf(t.getProperty(PROPERTY_ONLY_MY_RESOURCES)).booleanValue()) {
                    if (t.getProperty("FilterType") != null && !t.getProperty("FilterType").equals("FilterTypeNone")) {
                        t.setProperty("Second.Resource", "OnlyMyResourcesDataEntryId");
                        t.setProperty("SecondFilterAndOrNone", "SecondFilterAnd");
                        t.setProperty("Second.FilterType", "FilterTypeResource");
                    } else {
                        t.setProperty("Resource", "OnlyMyResourcesDataEntryId");
                        t.setProperty("FilterType", "FilterTypeResource");
                    }
                    t.removeProperty(PROPERTY_ONLY_MY_RESOURCES);
                }
            });
            List jobs = d.getJobs();
            jobs.forEach(j -> {
                if (Boolean.valueOf(j.getProperty(PROPERTY_ONLY_MY_RESOURCES)).booleanValue()) {
                    if (j.getProperty("FilterType") != null && !j.getProperty("FilterType").equals("FilterTypeNone")) {
                        j.setProperty("Second.Resource", "OnlyMyResourcesDataEntryId");
                        j.setProperty("SecondFilterAndOrNone", "SecondFilterAnd");
                        j.setProperty("Second.FilterType", "FilterTypeResource");
                    } else {
                        j.setProperty("Resource", "OnlyMyResourcesDataEntryId");
                        j.setProperty("FilterType", "FilterTypeResource");
                    }
                    j.removeProperty(PROPERTY_ONLY_MY_RESOURCES);
                }
            });
            SeriesDefinition series = d.getSeries();
            if (series != null && Boolean.valueOf(series.getProperty(PROPERTY_ONLY_MY_RESOURCES)).booleanValue()) {
                if (series.getProperty("FilterType") != null && !series.getProperty("FilterType").equals("FilterTypeNone")) {
                    series.setProperty("Second.Resource", "OnlyMyResourcesDataEntryId");
                    series.setProperty("SecondFilterAndOrNone", "SecondFilterAnd");
                    series.setProperty("Second.FilterType", "FilterTypeResource");
                } else {
                    series.setProperty("Resource", "OnlyMyResourcesDataEntryId");
                    series.setProperty("FilterType", "FilterTypeResource");
                }
                series.removeProperty(PROPERTY_ONLY_MY_RESOURCES);
            }
            tp.updateTask(g, d);
        });
    }

    public SetupStepPriority getPriority() {
        return new SetupStepPriority(7642);
    }

    public InfoMessageGetter getExecutionInfoMessage(EmptyStepConfig stepConfig) {
        return () -> HelpDeskTaskPlannerServerPlugin.MSG.getMsg("TaskPlanner.migratingOnlyMyResources.executionMessage", new Object[0]);
    }

    @Nullable
    public Version getMigrationVersion() {
        return new Version("22.10");
    }
}

