/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.taskplanner.server.series.ticketswithstatus;

import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ServerValuesConnector;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.plugins.taskplanner.HelpDeskTaskPlannerServerPlugin;
import com.inet.helpdesk.plugins.taskplanner.server.FilterFieldValues;
import com.inet.helpdesk.plugins.taskplanner.server.FilterableFieldListGenerator;
import com.inet.helpdesk.plugins.taskplanner.server.HDPlaceholderUtils;
import com.inet.helpdesk.plugins.taskplanner.server.HDPlaceholders;
import com.inet.helpdesk.plugins.taskplanner.server.TicketFilterChecker;
import com.inet.helpdesk.plugins.taskplanner.server.series.ticketswithstatus.TicketsWithStatusSeries;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.http.servlet.ClientLocale;
import com.inet.id.GUID;
import com.inet.permissions.AccessDeniedException;
import com.inet.plugin.ServerPluginManager;
import com.inet.search.SearchResult;
import com.inet.search.SearchResultEntry;
import com.inet.search.command.AndSearchExpression;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.taskplanner.server.api.DataEntry;
import com.inet.taskplanner.server.api.TaskPlanner;
import com.inet.taskplanner.server.api.common.AbstractDefinition;
import com.inet.taskplanner.server.api.common.SummaryInfo;
import com.inet.taskplanner.server.api.error.ValidationException;
import com.inet.taskplanner.server.api.field.Field;
import com.inet.taskplanner.server.api.field.SelectInputFieldMulti;
import com.inet.taskplanner.server.api.series.SeriesDefinition;
import com.inet.taskplanner.server.api.series.SeriesFactory;
import com.inet.taskplanner.server.api.series.SeriesInfo;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TicketsWithStatusSeriesFactory
extends SeriesFactory<TicketsWithStatusSeries> {
    private FilterFieldValues fieldValues;
    public static final String EXTENSION_NAME = "series.helpdesk.tickets-with-status";
    public static final String PROPERTY_STATUS_FILTER = "statusFilter";

    public TicketsWithStatusSeriesFactory() {
        super(EXTENSION_NAME);
    }

    public FilterableFieldListGenerator getFieldListGenerator() {
        return FilterableFieldListGenerator.getInstance();
    }

    public SeriesInfo getInformation(@Nullable GUID guid) {
        this.fieldValues = new FilterFieldValues(this.getFieldListGenerator());
        ArrayList<Field> fields = this.fieldValues.getFilterFieldChooser();
        TicketsWithStatusSeriesFactory.createStatusSelectField(fields, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("StatusFilter", new Object[0]));
        URL iconURL = ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/plugins/taskplanner/structure/status_change_32.png");
        return new SeriesInfo(this.getExtensionName(), HelpDeskTaskPlannerServerPlugin.MSG.getMsg("TicketsWithStatusSeries.name", new Object[0]), HelpDeskTaskPlannerServerPlugin.MSG.getMsg("TicketsWithStatusSeries.description", new Object[0]), iconURL, "taskplanner.series.tickets-with-status", fields);
    }

    public static SelectInputFieldMulti createStatusSelectField(ArrayList<Field> fields, String label) {
        SelectInputFieldMulti selectField = new SelectInputFieldMulti(PROPERTY_STATUS_FILTER, label, 0);
        selectField.setValue("");
        fields.add(0, (Field)selectField);
        return selectField;
    }

    public void validate(@Nonnull SeriesDefinition definition, GUID guid) throws ValidationException {
        Map props = definition.getProperties();
        String statusFilterString = (String)props.get(PROPERTY_STATUS_FILTER);
        if (statusFilterString == null || statusFilterString.isEmpty()) {
            throw new ValidationException(new String[]{HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ErrorNoStatusEmpty", new Object[0])});
        }
        if (!"0".equals(statusFilterString)) {
            String[] statusDisplayValues = statusFilterString.split(";");
            List<String> statusDisplayValueList = Arrays.asList(statusDisplayValues);
            FilterableFieldListGenerator generator = FilterableFieldListGenerator.getInstance();
            ArrayList<DataEntry> statusKeys = generator.getStatusKeys();
            List labelList = statusKeys.stream().map(e -> e.getLabel()).collect(Collectors.toList());
            for (String statusLabel : statusDisplayValueList) {
                if (labelList.contains(statusLabel)) continue;
                throw new ValidationException(new String[]{HelpDeskTaskPlannerServerPlugin.MSG.getMsg("NotNumber", new Object[]{statusLabel})});
            }
        }
        this.fieldValues.validate((AbstractDefinition)definition, guid);
    }

    public SummaryInfo getSummary(@Nonnull SeriesDefinition definition) {
        String statusString;
        String s = (String)definition.getProperties().get(PROPERTY_STATUS_FILTER);
        if ("0".equals(s)) {
            FilterableFieldListGenerator generator = FilterableFieldListGenerator.getInstance();
            s = generator.getStatusKeys().get(0).getLabel();
        }
        if ((statusString = s) == null) {
            statusString = HelpDeskTaskPlannerServerPlugin.MSG.getMsg("CategoryNoLonger", new Object[0]);
        }
        String descKey = "TicketCreatedSeriesSummaryInfoLabel";
        String key = HelpDeskTaskPlannerServerPlugin.MSG.getMsg("TicketsWithStatusSeries.summary.desc.filtered", new Object[]{statusString});
        return this.fieldValues.getSummary((AbstractDefinition)definition, this.currentLanguage(), key, "TicketsWithStatusSeries.summary.label", descKey);
    }

    private String currentLanguage() {
        return ClientLocale.getThreadLocale().toLanguageTag();
    }

    protected TicketsWithStatusSeries createInstanceFrom(@Nonnull SeriesDefinition definition, GUID guid) {
        String statusFilterString = definition.getProperties().getOrDefault(PROPERTY_STATUS_FILTER, "");
        ArrayList<Integer> statusFilter = new ArrayList<Integer>();
        if ("0".equals(statusFilterString)) {
            statusFilter.add(0);
        } else {
            String[] statusDisplayValues = statusFilterString.split(";");
            List<String> statusDisplayValueList = Arrays.asList(statusDisplayValues);
            FilterableFieldListGenerator generator = FilterableFieldListGenerator.getInstance();
            List chosenStatusValues = generator.getStatusKeys().stream().filter(e -> statusDisplayValueList.contains(e.getLabel())).map(e -> Integer.valueOf(e.getValue())).collect(Collectors.toList());
            statusFilter.addAll(chosenStatusValues);
        }
        List<Map<String, String>> data = this.fetchTicketDataAndStoreLastKnownStatus(definition, statusFilter);
        return new TicketsWithStatusSeries(data);
    }

    protected TaskPlanner getTaskPlanner() {
        return TaskPlanner.getInstance();
    }

    private List<Map<String, String>> fetchTicketDataAndStoreLastKnownStatus(SeriesDefinition definition, List<Integer> statusFilter) {
        UserAccount user = UserManager.getInstance().getCurrentUserAccount();
        if (user == null) {
            HDLogger.warn((Object)"TicketWithStatusSeriesFactory: no current user");
            return new ArrayList<Map<String, String>>();
        }
        AndSearchExpression expressions = new AndSearchExpression();
        expressions.add((SearchExpression)new SearchCondition("statusid", SearchCondition.SearchTermOperator.IN, statusFilter));
        SearchCommand ticketsWithStatus = new SearchCommand(new SearchExpression[]{expressions});
        SearchResult searchResult = TicketManager.getReader().getSearchEngine().search(ticketsWithStatus);
        ArrayList<Map<String, String>> ticketData = new ArrayList<Map<String, String>>();
        TicketFilterChecker checker = new TicketFilterChecker(definition.getProperties());
        ServerValuesConnector svc = (ServerValuesConnector)ServerPluginManager.getInstance().getSingleInstance(ServerValuesConnector.class);
        for (SearchResultEntry entry : searchResult.getEntries()) {
            int ticketId = (Integer)entry.getId();
            Set createdIds = (Set)TicketsWithStatusSeries.TICKET_IDS_CHANGED_BY_THIS_TASK.get();
            if (createdIds != null && createdIds.contains(ticketId)) continue;
            try {
                TicketVO ticket = TicketManager.getReader().getTicket(ticketId);
                if (ticket == null || !checker.check(svc, ticket, user)) continue;
                ticketData.add(HDPlaceholderUtils.fillPlaceholderValuesFor(ticket));
            }
            catch (AccessDeniedException e) {
                HDLogger.warn((Object)("Access denied when reading ticket " + ticketId + " in TicketsWithStatusSeriesFactory: " + e.getMessage()));
            }
        }
        return ticketData;
    }

    @Nonnull
    public Set<String> getKeys(@Nonnull SeriesDefinition definition) {
        return new HashSet<String>(HDPlaceholders.getHDPlaceholderKeys());
    }

    public boolean isAvailable() {
        UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
        return currentUserAccount != null && HDUsersAndGroups.isSupporter((UserAccount)currentUserAccount);
    }

    public Map<String, String> updateValues(@Nonnull SeriesDefinition definition, GUID taskID) {
        FilterableFieldListGenerator.updateResourceDisplayValueIfNecessary((AbstractDefinition)definition);
        return super.updateValues((AbstractDefinition)definition, taskID);
    }
}

