/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.taskplanner.server.job.addtexttorequestjob;

import com.inet.config.structure.model.LocalizedKey;
import com.inet.helpdesk.core.ticketmanager.model.AutoTextManager;
import com.inet.helpdesk.core.ticketmanager.model.AutoTextVO;
import com.inet.helpdesk.plugins.taskplanner.HelpDeskTaskPlannerServerPlugin;
import com.inet.helpdesk.plugins.taskplanner.server.job.addtexttorequestjob.AddTextToRequestJob;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.taskplanner.server.api.common.SummaryEntry;
import com.inet.taskplanner.server.api.error.ValidationException;
import com.inet.taskplanner.server.api.field.Field;
import com.inet.taskplanner.server.api.field.FieldCondition;
import com.inet.taskplanner.server.api.field.LabelField;
import com.inet.taskplanner.server.api.field.SelectField;
import com.inet.taskplanner.server.api.field.TextField;
import com.inet.taskplanner.server.api.job.ConditionInfo;
import com.inet.taskplanner.server.api.job.JobDefinition;
import com.inet.taskplanner.server.api.job.JobFactory;
import com.inet.taskplanner.server.api.job.JobInfo;
import com.inet.taskplanner.server.api.job.JobSummaryInfo;
import com.inet.taskplanner.server.api.result.ResultFlavor;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AddTextToRequestJobFactory
extends JobFactory<AddTextToRequestJob> {
    public static final String EXTENSION_NAME = "taskplanner.helpdesk.addtexttorequest";

    public AddTextToRequestJobFactory() {
        super(EXTENSION_NAME);
    }

    public List<ResultFlavor> getResultFlavors(JobDefinition jobDefinition) {
        return new ArrayList<ResultFlavor>();
    }

    public JobInfo getInformation(@Nullable GUID guid) {
        String name = HelpDeskTaskPlannerServerPlugin.MSG.getMsg("AddAutoTextCategory", new Object[0]);
        String description = HelpDeskTaskPlannerServerPlugin.MSG.getMsg("AddAutoTextCategoryDesc", new Object[0]);
        URL iconURL = ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/plugins/taskplanner/structure/addtext_32.png");
        String helpKey = "taskplanner.job.addtexttorequest";
        ArrayList<Object> fields = new ArrayList<Object>();
        List autoTextValues = AutoTextManager.getInstance().getAllAutoTexts();
        TextField textField = new TextField("Ticket ID", HelpDeskTaskPlannerServerPlugin.MSG.getMsg("TicketIDLabel", new Object[0]));
        textField.setValue("{Ticket ID}");
        fields.add(textField);
        ArrayList autotexts = autoTextValues.stream().map(t -> new LocalizedKey(t.getLabel(), t.getLabel())).collect(Collectors.toCollection(ArrayList::new));
        String autoTextLabelAlways = HelpDeskTaskPlannerServerPlugin.MSG.getMsg("AddAutoTextCategoryAutoTextLabelAlways", new Object[0]);
        SelectField selectFieldAlways = new SelectField("AutoText", autoTextLabelAlways, autotexts);
        fields.add(selectFieldAlways);
        TextField prefixField = new TextField("AutoTextPrefix", HelpDeskTaskPlannerServerPlugin.MSG.getMsg("AddAutoTextPrefixLabel", new Object[0]));
        prefixField.setValue(HelpDeskTaskPlannerServerPlugin.MSG.getMsg("AddAutoTextPrefixLabel.default", new Object[0]));
        if (autoTextValues.size() > 0) {
            selectFieldAlways.setValue(((AutoTextVO)autoTextValues.get(0)).getLabel());
        } else {
            LabelField label = new LabelField("AddAutoTextCategory.NoAutotext", HelpDeskTaskPlannerServerPlugin.MSG.getMsg("AddAutoTextCategoryAutoTextLabelAlways", new Object[0]), HelpDeskTaskPlannerServerPlugin.MSG.getMsg("AddAutoTextCategory.NoAutotext.text", new Object[0]));
            fields.add(label);
            ArrayList<FieldCondition> conditions = new ArrayList<FieldCondition>();
            conditions.add(FieldCondition.visible((Field)prefixField, (FieldCondition.OP)FieldCondition.OP.equals, (String)GUID.generateNew().toString()));
            textField.setConditions(conditions);
            selectFieldAlways.setConditions(conditions);
        }
        fields.add(prefixField);
        String inquiryOrLatestLabel = HelpDeskTaskPlannerServerPlugin.MSG.getMsg("AddAutoTextInquiryOrLatestLabel", new Object[0]);
        ArrayList<LocalizedKey> inquiryOrLatestOptions = new ArrayList<LocalizedKey>();
        inquiryOrLatestOptions.add(new LocalizedKey("inquiry", HelpDeskTaskPlannerServerPlugin.MSG.getMsg("AddAutoTextInquiryOrLatest.inquiry", new Object[0])));
        inquiryOrLatestOptions.add(new LocalizedKey("latest", HelpDeskTaskPlannerServerPlugin.MSG.getMsg("AddAutoTextInquiryOrLatest.latest", new Object[0])));
        SelectField anfrageOderNeuestenReaStep = new SelectField("InquiryOrLatest", inquiryOrLatestLabel, inquiryOrLatestOptions);
        anfrageOderNeuestenReaStep.setValue("inquiry");
        fields.add(anfrageOderNeuestenReaStep);
        return new JobInfo(this.getExtensionName(), name, description, iconURL, helpKey, new ConditionInfo(new ArrayList()), fields, new ArrayList());
    }

    public void validate(@Nonnull JobDefinition definition, @Nullable GUID guid) throws ValidationException {
        Map props = definition.getProperties();
        if (props.get("AutoText") == null) {
            throw new ValidationException(new String[]{HelpDeskTaskPlannerServerPlugin.MSG.getMsg("AddAutoTextCategoryAutoTextMissing", new Object[0])});
        }
        if (props.get("Ticket ID") == null || ((String)props.get("Ticket ID")).isEmpty()) {
            throw new ValidationException(new String[]{HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ErrorNoTicketEmpty", new Object[0])});
        }
    }

    protected void validateCondition(@Nonnull JobDefinition jobDefinition) throws ValidationException {
    }

    public boolean isAvailable() {
        UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
        return currentUserAccount != null && HDUsersAndGroups.isSupporter((UserAccount)currentUserAccount);
    }

    public JobSummaryInfo getSummary(@Nonnull JobDefinition definition) {
        ArrayList<SummaryEntry> summary = new ArrayList<SummaryEntry>();
        if (definition.getProperty("AutoText") == null) {
            summary.add(new SummaryEntry("", HelpDeskTaskPlannerServerPlugin.MSG.getMsg("AddAutoTextNeedAutoTextSetting", new Object[0])));
            return new JobSummaryInfo(summary, new ArrayList());
        }
        String autoTextLabel = definition.getProperty("AutoText");
        List autoTextValues = AutoTextManager.getInstance().getAllAutoTexts();
        String finalAutoTextLabel = autoTextLabel;
        if (autoTextValues.stream().noneMatch(a -> a.getLabel().equalsIgnoreCase(finalAutoTextLabel))) {
            autoTextLabel = HelpDeskTaskPlannerServerPlugin.MSG.getMsg("CategoryNoLonger", new Object[0]);
        }
        String infokey = "inquiry".equals(definition.getProperty("InquiryOrLatest")) ? "AddAutoTextCategorySummaryInfoValue.inquiry" : "AddAutoTextCategorySummaryInfoValue.latest";
        summary.add(new SummaryEntry("", HelpDeskTaskPlannerServerPlugin.MSG.getMsg(infokey, new Object[]{autoTextLabel})));
        return new JobSummaryInfo(summary, new ArrayList());
    }

    protected AddTextToRequestJob createInstanceFrom(@Nonnull JobDefinition definition, @Nullable GUID taskID) {
        return new AddTextToRequestJob(definition, taskID);
    }
}

