/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.taskplanner.server.action.addticketsharing;

import com.inet.error.ErrorCode;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.TicketManipulator;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepField;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.WithAdditionalReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.tickets.additionalaccess.TicketAdditionalAccessValue;
import com.inet.helpdesk.plugins.taskplanner.server.HDPlaceholderUtils;
import com.inet.helpdesk.plugins.taskplanner.server.HDTaskPlannerUtils;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonException;
import com.inet.lib.json.JsonParameterizedType;
import com.inet.taskplanner.server.api.action.ResultAction;
import com.inet.taskplanner.server.api.error.TaskExecutionException;
import com.inet.taskplanner.server.api.error.TaskPlannerCodes;
import com.inet.taskplanner.server.api.job.JobResultContainer;
import com.inet.usersandgroups.api.Hash;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class AddTicketSharingAction
extends ResultAction {
    private final List<Integer> ticketIds;
    private final String accessType;
    private final String receiverJson;
    private final GUID taskID;

    public AddTicketSharingAction(String ticketIds, String accessType, String receiverJson, @Nullable GUID taskID) {
        this.ticketIds = HDPlaceholderUtils.getTicketIds(ticketIds);
        this.accessType = accessType;
        this.receiverJson = receiverJson;
        this.taskID = taskID;
    }

    protected void handle(List<JobResultContainer> results) throws TaskExecutionException {
        this.setProgress(0);
        ArrayList<Exception> toThrow = new ArrayList<Exception>();
        for (Integer ticketId : this.ticketIds) {
            try {
                WithAdditionalReaStepData addReaStepData = WithAdditionalReaStepData.create((ReaStepField)ReaStepVO.FIELD_TASKPLANNER_TASKID, (Object)this.taskID);
                try {
                    Hash hash;
                    GUID guid;
                    Map targets;
                    MutableTicketData ticketData = new MutableTicketData();
                    TicketAdditionalAccessValue value = new TicketAdditionalAccessValue();
                    try {
                        targets = (Map)new Json().fromJson(this.receiverJson, (Type)new JsonParameterizedType(HashMap.class, new Type[]{String.class, ArrayList.class}));
                    }
                    catch (JsonException e) {
                        throw new TaskExecutionException((Throwable)e, (ErrorCode)TaskPlannerCodes.GenericExecutionError);
                    }
                    if (targets.get("user") != null) {
                        for (String guidStr : (List)targets.get("user")) {
                            guid = GUID.valueOf((String)guidStr);
                            hash = Hash.forUser((GUID)guid);
                            if ("write".equals(this.accessType)) {
                                value.setWriteAccessFor(hash);
                                continue;
                            }
                            value.setReadAccessFor(hash);
                        }
                    }
                    if (targets.get("group") != null) {
                        for (String guidStr : (List)targets.get("group")) {
                            guid = GUID.valueOf((String)guidStr);
                            hash = Hash.forGroup((GUID)guid);
                            if ("write".equals(this.accessType)) {
                                value.setWriteAccessFor(hash);
                                continue;
                            }
                            value.setReadAccessFor(hash);
                        }
                    }
                    ticketData.put("additionalticketaccess", (Object)value);
                    TicketManipulator tm = TicketManager.getManipulator();
                    tm.updateTicketData(ticketId.intValue(), ticketData);
                }
                finally {
                    if (addReaStepData == null) continue;
                    addReaStepData.close();
                }
            }
            catch (Exception e) {
                toThrow.add((Exception)new TaskExecutionException((Throwable)e, (ErrorCode)TaskPlannerCodes.GenericExecutionError));
            }
        }
        if (toThrow.size() > 0) {
            throw HDTaskPlannerUtils.combinedException(toThrow);
        }
        this.setProgress(100);
    }
}

