/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.taskplanner.server.trigger.toomanytickets;

import com.inet.fieldsettings.api.model.FieldSettingsType;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.TicketTextFunctions;
import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.fields.category.CategoryManager;
import com.inet.helpdesk.core.ticketmanager.fields.category.CategoryVO;
import com.inet.helpdesk.core.ticketmanager.fields.location.LocationManager;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.events.domain.TicketEvent;
import com.inet.helpdesk.core.ticketmanager.model.events.domain.TicketEventListener;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.helpdesk.plugins.taskplanner.server.HDTaskPlannerDataListener;
import com.inet.helpdesk.plugins.taskplanner.server.TicketFilterChecker;
import com.inet.helpdesk.plugins.ticketprocess.server.api.TicketProcessManager;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.TicketProcess;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.helpdesk.usersandgroups.groups.HelpDeskUserGroupManager;
import com.inet.id.GUID;
import com.inet.permissions.AccessDeniedException;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.plugin.ServerPluginManager;
import com.inet.search.SearchResult;
import com.inet.search.SearchResultEntry;
import com.inet.search.command.OrSearchExpression;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.taskplanner.server.api.TaskExecution;
import com.inet.taskplanner.server.api.TaskPlanner;
import com.inet.taskplanner.server.api.trigger.Trigger;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.ui.fields.FieldDefinition;
import com.inet.usersandgroups.api.ui.fields.user.UserFieldDefinition;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountScope;
import com.inet.usersandgroups.api.user.UserManager;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.stream.Collectors;

public class TooManyTicketsTrigger
implements Trigger,
TicketEventListener {
    public static final String PROPERTY_CATEGORY = "Category";
    public static final String PROPERTY_RESOURCE = "Resource";
    public static final String PROPERTY_RESOURCE_DISPLAY = "TooManyTicketsResource.display";
    public static final String PROPERTY_CATEGORY_DISPLAY = "Category.display";
    public static final String ALREADY_TRIGGERED = "alreadytriggered";
    private GUID taskOwner;
    private Trigger.TriggerAction triggerAction;
    private final GUID triggerGuid;
    private GUID guid;
    private final int howMany;
    private final TooManyTicketsConditionProps firstProps;
    private final String propsConnector;
    private final TooManyTicketsConditionProps secondProps;
    private final ConnectionFactory connectionFactory;
    private boolean isSoonGoingToTriggerIfNeeded;
    protected static int DELAY = 2000;
    static TicketProcessManager tpmInstance;

    public TooManyTicketsTrigger(GUID taskId, GUID triggerId, Map<String, String> properties) {
        this.guid = taskId;
        this.triggerGuid = triggerId;
        this.connectionFactory = (ConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(ConnectionFactory.class);
        this.firstProps = new TooManyTicketsConditionProps("", properties);
        this.secondProps = new TooManyTicketsConditionProps("Second.", properties);
        this.propsConnector = properties.get("SecondFilterAndOrNone");
        String howManyString = properties.get("toomanytickets.howmany");
        this.howMany = howManyString == null ? Integer.MAX_VALUE : Integer.valueOf(howManyString);
    }

    public void activate(GUID taskGUID, Trigger.TriggerAction triggerAction) {
        this.taskOwner = this.getOwnerId(taskGUID);
        this.triggerAction = triggerAction;
        HDTaskPlannerDataListener.addListener(this);
    }

    protected GUID getOwnerId(GUID taskGUID) {
        return TaskPlanner.getInstance().getTaskExecution(taskGUID).getOwnerId();
    }

    public void deactivate() {
        this.triggerAction = null;
        HDTaskPlannerDataListener.removeListener(this);
    }

    public void handleEvent(TicketEvent ticketEvent) {
        if (this.triggerAction == null) {
            return;
        }
        this.triggerIfNeeded();
    }

    private void triggerIfNeeded() {
        if (this.isSoonGoingToTriggerIfNeeded) {
            return;
        }
        final Trigger.TriggerAction a = this.triggerAction;
        if (a != null) {
            CategoryVO cat;
            Integer catId;
            if (this.firstProps.categoryId != null) {
                catId = Integer.valueOf(this.firstProps.categoryId);
                cat = (CategoryVO)CategoryManager.getInstance().get(catId.intValue());
                String string = this.firstProps.betreff = cat == null ? null : cat.getPath();
            }
            if (this.secondProps.categoryId != null) {
                catId = Integer.valueOf(this.secondProps.categoryId);
                cat = (CategoryVO)CategoryManager.getInstance().get(catId.intValue());
                this.secondProps.betreff = cat == null ? null : cat.getPath();
            }
            this.isSoonGoingToTriggerIfNeeded = true;
            final Timer t = new Timer("runTrigger");
            t.schedule(new TimerTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try (UserAccountScope scope = UserAccountScope.create((GUID)TooManyTicketsTrigger.this.taskOwner);){
                        if (TooManyTicketsTrigger.this.isTooManyTickets()) {
                            if (!TooManyTicketsTrigger.this.wasTriggeredLastTime()) {
                                TooManyTicketsTrigger.this.setTriggeredLastTime(true);
                                a.run();
                            }
                        } else if (TooManyTicketsTrigger.this.wasTriggeredLastTime()) {
                            TooManyTicketsTrigger.this.setTriggeredLastTime(false);
                        }
                        t.cancel();
                    }
                    catch (Throwable t2) {
                        HDLogger.error((Object)t2);
                    }
                    finally {
                        TooManyTicketsTrigger.this.isSoonGoingToTriggerIfNeeded = false;
                    }
                }
            }, DELAY);
        }
    }

    private void setTriggeredLastTime(boolean wasTriggered) {
        TaskExecution taskExecution = TaskPlanner.getInstance().getTaskExecution(this.guid);
        if (taskExecution != null) {
            Map stateProperties = taskExecution.getStateProperties();
            stateProperties.put(this.triggeredKey(), "" + wasTriggered);
        }
    }

    private String triggeredKey() {
        return String.valueOf(this.guid) + "/" + String.valueOf(this.triggerGuid) + "/alreadytriggered";
    }

    private boolean wasTriggeredLastTime() {
        TaskExecution taskExecution = TaskPlanner.getInstance().getTaskExecution(this.guid);
        if (taskExecution != null) {
            Map stateProperties = taskExecution.getStateProperties();
            return "true".equals(stateProperties.get(this.triggeredKey()));
        }
        return false;
    }

    private boolean isTooManyTickets() {
        Set<Integer> tickets = this.setOfTicketsIn(this.firstProps);
        if (this.propsConnector != null) {
            switch (this.propsConnector) {
                case "SecondFilterAnd": {
                    Set<Integer> secondTickets = this.setOfTicketsIn(this.secondProps);
                    tickets.retainAll(secondTickets);
                    break;
                }
                case "SecondFilterOr": {
                    Set<Integer> secondTickets = this.setOfTicketsIn(this.secondProps);
                    tickets.addAll(secondTickets);
                    break;
                }
            }
        }
        return tickets.size() > this.howMany;
    }

    private static TicketProcessManager getTPMInstance() {
        if (tpmInstance != null) {
            return tpmInstance;
        }
        return (TicketProcessManager)ServerPluginManager.getInstance().getSingleInstance(TicketProcessManager.class);
    }

    private Set<Integer> setOfTicketsIn(TooManyTicketsConditionProps props) {
        UserAccount user = UserManager.getInstance().getCurrentUserAccount();
        if (user == null) {
            HDLogger.warn((Object)"TriggerTicketDataChangeListener: no current user - no ticket list");
            return new HashSet<Integer>();
        }
        ArrayList<SearchExpression> searchExpressions = new ArrayList<SearchExpression>();
        searchExpressions.add((SearchExpression)new SearchCondition("statusid", SearchCondition.SearchTermOperator.BETWEEN, (Object)new Object[]{0, 299}));
        searchExpressions.add((SearchExpression)new SearchCondition("dispatchingreastepid", SearchCondition.SearchTermOperator.StartsWith, (Object)""));
        boolean onlyMyResources = "OnlyMyResourcesDataEntryId".equals(props.resId);
        if (onlyMyResources) {
            Object resourceIds = HelpDeskUserGroupManager.getInstance().getGroupsForUserIncludingDeactivated(user.getID()).stream().filter(g -> g.getType() == HDUsersAndGroups.RESOURCE).map(UserGroupInfo::getID).collect(Collectors.toList());
            searchExpressions.add((SearchExpression)new SearchCondition("resourceid", SearchCondition.SearchTermOperator.IN, resourceIds));
        }
        switch (props.filterType) {
            case "FilterTypeResource": {
                if (onlyMyResources) break;
                if (props.resId == null) {
                    return new HashSet<Integer>();
                }
                Integer propResId = Integer.valueOf(props.resId);
                searchExpressions.add((SearchExpression)new SearchCondition("resourceid", SearchCondition.SearchTermOperator.Equals, (Object)this.getResGUID(propResId)));
                break;
            }
            case "FilterTypeCreated": {
                String weeks = props.createdWeeks;
                String mode = props.createdMode;
                String key = "inquirydate";
                boolean wasValid = TooManyTicketsTrigger.addSearchExpressionsForPastDate(weeks, mode, searchExpressions, key);
                if (wasValid) break;
                return new HashSet<Integer>();
            }
            case "FilterTypeLastModified": {
                String weeks = props.lastModifiedWeeks;
                String mode = props.lastModifiedMode;
                String key = "lastchanged";
                boolean wasValid = TooManyTicketsTrigger.addSearchExpressionsForPastDate(weeks, mode, searchExpressions, key);
                if (wasValid) break;
                return new HashSet<Integer>();
            }
            case "FilterTypeCategory": {
                if (props.categoryId == null || props.betreff == null) {
                    return new HashSet<Integer>();
                }
                if ("0".equals(props.categoryId)) {
                    OrSearchExpression orSearch = new OrSearchExpression();
                    orSearch.add((Object)new SearchCondition("categoryid", SearchCondition.SearchTermOperator.Equals, (Object)0));
                    orSearch.add((Object)new SearchCondition("categoryid", SearchCondition.SearchTermOperator.Equals, null));
                    searchExpressions.add((SearchExpression)orSearch);
                    break;
                }
                if (props.includeSubCategories) {
                    int catId = Integer.valueOf(props.categoryId);
                    String mainPath = ((CategoryVO)CategoryManager.getInstance().get(catId)).getPath() + "\\";
                    List categoryAndDescendents = CategoryManager.getInstance().getAll(true).stream().filter(c -> c.getPath().startsWith(mainPath)).map(c -> c.getId()).collect(Collectors.toList());
                    categoryAndDescendents.add(catId);
                    searchExpressions.add((SearchExpression)new SearchCondition("categoryid", SearchCondition.SearchTermOperator.IN, categoryAndDescendents));
                    break;
                }
                searchExpressions.add((SearchExpression)new SearchCondition("categoryid", SearchCondition.SearchTermOperator.Equals, (Object)props.categoryId));
                break;
            }
            case "FilterTypeCustomerLocation": {
                if (props.customerLocation == null) {
                    return new HashSet<Integer>();
                }
                Integer locationID = Integer.valueOf(props.customerLocation);
                Set users = UserManager.getInstance().getSearchEngine().simpleSearch(new SearchCommand("location", SearchCondition.SearchTermOperator.Equals, (Object)locationID));
                searchExpressions.add((SearchExpression)new SearchCondition("ownerid", SearchCondition.SearchTermOperator.IN, (Object)users));
                break;
            }
            case "FilterTypeOwnerField": {
                String field = props.ownerField;
                String value = props.ownerFieldValue;
                String dateValue = props.ownerFieldDateValue;
                if (field == null) {
                    return new HashSet<Integer>();
                }
                if (field.equals("location")) {
                    if (value == null) {
                        return new HashSet<Integer>();
                    }
                    List all = LocationManager.getInstance().getAll(true);
                    Set<Integer> locations = all.stream().filter(l -> l.getDisplayValue().toLowerCase().contains(value.toLowerCase())).map(l -> l.getId()).collect(Collectors.toSet());
                    Set<GUID> users = this.searchUsers(locations);
                    searchExpressions.add((SearchExpression)new SearchCondition("ownerid", SearchCondition.SearchTermOperator.IN, users));
                    break;
                }
                List fieldDefinitionsRaw = DynamicExtensionManager.getInstance().get(FieldDefinition.class);
                FieldDefinition actualField = fieldDefinitionsRaw.stream().sorted(Comparator.comparingInt(FieldDefinition::getPriority)).filter(f -> f instanceof UserFieldDefinition && f.getFieldKey() != null && f.getLabel() != null && !f.getLabel().isBlank() && f.getFieldKey().equals(field)).findFirst().orElse(null);
                if ("fieldtype_date".equals(actualField.getDisplayType()) || "fieldtype_date_time".equals(actualField.getDisplayType())) {
                    if (dateValue == null) {
                        return new HashSet<Integer>();
                    }
                    Long latestMillis = System.currentTimeMillis() + Long.valueOf(dateValue) * 7L * 24L * 60L * 60L * 1000L;
                    Set users = UserManager.getInstance().getSearchEngine().simpleSearch(new SearchCommand(field, SearchCondition.SearchTermOperator.LE, (Object)latestMillis));
                    searchExpressions.add((SearchExpression)new SearchCondition("ownerid", SearchCondition.SearchTermOperator.IN, (Object)users));
                    break;
                }
                if (value == null) {
                    return new HashSet<Integer>();
                }
                Set users = UserManager.getInstance().getSearchEngine().simpleSearch(new SearchCommand(field, SearchCondition.SearchTermOperator.Contains, (Object)value));
                searchExpressions.add((SearchExpression)new SearchCondition("ownerid", SearchCondition.SearchTermOperator.IN, (Object)users));
                break;
            }
            case "FilterTypeProcessFilter": {
                if (!ServerPluginManager.getInstance().isPluginLoaded("ticketprocess")) {
                    return new HashSet<Integer>();
                }
                switch (props.processFilterType) {
                    case "ProcessFilter.none": {
                        searchExpressions.add((SearchExpression)new SearchCondition("ticketprocess", SearchCondition.SearchTermOperator.Equals, null));
                        break;
                    }
                    case "ProcessFilter.anyprocess": {
                        searchExpressions.add((SearchExpression)new SearchCondition("ticketprocess", SearchCondition.SearchTermOperator.StartsWith, (Object)""));
                        break;
                    }
                    case "ProcessFilter.specific": {
                        if (props.process == null) {
                            return new HashSet<Integer>();
                        }
                        GUID processID = GUID.valueOf((String)props.process);
                        TicketProcess process = TooManyTicketsTrigger.getTPMInstance().getProcess(processID);
                        searchExpressions.add((SearchExpression)new SearchCondition("ticketprocess", SearchCondition.SearchTermOperator.Equals, (Object)process.getName().toLowerCase()));
                    }
                }
                break;
            }
            default: {
                boolean foundField = props.filterType.equals("FilterTypeInquiryText") || props.filterType.equals("FilterTypeNone");
                List fieldDefs = DynamicExtensionManager.getInstance().get(TicketFieldDefinition.class);
                Collections.sort(fieldDefs, Comparator.comparingInt(TicketFieldDefinition::getPriority));
                for (TicketFieldDefinition d : fieldDefs) {
                    if (!d.getFieldKey().equals(props.filterType)) continue;
                    if (FieldSettingsType.TYPE_DATE.equals((Object)d.getDisplayType()) || FieldSettingsType.TYPE_DATE_TIME.equals((Object)d.getDisplayType())) {
                        if (props.dynamicValue == null) {
                            return new HashSet<Integer>();
                        }
                        foundField = true;
                        Long latestMillis = System.currentTimeMillis() + Long.valueOf(props.dynamicValue) * 7L * 24L * 60L * 60L * 1000L;
                        searchExpressions.add((SearchExpression)new SearchCondition(d.getFieldKey(), SearchCondition.SearchTermOperator.LE, (Object)latestMillis));
                        continue;
                    }
                    foundField = true;
                    searchExpressions.add((SearchExpression)new SearchCondition(d.getFieldKey(), SearchCondition.SearchTermOperator.Equals, (Object)props.dynamicValue));
                }
                if (foundField) break;
                searchExpressions.add((SearchExpression)new SearchCondition("ownerid", SearchCondition.SearchTermOperator.Equals, (Object)"someownerguidthatdoesntexist!"));
            }
        }
        SearchCommand command = new SearchCommand(searchExpressions.toArray(new SearchExpression[0]));
        SearchResult foundTickets = TicketManager.getReader().getSearchEngine().search(command);
        if (props.filterType.equals("FilterTypeInquiryText")) {
            return new HashSet<Integer>(foundTickets.getEntries().stream().filter(e -> {
                try {
                    TicketVO ticket = TicketManager.getReader().getTicket(((Integer)e.getId()).intValue());
                    if (ticket != null) {
                        ReaStepTextVO inquiryTextVO = TicketManager.getReader().getReaStepText(ticket.getInitialReaStepID());
                        if (inquiryTextVO == null) {
                            return props.inquiryText.isBlank();
                        }
                        String text = inquiryTextVO.hasHtmlContent() ? TicketTextFunctions.convertToPlainText((String)inquiryTextVO.getText()) : inquiryTextVO.getText();
                        return text.toLowerCase().contains(props.inquiryText.toLowerCase());
                    }
                }
                catch (AccessDeniedException accessDeniedException) {
                    // empty catch block
                }
                return false;
            }).map(SearchResultEntry::getId).collect(Collectors.toSet()));
        }
        HDLogger.debug((Object)("found " + foundTickets.getEntries().size() + " tickets for TooManyTicketsTrigger"));
        return new HashSet<Integer>(foundTickets.getEntries().stream().map(e -> (Integer)e.getId()).collect(Collectors.toSet()));
    }

    private static boolean addSearchExpressionsForPastDate(String weeks, String mode, List<SearchExpression> searchExpressions, String key) {
        if (weeks == null || weeks.isBlank()) {
            return false;
        }
        ZonedDateTime now = ZonedDateTime.now();
        ZonedDateTime periodAgo = TicketFilterChecker.calculatePeriodAgo(now, weeks);
        if ("within".equals(mode)) {
            searchExpressions.add((SearchExpression)new SearchCondition(key, SearchCondition.SearchTermOperator.GE, (Object)periodAgo.toInstant().toEpochMilli()));
            searchExpressions.add((SearchExpression)new SearchCondition(key, SearchCondition.SearchTermOperator.LE, (Object)now.toInstant().toEpochMilli()));
            return true;
        }
        if ("before".equals(mode)) {
            searchExpressions.add((SearchExpression)new SearchCondition(key, SearchCondition.SearchTermOperator.LE, (Object)periodAgo.toInstant().toEpochMilli()));
            return true;
        }
        return false;
    }

    protected GUID getResGUID(Integer propResId) {
        return HDUsersAndGroups.getResource((int)propResId).getID();
    }

    protected Set<GUID> searchUsers(Set<Integer> locations) {
        return UserManager.getInstance().getSearchEngine().simpleSearch(new SearchCommand("location", SearchCondition.SearchTermOperator.IN, locations));
    }

    private static class TooManyTicketsConditionProps {
        private final boolean includeSubCategories;
        private final String inquiryText;
        private final String ownerField;
        private final String ownerFieldValue;
        private final String ownerFieldDateValue;
        private final String processFilterType;
        private final String process;
        private final String customerLocation;
        private final String categoryId;
        private final String createdWeeks;
        private final String lastModifiedWeeks;
        private final String createdMode;
        private final String lastModifiedMode;
        private String betreff;
        private final String resId;
        private final String filterType;
        private final String dynamicValue;

        private TooManyTicketsConditionProps(String keyPrefix, Map<String, String> properties) {
            String filterType;
            String fflg = "fflg.";
            String fKeyPrefix = fflg + keyPrefix;
            this.categoryId = properties.get(keyPrefix + TooManyTicketsTrigger.PROPERTY_CATEGORY);
            this.resId = properties.containsKey(keyPrefix + "Resource.noNoneEntry") ? properties.get(keyPrefix + "Resource.noNoneEntry") : properties.get(keyPrefix + TooManyTicketsTrigger.PROPERTY_RESOURCE);
            this.filterType = filterType = properties.get(keyPrefix + "FilterType");
            List fieldDefs = DynamicExtensionManager.getInstance().get(TicketFieldDefinition.class);
            Collections.sort(fieldDefs, Comparator.comparingInt(TicketFieldDefinition::getPriority));
            String dynamicValue = "";
            for (TicketFieldDefinition d : fieldDefs) {
                if (!d.getFieldKey().equals(this.filterType)) continue;
                dynamicValue = properties.get(fKeyPrefix + d.getFieldKey());
                break;
            }
            this.dynamicValue = dynamicValue;
            this.includeSubCategories = "true".equals(properties.get(keyPrefix + "IncludeSubcategories"));
            this.inquiryText = properties.get(keyPrefix + "InquiryText");
            this.ownerField = properties.get(keyPrefix + "OwnerField");
            this.ownerFieldValue = properties.get(keyPrefix + "OwnerFieldValue");
            this.ownerFieldDateValue = properties.get(keyPrefix + "OwnerFieldDateValue");
            this.processFilterType = properties.get(keyPrefix + "FilterTypeProcessFilter");
            this.process = properties.get(keyPrefix + "PropProcess");
            this.customerLocation = properties.get(keyPrefix + "CustomerLocation");
            this.createdWeeks = properties.get(keyPrefix + "CreatedDateValue");
            this.lastModifiedWeeks = properties.get(keyPrefix + "LastModifiedDateValue");
            this.createdMode = properties.getOrDefault(keyPrefix + "CreatedDateMode", "within");
            this.lastModifiedMode = properties.getOrDefault(keyPrefix + "LastModifiedMode", "within");
        }
    }
}

