/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.taskplanner.server;

import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.plugins.taskplanner.server.HDPlaceholderUtils;
import com.inet.helpdesk.plugins.taskplanner.server.HDTaskPlannerDataListener;
import com.inet.permissions.AccessDeniedException;
import java.util.Iterator;
import java.util.Map;

public class TicketIterator
implements Iterator<Map<String, String>> {
    private long lastMarker = 0L;
    private final Object monitor;
    private final TicketListProvider provider;

    public TicketIterator(TicketListProvider provider, Object monitor) {
        this.provider = provider;
        this.monitor = monitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasNext() {
        Object object = this.monitor;
        synchronized (object) {
            HDTaskPlannerDataListener.TicketEvent nextTicket = this.provider.getNextTicketAfter(this.lastMarker);
            if (nextTicket != null) {
                return true;
            }
            this.provider.registerIteratorFinished(System.currentTimeMillis());
            return false;
        }
    }

    @Override
    public Map<String, String> next() {
        HDTaskPlannerDataListener.TicketEvent nextTicket = this.provider.getNextTicketAfter(this.lastMarker);
        if (nextTicket == null) {
            return null;
        }
        try {
            TicketVO ticket = TicketManager.getReader().getTicket(nextTicket.ticketId.intValue());
            this.lastMarker = nextTicket.getMarker();
            if (ticket == null) {
                return this.next();
            }
            return HDPlaceholderUtils.fillPlaceholderValuesFor(ticket);
        }
        catch (AccessDeniedException exc) {
            return this.next();
        }
    }

    public static interface TicketListProvider {
        public void registerIteratorFinished(long var1);

        public HDTaskPlannerDataListener.TicketEvent getNextTicketAfter(long var1);
    }
}

