/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.taskplanner.server.trigger.statuschange;

import com.inet.config.structure.model.LocalizedKey;
import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.core.ticketmanager.extension.TicketActionExtension;
import com.inet.helpdesk.core.ticketmanager.extension.TicketActionExtensionFactory;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.fields.status.StatusManager;
import com.inet.helpdesk.core.ticketmanager.fields.status.StatusVO;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationChangedTicket;
import com.inet.helpdesk.plugins.taskplanner.HelpDeskTaskPlannerServerPlugin;
import com.inet.helpdesk.plugins.taskplanner.server.FilterFieldValues;
import com.inet.helpdesk.plugins.taskplanner.server.FilterableFieldListGenerator;
import com.inet.helpdesk.plugins.taskplanner.server.HDPlaceholders;
import com.inet.helpdesk.plugins.taskplanner.server.series.ticketswithstatus.TicketsWithStatusSeriesFactory;
import com.inet.helpdesk.plugins.taskplanner.server.trigger.statuschange.StatusChangeTrigger;
import com.inet.helpdesk.plugins.taskplanner.server.trigger.statuschange.TicketActionTrigger;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.http.servlet.ClientLocale;
import com.inet.id.GUID;
import com.inet.taskplanner.server.api.DataEntry;
import com.inet.taskplanner.server.api.common.AbstractDefinition;
import com.inet.taskplanner.server.api.common.SummaryInfo;
import com.inet.taskplanner.server.api.error.ValidationException;
import com.inet.taskplanner.server.api.field.Field;
import com.inet.taskplanner.server.api.field.FieldCondition;
import com.inet.taskplanner.server.api.field.SelectField;
import com.inet.taskplanner.server.api.field.SelectInputFieldMulti;
import com.inet.taskplanner.server.api.trigger.Trigger;
import com.inet.taskplanner.server.api.trigger.TriggerDefinition;
import com.inet.taskplanner.server.api.trigger.TriggerFactory;
import com.inet.taskplanner.server.api.trigger.TriggerInfo;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.net.URL;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class StatusChangeTriggerFactory
extends TriggerFactory<Trigger>
implements TicketActionExtensionFactory {
    public static final String PROPERTY_WHEN_TO_TRIGGER = "PROPERTY_WHEN_TO_TRIGGER";
    public static final String PROPERTY_ACTION_TO_TRIGGER_ON = "PROPERTY_ACTION_TO_TRIGGER_ON";
    public static final String PROPERTY_FIELD_VALUE_TO_WATCH = "PROPERTY_FIELD_VALUE_TO_WATCH";
    public static final String WHEN_TO_TRIGGER_ALWAYS = "WHEN_TO_TRIGGER_ALWAYS";
    public static final String WHEN_TO_TRIGGER_ON_STATUS_CHANGE = "WHEN_TO_TRIGGER_ON_STATUS_CHANGE";
    public static final String WHEN_TO_TRIGGER_ON_FIELD_CHANGE = "WHEN_TO_TRIGGER_ON_FIELD_CHANGE";
    public static final String WHEN_TO_TRIGGER_ON_TICKET_ACTION = "WHEN_TO_TRIGGER_ON_TICKET_ACTION";
    public static final String WHEN_TO_TRIGGER_ON_FIELD_CHANGE_ANY = "WHEN_TO_TRIGGER_ON_FIELD_CHANGE_ANY";
    public static final String WHEN_TO_TRIGGER_IF_STATUS_IS = "WHEN_TO_TRIGGER_IF_STATUS_IS";
    public static final int SELECT_TYPE_ACTION = 121314;
    public static final String EXTENSION_NAME = "trigger.helpdesk.statuschange";
    private FilterFieldValues fieldValues;

    public StatusChangeTriggerFactory() {
        super(EXTENSION_NAME);
    }

    public TriggerInfo getInformation(@Nullable GUID guid) {
        if (this.fieldValues == null) {
            this.fieldValues = new FilterFieldValues(this.getFieldListGenerator());
        }
        URL iconURL = ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/plugins/taskplanner/structure/status_change_32.png");
        ArrayList<Field> fields = new ArrayList<Field>();
        SelectInputFieldMulti statusFilter = TicketsWithStatusSeriesFactory.createStatusSelectField(fields, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("StatusChangeTrigger.StatusFilter", new Object[0]));
        SelectInputFieldMulti actionFilter = new SelectInputFieldMulti(PROPERTY_ACTION_TO_TRIGGER_ON, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("StatusChangeTrigger.ActionToTriggerOn", new Object[0]), 121314);
        actionFilter.setValue("");
        fields.add((Field)actionFilter);
        ArrayList<Field> filterFieldChooser = this.fieldValues.getFilterFieldChooser();
        fields.addAll(filterFieldChooser);
        Set<String> defaultFilterList = FilterFieldValues.getDefaultFilterList();
        defaultFilterList.remove("FilterTypeOwnerField");
        defaultFilterList.remove("FilterTypeCustomerLocation");
        defaultFilterList.remove("FilterTypeInquiryText");
        ArrayList<LocalizedKey> keysWeHave = this.getFieldListGenerator().generateFieldChooserKeys(new ArrayList<LocalizedKey>(), defaultFilterList);
        keysWeHave.removeIf(l -> "FilterTypeNone".equals(l.getKey()));
        SelectField fieldValueToWatch = new SelectField(PROPERTY_FIELD_VALUE_TO_WATCH, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("FieldValueToWatch", new Object[0]), keysWeHave);
        fieldValueToWatch.setValue("FilterTypeCategory");
        fields.add(0, (Field)fieldValueToWatch);
        ArrayList<LocalizedKey> whenToTriggerOptions = new ArrayList<LocalizedKey>();
        whenToTriggerOptions.add(new LocalizedKey(WHEN_TO_TRIGGER_ALWAYS, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("StatusChangeTrigger.WhenToTrigger.Always", new Object[0])));
        whenToTriggerOptions.add(new LocalizedKey(WHEN_TO_TRIGGER_ON_STATUS_CHANGE, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("StatusChangeTrigger.WhenToTrigger.OnStatusChange", new Object[0])));
        whenToTriggerOptions.add(new LocalizedKey(WHEN_TO_TRIGGER_IF_STATUS_IS, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("StatusChangeTrigger.WhenToTrigger.IfStatusIs", new Object[0])));
        whenToTriggerOptions.add(new LocalizedKey(WHEN_TO_TRIGGER_ON_FIELD_CHANGE, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("StatusChangeTrigger.WhenToTrigger.OnFieldChange", new Object[0])));
        whenToTriggerOptions.add(new LocalizedKey(WHEN_TO_TRIGGER_ON_TICKET_ACTION, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("StatusChangeTrigger.WhenToTrigger.OnTicketAction", new Object[0])));
        whenToTriggerOptions.add(new LocalizedKey(WHEN_TO_TRIGGER_ON_FIELD_CHANGE_ANY, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("StatusChangeTrigger.WhenToTrigger.OnFieldChangeOfAnyKind", new Object[0])));
        SelectField whenToTrigger = new SelectField(PROPERTY_WHEN_TO_TRIGGER, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("StatusChangeTrigger.WhenToTrigger", new Object[0]), whenToTriggerOptions);
        whenToTrigger.setValue(WHEN_TO_TRIGGER_ON_STATUS_CHANGE);
        ArrayList<FieldCondition> conds = new ArrayList<FieldCondition>();
        conds.add(FieldCondition.visible((Field)whenToTrigger, (FieldCondition.OP)FieldCondition.OP.equals, (String)WHEN_TO_TRIGGER_ON_STATUS_CHANGE));
        conds.add(FieldCondition.visible((Field)whenToTrigger, (FieldCondition.OP)FieldCondition.OP.equals, (String)WHEN_TO_TRIGGER_IF_STATUS_IS));
        statusFilter.setConditions(conds);
        conds = new ArrayList();
        conds.add(FieldCondition.visible((Field)whenToTrigger, (FieldCondition.OP)FieldCondition.OP.equals, (String)WHEN_TO_TRIGGER_ON_TICKET_ACTION));
        actionFilter.setConditions(conds);
        conds = new ArrayList();
        conds.add(FieldCondition.visible((Field)whenToTrigger, (FieldCondition.OP)FieldCondition.OP.equals, (String)WHEN_TO_TRIGGER_ON_FIELD_CHANGE_ANY));
        fieldValueToWatch.setConditions(conds);
        fields.add(0, (Field)whenToTrigger);
        List<String> placeholderKeys = HDPlaceholders.getHDPlaceholderKeys();
        return new TriggerInfo(EXTENSION_NAME, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("StatusChangeTrigger.name", new Object[0]), HelpDeskTaskPlannerServerPlugin.MSG.getMsg("StatusChangeTrigger.desc", new Object[0]), iconURL, "taskplanner.trigger.status-change", fields, placeholderKeys);
    }

    public FilterableFieldListGenerator getFieldListGenerator() {
        return FilterableFieldListGenerator.getInstance();
    }

    public void validate(@Nonnull TriggerDefinition definition, GUID guid) throws ValidationException {
        Map props = definition.getProperties();
        if (WHEN_TO_TRIGGER_ON_FIELD_CHANGE.equals(props.get(PROPERTY_WHEN_TO_TRIGGER))) {
            if ("FilterTypeNone".equals(props.get("FilterType"))) {
                throw new ValidationException(new String[]{HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ErrorConditionRequired", new Object[0])});
            }
        } else if (WHEN_TO_TRIGGER_ON_TICKET_ACTION.equals(props.get(PROPERTY_WHEN_TO_TRIGGER))) {
            String statusFilterString = (String)props.get(PROPERTY_ACTION_TO_TRIGGER_ON);
            if (statusFilterString == null || statusFilterString.isEmpty()) {
                throw new ValidationException(new String[]{HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ErrorNoActionEmpty", new Object[0])});
            }
        } else if (!WHEN_TO_TRIGGER_ON_FIELD_CHANGE_ANY.equals(props.get(PROPERTY_WHEN_TO_TRIGGER)) && !WHEN_TO_TRIGGER_ALWAYS.equals(props.get(PROPERTY_WHEN_TO_TRIGGER))) {
            String statusFilterString = (String)props.get("statusFilter");
            if (statusFilterString == null || statusFilterString.isEmpty()) {
                throw new ValidationException(new String[]{HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ErrorNoStatusEmpty", new Object[0])});
            }
            if (!"0".equals(statusFilterString)) {
                String[] statusDisplayValues = statusFilterString.split(";");
                List<String> statusDisplayValueList = Arrays.asList(statusDisplayValues);
                FilterableFieldListGenerator generator = FilterableFieldListGenerator.getInstance();
                ArrayList<DataEntry> statusKeys = generator.getStatusKeys();
                List labelList = statusKeys.stream().map(e -> e.getLabel()).collect(Collectors.toList());
                for (String statusLabel : statusDisplayValueList) {
                    if (labelList.contains(statusLabel)) continue;
                    throw new ValidationException(new String[]{HelpDeskTaskPlannerServerPlugin.MSG.getMsg("NotNumber", new Object[]{statusLabel})});
                }
            }
        }
        this.fieldValues.validate((AbstractDefinition)definition, guid);
    }

    public SummaryInfo getSummary(@Nonnull TriggerDefinition definition) {
        String s;
        if (this.fieldValues == null) {
            this.fieldValues = new FilterFieldValues(this.getFieldListGenerator());
        }
        if ("0".equals(s = (String)definition.getProperties().get("statusFilter"))) {
            FilterableFieldListGenerator generator = FilterableFieldListGenerator.getInstance();
            s = generator.getStatusKeys().get(0).getLabel();
        }
        String statusString = s;
        String descKey = "TicketCreatedSeriesSummaryInfoLabel";
        String whenToTrigger = definition.getProperty(PROPERTY_WHEN_TO_TRIGGER);
        String baseLabelKey = "StatusChangeTrigger.summary.desc.filtered";
        if (WHEN_TO_TRIGGER_ALWAYS.equals(whenToTrigger) || WHEN_TO_TRIGGER_ON_FIELD_CHANGE.equals(whenToTrigger)) {
            baseLabelKey = "StatusChangeTrigger.summary.desc.filteredWithNoStatusChangeNeeded";
            if (WHEN_TO_TRIGGER_ON_FIELD_CHANGE.equals(whenToTrigger)) {
                descKey = "TicketCreatedSeriesSummaryInfoLabelFieldChange";
            }
        } else if (WHEN_TO_TRIGGER_ON_FIELD_CHANGE_ANY.equals(whenToTrigger)) {
            baseLabelKey = "TicketCreatedSeriesSummaryInfoLabelFieldChangeAny";
            String _typeKey = definition.getProperty(PROPERTY_FIELD_VALUE_TO_WATCH);
            statusString = this.getFieldListGenerator().getFilterTypeValuesMap().getOrDefault(ClientLocale.getThreadLocale().toLanguageTag(), new ArrayList()).stream().filter(k -> k.getKey().equals(_typeKey)).findFirst().map(LocalizedKey::getDisplayName).orElse("");
            if ("".equals(statusString) && Tickets.FIELD_ADDITIONAL_ACCESS.getKey().equals(_typeKey)) {
                statusString = Tickets.FIELD_ADDITIONAL_ACCESS.getLabel();
            }
        } else if (WHEN_TO_TRIGGER_ON_TICKET_ACTION.equals(whenToTrigger)) {
            baseLabelKey = "StatusChangeTrigger.summary.desc.filteredWithActionFilter";
            statusString = (String)definition.getProperties().get(PROPERTY_ACTION_TO_TRIGGER_ON);
            statusString = statusString.replace(";", " / ");
        } else if (WHEN_TO_TRIGGER_IF_STATUS_IS.equals(whenToTrigger)) {
            baseLabelKey = "StatusChangeTrigger.summary.desc.filteredWithStatusFilter";
        }
        if (statusString == null) {
            statusString = HelpDeskTaskPlannerServerPlugin.MSG.getMsg("CategoryNoLonger", new Object[0]);
        }
        String key = HelpDeskTaskPlannerServerPlugin.MSG.getMsg(baseLabelKey, new Object[]{statusString});
        return this.fieldValues.getSummary((AbstractDefinition)definition, ClientLocale.getThreadLocale().toLanguageTag(), key, "StatusChangeTrigger.summary.label", descKey);
    }

    public List<ZonedDateTime> getNextExecutionTimes(TriggerDefinition definition) {
        return super.getNextExecutionTimes(definition);
    }

    protected Trigger createInstanceFrom(@Nonnull TriggerDefinition definition, @Nullable GUID taskID) {
        String whenToTrigger = definition.getProperty(PROPERTY_WHEN_TO_TRIGGER);
        if (WHEN_TO_TRIGGER_ON_TICKET_ACTION.equals(whenToTrigger)) {
            return new TicketActionTrigger(definition, taskID);
        }
        String statusFilterString = definition.getProperties().getOrDefault("statusFilter", "");
        ArrayList<Integer> statusFilter = new ArrayList<Integer>();
        if ("0".equals(statusFilterString)) {
            statusFilter.add(0);
        } else {
            String[] statusDisplayValues = statusFilterString.split(";");
            List<String> statusDisplayValueList = Arrays.asList(statusDisplayValues);
            FilterableFieldListGenerator generator = FilterableFieldListGenerator.getInstance();
            List chosenStatusValues = generator.getStatusKeys().stream().filter(e -> statusDisplayValueList.contains(e.getLabel())).map(e -> Integer.valueOf(e.getValue())).collect(Collectors.toList());
            if (chosenStatusValues.size() == 0) {
                try {
                    Integer s = Integer.valueOf(statusFilterString);
                    StatusVO statusVO = (StatusVO)StatusManager.getInstance().get(s.intValue());
                    if (statusVO != null) {
                        statusFilter.add(s);
                        definition.getProperties().put("statusFilter", statusVO.getDisplayValue());
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            statusFilter.addAll(chosenStatusValues);
        }
        return new StatusChangeTrigger(definition, statusFilter, taskID);
    }

    public boolean isAvailable() {
        UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
        return currentUserAccount != null && HDUsersAndGroups.isSupporter((UserAccount)currentUserAccount);
    }

    public Map<String, String> updateValues(@Nonnull TriggerDefinition definition, GUID taskID) {
        FilterableFieldListGenerator.updateResourceDisplayValueIfNecessary((AbstractDefinition)definition);
        return super.updateValues((AbstractDefinition)definition, taskID);
    }

    @Nullable
    public TicketActionExtension createIfApplicable(@Nonnull OperationChangedTicket operationChangedTicket, @Nonnull ActionVO actionVO, @Nonnull ExtensionArguments extensionArguments, @Nonnull MutableReaStepData mutableReaStepData) {
        return null;
    }
}

