/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.taskplanner.server.trigger.statuschange;

import com.inet.config.ConfigValue;
import com.inet.editor.HtmlConverter;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ServerValuesConnector;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVOSlaveForEnduser;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.argcontainers.ProcessingTime;
import com.inet.helpdesk.core.ticketmanager.model.events.domain.ChangedTicketVO;
import com.inet.helpdesk.core.ticketmanager.model.events.domain.TicketEvent;
import com.inet.helpdesk.core.ticketmanager.model.events.domain.TicketEventListener;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepField;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.core.ticketmanager.model.tickets.additionalaccess.TicketAdditionalAccessValue;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.helpdesk.plugins.taskplanner.HelpDeskTaskPlannerServerPlugin;
import com.inet.helpdesk.plugins.taskplanner.server.HDPlaceholderUtils;
import com.inet.helpdesk.plugins.taskplanner.server.HDTaskPlannerDataListener;
import com.inet.helpdesk.plugins.taskplanner.server.TicketFilterChecker;
import com.inet.helpdesk.plugins.taskplanner.server.placeholder.PlaceholderProvider;
import com.inet.helpdesk.plugins.ticketprocess.server.api.TicketProcessManager;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.TicketProcess;
import com.inet.http.servlet.ClientLocale;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.util.StringFunctions;
import com.inet.notification.Notification;
import com.inet.notification.NotificationManager;
import com.inet.permissions.AccessDeniedException;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.plugin.ServerPluginManager;
import com.inet.shared.utils.FrequencyCounter;
import com.inet.taskplanner.server.api.TaskDefinition;
import com.inet.taskplanner.server.api.TaskExecution;
import com.inet.taskplanner.server.api.TaskPlanner;
import com.inet.taskplanner.server.api.trigger.Trigger;
import com.inet.taskplanner.server.api.trigger.TriggerDefinition;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountScope;
import com.inet.usersandgroups.api.user.UserManager;
import java.awt.Font;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class StatusChangeTrigger
implements Trigger,
TicketEventListener {
    private static final ConfigValue<String> DEFAULT_TICKET_FONT_NAME_VALUE = new ConfigValue(HDConfigKeys.DEFAULT_TICKET_FONT_NAME);
    private static final ConfigValue<Integer> DEFAULT_TICKET_FONT_SIZE_VALUE = new ConfigValue(HDConfigKeys.DEFAULT_TICKET_FONT_SIZE);
    private final String whenToTrigger;
    private final Set<Integer> processingTickets = Collections.synchronizedSet(new HashSet());
    private final List<Integer> statusFilter;
    private final TicketFilterChecker filterChecker;
    private final String fieldToWatch;
    private GUID taskID;
    protected Trigger.TriggerAction triggerAction;
    private final Set<Integer> ticketsAboutToCheck = Collections.synchronizedSet(new HashSet());
    private final Map<Integer, FrequencyCounter> ticketsTriggeredWhen = new HashMap<Integer, FrequencyCounter>();
    private final Map<Integer, FrequencyCounter> ticketsOnCooldown = new HashMap<Integer, FrequencyCounter>();

    public StatusChangeTrigger(TriggerDefinition definition, List<Integer> statusFilter, GUID taskID) {
        this.whenToTrigger = definition.getProperties().getOrDefault("PROPERTY_WHEN_TO_TRIGGER", "WHEN_TO_TRIGGER_ON_STATUS_CHANGE");
        this.fieldToWatch = definition.getProperties().getOrDefault("PROPERTY_FIELD_VALUE_TO_WATCH", "");
        this.filterChecker = new TicketFilterChecker(definition.getProperties());
        this.statusFilter = statusFilter;
        this.taskID = taskID;
    }

    public void activate(GUID taskGUID, Trigger.TriggerAction triggerAction) {
        this.triggerAction = triggerAction;
        this.registerListener();
    }

    protected void registerListener() {
        HDTaskPlannerDataListener.addListener(this);
    }

    public void deactivate() {
        this.triggerAction = null;
        this.unregisterListener();
    }

    protected void unregisterListener() {
        HDTaskPlannerDataListener.removeListener(this);
    }

    public void ticketsChanged(List<ChangedTicketVO> list) {
        list.forEach(t -> {
            List<Integer> ticketIdAsList = Collections.singletonList(t.getTicketID());
            Set reaStepIDs = t.getReaStepIDs();
            if (reaStepIDs != null) {
                Integer reaStepId = reaStepIDs.stream().max(Integer::compareTo).orElse(null);
                if (reaStepId != null) {
                    int reaStepInt = reaStepId;
                    try {
                        ReaStepVO reaStep = TicketManager.getReader().getReaStep(reaStepInt);
                        MutableReaStepData data = reaStep != null ? reaStep.getReaStepDataCopy() : null;
                        ReaStepTextVO reaStepText = TicketManager.getReader().getReaStepText(reaStepInt);
                        String text = reaStepText != null ? reaStepText.getText() : "";
                        ActionVO action = reaStep != null ? (ActionVO)ActionManager.getInstance().get(reaStep.getActionID()) : null;
                        boolean isHtml = reaStepText != null ? reaStepText.hasHtmlContent() : false;
                        this.ticketsChanged(ticketIdAsList, action, reaStep, reaStepText, data, text, isHtml);
                    }
                    catch (AccessDeniedException e) {
                        this.ticketsAboutToCheck.removeAll(ticketIdAsList);
                        return;
                    }
                } else {
                    this.ticketsChanged(ticketIdAsList, null, null, null, null, "", false);
                }
            } else {
                this.ticketsChanged(ticketIdAsList, null, null, null, null, "", false);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ticketsChanged(List<Integer> list, final ActionVO action, final ReaStepVO reaStep, final ReaStepTextVO reaStepText, final MutableReaStepData reaStepData, final String text, final boolean isHtml) {
        this.ticketsAboutToCheck.removeAll(list);
        final Trigger.TriggerAction a = this.triggerAction;
        if (a != null) {
            Map<Integer, FrequencyCounter> map = this.ticketsTriggeredWhen;
            synchronized (map) {
                list = list.stream().filter(t -> this.isInFilter((Integer)t)).filter(tId -> this.ticketsOnCooldown.get(tId) == null || this.ticketsOnCooldown.get(tId).getCount() < 1).collect(Collectors.toList());
                final List filteredList = list.stream().filter(tId -> this.ticketsTriggeredWhen.get(tId) == null || this.ticketsTriggeredWhen.get(tId).getCount() < 10).collect(Collectors.toList());
                if (filteredList.size() == 0) {
                    if (list.size() > 0) {
                        TaskExecution taskExecution = this.getTaskExecutionFor(this.taskID);
                        String tickets = list.stream().map(Object::toString).collect(Collectors.joining(","));
                        String taskName = this.getTaskDefinitionFor(this.taskID).getName();
                        String title = HelpDeskTaskPlannerServerPlugin.MSG.getMsg("TriggeredTooOften.Title", new Object[]{taskName, tickets});
                        String message = HelpDeskTaskPlannerServerPlugin.MSG.getMsg("TriggeredTooOften.Message", new Object[]{taskName, tickets});
                        Notification notification = new Notification(title, message);
                        this.sendNotification(taskExecution, notification);
                        list.forEach(tId -> {
                            FrequencyCounter frequencyCounter = this.ticketsOnCooldown.getOrDefault(tId, new FrequencyCounter(5L, TimeUnit.MINUTES));
                            frequencyCounter.increment();
                            this.ticketsOnCooldown.put((Integer)tId, frequencyCounter);
                        });
                    }
                    return;
                }
                for (Integer ticketId : filteredList) {
                    FrequencyCounter frequencyCounter = this.ticketsTriggeredWhen.getOrDefault(ticketId, new FrequencyCounter(60L, TimeUnit.SECONDS));
                    frequencyCounter.increment();
                    this.ticketsTriggeredWhen.put(ticketId, frequencyCounter);
                }
                final GUID currentUser = UserManager.getInstance().getCurrentUserAccountID();
                final Timer t2 = new Timer("runTrigger");
                t2.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        try (UserAccountScope scope = UserAccountScope.create((GUID)currentUser);){
                            for (Integer ticketId : filteredList) {
                                TicketVO ticket;
                                try {
                                    ticket = TicketManager.getReader().getTicket(ticketId.intValue());
                                }
                                catch (AccessDeniedException e) {
                                    continue;
                                }
                                if (ticket == null || HDTaskPlannerDataListener.getRegisteredInstance().wasTicketCreatedByThisTask(ticketId, StatusChangeTrigger.this.taskID)) continue;
                                int status = ticket.getStatusID();
                                boolean includeTicket = false;
                                switch (StatusChangeTrigger.this.whenToTrigger) {
                                    case "WHEN_TO_TRIGGER_ALWAYS": {
                                        includeTicket = true;
                                        break;
                                    }
                                    case "WHEN_TO_TRIGGER_ON_STATUS_CHANGE": 
                                    case "WHEN_TO_TRIGGER_IF_STATUS_IS": {
                                        includeTicket = StatusChangeTrigger.this.statusFilter == null || StatusChangeTrigger.this.statusFilter.contains(status);
                                        break;
                                    }
                                    case "WHEN_TO_TRIGGER_ON_FIELD_CHANGE": 
                                    case "WHEN_TO_TRIGGER_ON_FIELD_CHANGE_ANY": 
                                    case "WHEN_TO_TRIGGER_ON_TICKET_ACTION": {
                                        includeTicket = true;
                                    }
                                }
                                if (!includeTicket) continue;
                                StatusChangeTrigger.this.processingTickets.add(ticketId);
                                Map<String, String> props = HDPlaceholderUtils.fillPlaceholderValuesFor(ticket);
                                List placeholderProviders = DynamicExtensionManager.getInstance().get(PlaceholderProvider.class);
                                if (action != null) {
                                    String plainText;
                                    Object htmlText;
                                    Long bis;
                                    props.put("action.name", action.getDisplayValue());
                                    props.put("action.id", action.getUniqueID());
                                    ProcessingTime processingTime = reaStepData != null ? (ProcessingTime)reaStepData.get((ReaStepField)ReaStepVO.FIELD_PROCESSING_TIME) : null;
                                    Long l = bis = processingTime != null ? Long.valueOf(processingTime.getEnd()) : null;
                                    if (bis != null) {
                                        String whenString = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.MEDIUM, FormatStyle.SHORT).withLocale(ClientLocale.getThreadLocale()).format(ZonedDateTime.ofInstant(new Date(bis).toInstant(), ZoneId.systemDefault()));
                                        props.put("action.when", whenString);
                                    }
                                    String displayName = reaStepData != null ? (String)reaStepData.get((ReaStepField)ReaStepVO.FIELD_USER_DISPLAY_NAME) : "";
                                    props.put("action.when.timestamp", String.valueOf(bis != null ? bis : ""));
                                    props.put("action.user", displayName);
                                    GUID userId = reaStep != null ? reaStep.getUserID() : null;
                                    props.put("action.user.id", userId != null ? userId.toString() : "");
                                    String description = reaStepData != null ? (String)reaStepData.get((ReaStepField)ReaStepVO.FIELD_DESC) : "";
                                    props.put("action.stepdescription", description != null ? description : "");
                                    if (isHtml) {
                                        htmlText = text;
                                        plainText = HtmlConverter.html2text((String)htmlText);
                                    } else {
                                        plainText = text;
                                        htmlText = HtmlConverter.text2html((String)plainText, (Font)StatusChangeTrigger.getDefaultFont());
                                    }
                                    if (htmlText != null && !((String)htmlText).toLowerCase().startsWith("<html>")) {
                                        htmlText = "<html>" + (String)htmlText + "</html>";
                                    }
                                    props.put("action.steptext", plainText);
                                    props.put("action.steptext.html", (String)htmlText);
                                    String sender = reaStepData != null ? (String)reaStepData.get((ReaStepField)ReaStepVO.FIELD_EMAIL_IN) : "";
                                    props.put("action.emailsender", sender != null ? sender : "");
                                    boolean isHtml_ = isHtml;
                                    Object text_ = isHtml_ ? htmlText : plainText;
                                    placeholderProviders.forEach(p -> p.getPlaceholderValuesFor(action, reaStep, reaStepText).entrySet().forEach(e -> props.put((String)e.getKey(), (String)e.getValue())));
                                } else {
                                    props.put("action.name", "");
                                    props.put("action.id", "");
                                    props.put("action.when", "");
                                    props.put("action.when.timestamp", "");
                                    props.put("action.user", "");
                                    props.put("action.stepdescription", "");
                                    props.put("action.steptext", "");
                                    props.put("action.steptext.html", "");
                                    props.put("action.emailsender", "");
                                    placeholderProviders.forEach(p -> p.getPlaceholderValuesFor(action, reaStep, reaStepText).entrySet().forEach(e -> props.put((String)e.getKey(), (String)e.getValue())));
                                }
                                String ticketIDProp = props.get("Ticket ID");
                                if (ticketIDProp != null) {
                                    props.put("Ticket ID", ticketIDProp.trim());
                                }
                                a.execute(props);
                            }
                        }
                        catch (Throwable t) {
                            HDLogger.error((Object)t);
                        }
                        t2.schedule(new TimerTask(){

                            @Override
                            public void run() {
                                StatusChangeTrigger.this.processingTickets.removeAll(filteredList);
                                t2.cancel();
                            }
                        }, 3000L);
                    }
                }, 1000L);
            }
        }
    }

    public static Font getDefaultFont() {
        String fontName = (String)DEFAULT_TICKET_FONT_NAME_VALUE.get();
        int fontSize = (Integer)DEFAULT_TICKET_FONT_SIZE_VALUE.get();
        if (StringFunctions.isEmpty((String)fontName)) {
            fontName = HDConfigKeys.DEFAULT_TICKET_FONT_NAME.getDefault();
        }
        if (fontSize <= 0) {
            fontSize = Integer.parseInt(HDConfigKeys.DEFAULT_TICKET_FONT_SIZE.getDefault());
        }
        return new Font(fontName, 0, fontSize);
    }

    private boolean isInFilter(Integer ticketId) {
        TicketVO ticket;
        if (HDTaskPlannerDataListener.getRegisteredInstance().wasTicketCreatedByThisTask(ticketId, this.taskID)) {
            return false;
        }
        UserAccount user = UserManager.getInstance().getCurrentUserAccount();
        if (user == null) {
            HDLogger.warn((Object)"TriggerTicketDataChangeListener: no current user - no ticket list");
            return false;
        }
        if (this.processingTickets.contains(ticketId)) {
            return false;
        }
        try {
            ticket = TicketManager.getReader().getTicket(ticketId.intValue());
        }
        catch (AccessDeniedException e) {
            return false;
        }
        return this.filterChecker.check(this.getServerValuesConnector(), ticket, user);
    }

    protected ServerValuesConnector getServerValuesConnector() {
        return (ServerValuesConnector)ServerPluginManager.getInstance().getSingleInstance(ServerValuesConnector.class);
    }

    protected TaskExecution getTaskExecutionFor(GUID taskID) {
        return TaskPlanner.getInstance().getTaskExecution(taskID);
    }

    protected TaskDefinition getTaskDefinitionFor(GUID taskID) {
        return TaskPlanner.getInstance().getTaskDefinition(taskID);
    }

    protected void sendNotification(TaskExecution taskExecution, Notification notification) {
        NotificationManager.getInstance().sendNotification(taskExecution.getOwnerId(), notification);
    }

    public void handleEvent(TicketEvent ticketEvent) {
        TaskExecution ex = TaskPlanner.getInstance().getTaskExecution(this.taskID);
        GUID ownerId = ex != null && ex.getOwnerId() != null ? ex.getOwnerId() : UserManager.getInstance().getCurrentUserAccountID();
        if (ownerId != null && !ownerId.equals((Object)UserManager.PRIVILEGED_ACCOUNT_ID) && !ownerId.equals((Object)UserManager.getInstance().getCurrentUserAccountID())) {
            try (UserAccountScope scope = UserAccountScope.create((GUID)ownerId);){
                this.handleEvent(ticketEvent);
                return;
            }
        }
        if (this.triggerAction == null) {
            return;
        }
        final List changedTickets = ticketEvent.getChangedTickets().stream().filter(vo -> {
            TicketVO oldTicketMaybeSlave;
            TicketVO newTicketMaybeSlave;
            TicketVO newTicketNoLongerASlave = newTicketMaybeSlave = vo.getNewTicket();
            if (newTicketMaybeSlave instanceof TicketVOSlaveForEnduser) {
                try {
                    newTicketNoLongerASlave = TicketManager.getReader().getTicket(newTicketMaybeSlave.getID());
                }
                catch (AccessDeniedException e) {
                    return false;
                }
            } else if (newTicketMaybeSlave == null) {
                return false;
            }
            TicketVO oldTicketNoLongerASlave = oldTicketMaybeSlave = vo.getOldTicket();
            if (oldTicketMaybeSlave instanceof TicketVOSlaveForEnduser) {
                try {
                    oldTicketNoLongerASlave = TicketManager.getReader().getTicket(oldTicketMaybeSlave.getID());
                }
                catch (AccessDeniedException e) {
                    return false;
                }
            }
            boolean isTriggerOnStatusChange = "WHEN_TO_TRIGGER_ON_STATUS_CHANGE".equals(this.whenToTrigger);
            boolean isTriggerOnStatusIs = "WHEN_TO_TRIGGER_IF_STATUS_IS".equals(this.whenToTrigger);
            boolean isTriggerOnFieldChange = "WHEN_TO_TRIGGER_ON_FIELD_CHANGE".equals(this.whenToTrigger);
            boolean isTriggerOnFieldChangeAny = "WHEN_TO_TRIGGER_ON_FIELD_CHANGE_ANY".equals(this.whenToTrigger);
            boolean isTriggerOnAny = "WHEN_TO_TRIGGER_ALWAYS".equals(this.whenToTrigger);
            if (oldTicketNoLongerASlave != null) {
                long newLastChanged;
                long oldLastChanged;
                if ((isTriggerOnAny || isTriggerOnStatusIs) && newTicketNoLongerASlave != null && (oldLastChanged = oldTicketNoLongerASlave.getLastChanged()) == (newLastChanged = newTicketNoLongerASlave.getLastChanged())) {
                    return false;
                }
                if (isTriggerOnStatusChange) {
                    return oldTicketNoLongerASlave.getStatusID() != newTicketNoLongerASlave.getStatusID();
                }
                if (isTriggerOnFieldChange) {
                    UserAccount user = UserManager.getInstance().getCurrentUserAccount();
                    boolean oldOneFitTheFilterAlready = this.filterChecker.check(this.getServerValuesConnector(), oldTicketNoLongerASlave, user);
                    return !oldOneFitTheFilterAlready;
                }
                if (isTriggerOnFieldChangeAny) {
                    String newkey;
                    String oldkey = this.getStringValueOf(this.fieldToWatch, oldTicketNoLongerASlave);
                    return !oldkey.equals(newkey = this.getStringValueOf(this.fieldToWatch, newTicketNoLongerASlave));
                }
                return true;
            }
            if (isTriggerOnFieldChangeAny && newTicketNoLongerASlave != null) {
                if (Tickets.FIELD_ADDITIONAL_ACCESS.getKey().equals(this.fieldToWatch)) {
                    TicketAdditionalAccessValue additionalAccess = (TicketAdditionalAccessValue)newTicketNoLongerASlave.getValue((TicketField)Tickets.FIELD_ADDITIONAL_ACCESS);
                    Set readAccess = additionalAccess.getReadAccess();
                    Set writeAccess = additionalAccess.getWriteAccess();
                    return readAccess.size() > 0 || writeAccess.size() > 0;
                }
                return !this.getStringValueOf(this.fieldToWatch, newTicketNoLongerASlave).isEmpty();
            }
            return true;
        }).filter(p -> !this.ticketsAboutToCheck.contains(p.getTicketID())).collect(Collectors.toList());
        if (changedTickets.size() > 0) {
            this.ticketsAboutToCheck.addAll(changedTickets.stream().map(c -> c.getTicketID()).collect(Collectors.toList()));
            final Timer t = new Timer("runTriggerCheck");
            TaskExecution execution = TaskPlanner.getInstance().getTaskExecution(this.taskID);
            final GUID currentUser = execution != null && execution.getOwnerId() != null ? execution.getOwnerId() : UserManager.getInstance().getCurrentUserAccountID();
            t.schedule(new TimerTask(){

                @Override
                public void run() {
                    try (UserAccountScope scope = UserAccountScope.create((GUID)currentUser);){
                        StatusChangeTrigger.this.ticketsChanged(changedTickets);
                        t.cancel();
                    }
                    catch (Exception exc) {
                        HDLogger.error((Object)exc);
                    }
                }
            }, 500L);
        }
    }

    @Nonnull
    String getStringValueOf(String fieldToWatch, TicketVO ticket) {
        switch (fieldToWatch) {
            case "FilterTypeCategory": {
                return "" + ticket.getCategoryID();
            }
            case "FilterTypeResource": {
                return String.valueOf(ticket.getResourceID());
            }
            case "FilterTypeProcessFilter": {
                if (!ServerPluginManager.getInstance().isPluginLoaded("ticketprocess")) {
                    return "";
                }
                TicketProcess processOfTicket = TicketProcessManager.getProcessOfTicket((TicketVO)ticket);
                return processOfTicket == null ? "" : String.valueOf(processOfTicket.getId());
            }
        }
        List fieldDefs = DynamicExtensionManager.getInstance().get(TicketFieldDefinition.class);
        Collections.sort(fieldDefs, Comparator.comparingInt(TicketFieldDefinition::getPriority));
        for (TicketFieldDefinition d : fieldDefs) {
            if (!d.getFieldKey().equals(fieldToWatch)) continue;
            TicketField ticketField = Tickets.getFieldByKey((String)d.getFieldKey());
            Object value = ticket.getValue(ticketField);
            return value == null ? "" : String.valueOf(value);
        }
        if (Tickets.FIELD_ADDITIONAL_ACCESS.getKey().equals(fieldToWatch)) {
            TicketAdditionalAccessValue additionalAccess = (TicketAdditionalAccessValue)ticket.getValue((TicketField)Tickets.FIELD_ADDITIONAL_ACCESS);
            Set readAccess = additionalAccess.getReadAccess();
            Set writeAccess = additionalAccess.getWriteAccess();
            ArrayList<String> accessAsReproducibleStringRepresentation = new ArrayList<String>();
            readAccess.stream().map(h -> h.toString()).sorted().forEach(s -> accessAsReproducibleStringRepresentation.add((String)s));
            accessAsReproducibleStringRepresentation.add("----");
            writeAccess.stream().map(h -> h.toString()).sorted().forEach(s -> accessAsReproducibleStringRepresentation.add((String)s));
            return new Json().toJson(accessAsReproducibleStringRepresentation);
        }
        return "";
    }
}

