/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.taskplanner.server.trigger.emailreceived;

import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.core.ticketmanager.extension.TicketActionExtension;
import com.inet.helpdesk.core.ticketmanager.extension.TicketActionExtensionFactory;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationChangedTicket;
import com.inet.helpdesk.plugins.taskplanner.HelpDeskTaskPlannerServerPlugin;
import com.inet.helpdesk.plugins.taskplanner.server.FilterFieldValues;
import com.inet.helpdesk.plugins.taskplanner.server.FilterableFieldListGenerator;
import com.inet.helpdesk.plugins.taskplanner.server.HDPlaceholders;
import com.inet.helpdesk.plugins.taskplanner.server.trigger.emailreceived.EmailReceivedTrigger;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.http.servlet.ClientLocale;
import com.inet.id.GUID;
import com.inet.taskplanner.server.api.common.AbstractDefinition;
import com.inet.taskplanner.server.api.common.SummaryInfo;
import com.inet.taskplanner.server.api.error.ValidationException;
import com.inet.taskplanner.server.api.field.Field;
import com.inet.taskplanner.server.api.field.TextField;
import com.inet.taskplanner.server.api.trigger.Trigger;
import com.inet.taskplanner.server.api.trigger.TriggerDefinition;
import com.inet.taskplanner.server.api.trigger.TriggerFactory;
import com.inet.taskplanner.server.api.trigger.TriggerInfo;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class EmailReceivedTriggerFactory
extends TriggerFactory<Trigger>
implements TicketActionExtensionFactory {
    public static final String EXTENSION_NAME = "trigger.helpdesk.emailreceived";
    static final String SUBJECT_FILTER = "SUBJECT_FILTER";
    static final String SENDER_FILTER = "RECIPIENT_FILTER";
    static final String RECIPIENT_FILTER = "EMAIL_IN_RECIPIENT_FILTER";
    static final String BODY_FILTER = "BODY_FILTER";
    private FilterFieldValues fieldValues;

    public EmailReceivedTriggerFactory() {
        super(EXTENSION_NAME);
    }

    public TriggerInfo getInformation(@Nullable GUID guid) {
        this.fieldValues = new FilterFieldValues(this.getFieldListGenerator());
        URL iconURL = ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/plugins/taskplanner/structure/receivemail_32.png");
        ArrayList<Object> fields = new ArrayList<Object>();
        TextField subject = new TextField(SUBJECT_FILTER, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("EmailReceivedTrigger.subjectmustcontain", new Object[0]));
        subject.setPlaceholder(HelpDeskTaskPlannerServerPlugin.MSG.getMsg("EmailReceivedTrigger.subjectmustcontain.placeholder", new Object[0]));
        fields.add(subject);
        TextField sender = new TextField(SENDER_FILTER, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("EmailReceivedTrigger.sendermustcontain", new Object[0]));
        sender.setPlaceholder(HelpDeskTaskPlannerServerPlugin.MSG.getMsg("EmailReceivedTrigger.sendermustcontain.placeholder", new Object[0]));
        fields.add(sender);
        TextField recip = new TextField(RECIPIENT_FILTER, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("EmailReceivedTrigger.emailinmustcontain", new Object[0]));
        recip.setPlaceholder(HelpDeskTaskPlannerServerPlugin.MSG.getMsg("EmailReceivedTrigger.emailinmustcontain.placeholder", new Object[0]));
        fields.add(recip);
        TextField body = new TextField(BODY_FILTER, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("EmailReceivedTrigger.bodytextmustcontain", new Object[0]));
        body.setPlaceholder(HelpDeskTaskPlannerServerPlugin.MSG.getMsg("EmailReceivedTrigger.bodytextmustcontain.placeholder", new Object[0]));
        fields.add(body);
        ArrayList<Field> filterFieldChooser = this.fieldValues.getFilterFieldChooser();
        fields.addAll(filterFieldChooser);
        List<String> placeholderKeys = HDPlaceholders.getHDPlaceholderKeys();
        return new TriggerInfo(EXTENSION_NAME, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("EmailReceivedTrigger.name", new Object[0]), HelpDeskTaskPlannerServerPlugin.MSG.getMsg("EmailReceivedTrigger.desc", new Object[0]), iconURL, "taskplanner.trigger.email-received", fields, placeholderKeys);
    }

    public FilterableFieldListGenerator getFieldListGenerator() {
        return FilterableFieldListGenerator.getInstance();
    }

    public void validate(@Nonnull TriggerDefinition definition, GUID guid) throws ValidationException {
        this.fieldValues.validate((AbstractDefinition)definition, guid);
    }

    public SummaryInfo getSummary(@Nonnull TriggerDefinition definition) {
        String bodyFilter;
        String recipFilter;
        String senderFilter;
        Object baseMsg = HelpDeskTaskPlannerServerPlugin.MSG.getMsg("EmailReceivedTrigger.summary", new Object[0]);
        Map props = definition.getProperties();
        String subjectFilter = props.getOrDefault(SUBJECT_FILTER, "");
        if (subjectFilter != null && !subjectFilter.isBlank()) {
            baseMsg = (String)baseMsg + ", " + HelpDeskTaskPlannerServerPlugin.MSG.getMsg("EmailReceivedTrigger.summary.subject", new Object[]{subjectFilter});
        }
        if ((senderFilter = props.getOrDefault(SENDER_FILTER, "")) != null && !senderFilter.isBlank()) {
            baseMsg = (String)baseMsg + ", " + HelpDeskTaskPlannerServerPlugin.MSG.getMsg("EmailReceivedTrigger.summary.sender", new Object[]{senderFilter});
        }
        if ((recipFilter = props.getOrDefault(RECIPIENT_FILTER, "")) != null && !recipFilter.isBlank()) {
            baseMsg = (String)baseMsg + ", " + HelpDeskTaskPlannerServerPlugin.MSG.getMsg("EmailReceivedTrigger.summary.recipient", new Object[]{recipFilter});
        }
        if ((bodyFilter = props.getOrDefault(BODY_FILTER, "")) != null && !bodyFilter.isBlank()) {
            baseMsg = (String)baseMsg + ", " + HelpDeskTaskPlannerServerPlugin.MSG.getMsg("EmailReceivedTrigger.summary.bodytext", new Object[]{bodyFilter});
        }
        return this.fieldValues.getSummary((AbstractDefinition)definition, this.currentLanguage(), (String)baseMsg, "EmailReceivedTrigger.summary", "TicketCreatedSeriesSummaryInfoLabel");
    }

    private String currentLanguage() {
        return ClientLocale.getThreadLocale().toLanguageTag();
    }

    protected Trigger createInstanceFrom(@Nonnull TriggerDefinition definition, @Nullable GUID taskID) {
        definition.setProperty("PROPERTY_WHEN_TO_TRIGGER", "WHEN_TO_TRIGGER_ON_TICKET_ACTION");
        return new EmailReceivedTrigger(definition, taskID);
    }

    public boolean isAvailable() {
        UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
        return currentUserAccount != null && HDUsersAndGroups.isSupporter((UserAccount)currentUserAccount);
    }

    public Map<String, String> updateValues(@Nonnull TriggerDefinition definition, GUID taskID) {
        FilterableFieldListGenerator.updateResourceDisplayValueIfNecessary((AbstractDefinition)definition);
        return super.updateValues((AbstractDefinition)definition, taskID);
    }

    @Nullable
    public TicketActionExtension createIfApplicable(@Nonnull OperationChangedTicket operationChangedTicket, @Nonnull ActionVO actionVO, @Nonnull ExtensionArguments extensionArguments, @Nonnull MutableReaStepData mutableReaStepData) {
        return null;
    }
}

