/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.taskplanner.server.job.escalation;

import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.plugins.taskplanner.HelpDeskTaskPlannerServerPlugin;
import com.inet.helpdesk.plugins.taskplanner.server.FilterableFieldListGenerator;
import com.inet.helpdesk.plugins.taskplanner.server.job.escalation.SetResourceJob;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.taskplanner.server.api.DataEntry;
import com.inet.taskplanner.server.api.common.SummaryEntry;
import com.inet.taskplanner.server.api.error.ValidationException;
import com.inet.taskplanner.server.api.field.SelectInputField;
import com.inet.taskplanner.server.api.field.TextField;
import com.inet.taskplanner.server.api.job.ConditionInfo;
import com.inet.taskplanner.server.api.job.JobDefinition;
import com.inet.taskplanner.server.api.job.JobFactory;
import com.inet.taskplanner.server.api.job.JobInfo;
import com.inet.taskplanner.server.api.job.JobSummaryInfo;
import com.inet.taskplanner.server.api.result.ResultFlavor;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SetResourceJobFactory
extends JobFactory<SetResourceJob> {
    public static final String EXTENSION_NAME = "taskplanner.helpdesk.escalation";

    public SetResourceJobFactory() {
        super(EXTENSION_NAME);
    }

    public List<ResultFlavor> getResultFlavors(JobDefinition definition) {
        return new ArrayList<ResultFlavor>();
    }

    protected void validateCondition(@Nonnull JobDefinition definition) throws ValidationException {
    }

    public JobInfo getInformation(@Nullable GUID taskID) {
        URL iconURL = ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/plugins/taskplanner/structure/escalation_32.png");
        String helpKey = "taskplanner.job.escalation";
        String name = HelpDeskTaskPlannerServerPlugin.MSG.getMsg("EscalationName", new Object[0]);
        String description = HelpDeskTaskPlannerServerPlugin.MSG.getMsg("EscalationDesc", new Object[0]);
        ArrayList<Object> fields = new ArrayList<Object>();
        TextField textField = new TextField("Ticket ID", HelpDeskTaskPlannerServerPlugin.MSG.getMsg("TicketIDLabel", new Object[0]));
        textField.setValue("{Ticket ID}");
        fields.add(textField);
        FilterableFieldListGenerator generator = this.getFieldListGenerator();
        SelectInputField f = new SelectInputField("Resource.noCustomEntry", Tickets.FIELD_RESOURCE_GUID.getLabel(), 1);
        ArrayList<DataEntry> resourceKeys = generator.getResourceKeys(false, false);
        if (resourceKeys != null && resourceKeys.size() > 0) {
            f.setValue(resourceKeys.get(0).getValue());
            f.setDisplay(resourceKeys.get(0).getLabel());
        }
        fields.add(f);
        return new JobInfo(this.getExtensionName(), name, description, iconURL, helpKey, new ConditionInfo(new ArrayList()), fields, new ArrayList());
    }

    protected void validate(@Nonnull JobDefinition definition, @Nullable GUID taskID) throws ValidationException {
        Map props = definition.getProperties();
        if (props.get("Ticket ID") == null || ((String)props.get("Ticket ID")).isEmpty()) {
            throw new ValidationException(new String[]{HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ErrorNoTicketEmpty", new Object[0])});
        }
    }

    public JobSummaryInfo getSummary(@Nonnull JobDefinition definition) {
        ArrayList<SummaryEntry> summary = new ArrayList<SummaryEntry>();
        String resId = definition.getProperty("Resource.noCustomEntry");
        String valueString = this.getFieldListGenerator().getResourceKeys(false, false).stream().filter(k -> resId != null && resId.equals(k.getValue())).findFirst().map(DataEntry::getLabel).orElse("");
        summary.add(new SummaryEntry("", HelpDeskTaskPlannerServerPlugin.MSG.getMsg("EscalationSummaryLabel", new Object[]{valueString})));
        return new JobSummaryInfo(summary, new ArrayList());
    }

    protected SetResourceJob createInstanceFrom(@Nonnull JobDefinition definition, @Nullable GUID taskID) {
        return new SetResourceJob(definition, taskID);
    }

    protected FilterableFieldListGenerator getFieldListGenerator() {
        return FilterableFieldListGenerator.getInstance();
    }

    public boolean isAvailable() {
        UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
        return currentUserAccount != null && HDUsersAndGroups.isSupporter((UserAccount)currentUserAccount);
    }
}

