/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.taskplanner.server.action.setticketfield;

import com.inet.error.ErrorCode;
import com.inet.field.SelectOption;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepField;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.WithAdditionalReaStepData;
import com.inet.helpdesk.core.ticketmanager.timeline.TimelineDataHandler;
import com.inet.helpdesk.core.ticketmanager.ui.model.SelectEditDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.helpdesk.plugins.taskplanner.HelpDeskTaskPlannerServerPlugin;
import com.inet.helpdesk.plugins.taskplanner.server.HDTaskPlannerUtils;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.permissions.AccessDeniedException;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.plugin.ServerPluginManager;
import com.inet.taskplanner.server.api.TaskExecution;
import com.inet.taskplanner.server.api.TaskPlanner;
import com.inet.taskplanner.server.api.action.ResultAction;
import com.inet.taskplanner.server.api.error.TaskExecutionException;
import com.inet.taskplanner.server.api.error.TaskPlannerCodes;
import com.inet.taskplanner.server.api.job.JobResultContainer;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.user.UserAccountScope;
import com.inet.usersandgroups.api.user.UserManager;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;

public class SetTicketFieldAction
extends ResultAction {
    private final List<Integer> ticketIds;
    private final String field;
    private final String value;
    private final GUID taskID;
    private final boolean applyWorkingHours;

    public SetTicketFieldAction(List<Integer> ticketIds, String field, String value, @Nullable GUID taskID) {
        this(ticketIds, field, value, taskID, false);
    }

    public SetTicketFieldAction(List<Integer> ticketIds, String field, String value, @Nullable GUID taskID, boolean applyWorkingHours) {
        switch (field) {
            case "FilterTypeCategory": {
                field = Tickets.FIELD_CATEGORY_ID.getKey();
                break;
            }
            case "FilterTypeResource": {
                field = Tickets.FIELD_RESOURCE_GUID.getKey();
            }
        }
        this.ticketIds = ticketIds;
        this.field = field;
        this.value = value;
        this.taskID = taskID;
        this.applyWorkingHours = applyWorkingHours;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void handle(List<JobResultContainer> results) throws TaskExecutionException {
        this.setProgress(0);
        toThrow = new ArrayList<Exception>();
        scope = null;
        try {
            ex = this.getTaskExecution();
            v0 = ownerId = ex != null ? ex.getOwnerId() : UserManager.getInstance().getCurrentUserAccountID();
            if (ownerId != null && !ownerId.equals((Object)UserManager.PRIVILEGED_ACCOUNT_ID) && !ownerId.equals((Object)UserManager.getInstance().getCurrentUserAccountID())) {
                scope = UserAccountScope.create((GUID)ownerId);
            }
            for (Integer ticketId : this.ticketIds) {
                block38: {
                    block39: {
                        addReaStepData = WithAdditionalReaStepData.create((ReaStepField)ReaStepVO.FIELD_TASKPLANNER_TASKID, (Object)this.taskID);
                        tm = TicketManager.getManipulator();
                        ticketData = new MutableTicketData();
                        data = new HashMap<String, Object>();
                        if (!this.field.equals(Tickets.FIELD_RESOURCE_GUID.getKey())) ** GOTO lbl50
                        try {
                            ticket = TicketManager.getReader().getTicket(ticketId.intValue());
                        }
                        catch (AccessDeniedException e) {
                            HDLogger.warn((Object)("Access denied when reading ticket " + ticketId + " in SetTicketFieldAction: " + e.getMessage()));
                            if (addReaStepData == null) continue;
                            addReaStepData.close();
                            continue;
                        }
                        if (ticket == null) {
                            throw new IllegalArgumentException(HelpDeskTaskPlannerServerPlugin.MSG.getMsg("SetTicketFieldAction.TicketNotFound", new Object[0]));
                        }
                        resIDString = ((SelectOption)new Json().fromJson(this.value, SelectOption.class)).getValue();
                        resourceUUID = null;
                        if (resIDString.matches("\\d+")) {
                            resID = Integer.parseInt(resIDString);
                            resourceUUID = HDUsersAndGroups.getResourceGroupUUID((int)resID);
                        } else {
                            resources = UserGroupManager.getRecoveryEnabledInstance().getGroups(HDUsersAndGroups.RESOURCE);
                            resourceUUID = resources.stream().filter((Predicate<UserGroupInfo>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$handle$0(java.lang.String com.inet.usersandgroups.api.groups.UserGroupInfo ), (Lcom/inet/usersandgroups/api/groups/UserGroupInfo;)Z)((String)resIDString)).findFirst().map((Function<UserGroupInfo, GUID>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$handle$1(com.inet.usersandgroups.api.groups.UserGroupInfo ), (Lcom/inet/usersandgroups/api/groups/UserGroupInfo;)Lcom/inet/id/GUID;)()).orElse(null);
                        }
                        if (!ticket.isDispatched()) break block38;
                        if (resourceUUID != null && !resourceUUID.equals((Object)ticket.getResourceID()) || resourceUUID == null && ticket.getResourceID() != null) {
                            tm.escalateTicket(ticketId.intValue(), resourceUUID, ReaStepTextVO.empty(), false);
                        }
                        if (addReaStepData == null) break block39;
                        addReaStepData.close();
                    }
                    return;
                }
                try {
                    block41: {
                        data.put(this.field, new Json().toJson((Object)new SelectOption(resourceUUID.toString(), "")));
                        break block41;
lbl50:
                        // 1 sources

                        if (this.field.equals(Tickets.FIELD_OWNER_GUID.getKey()) && SystemPermissionChecker.checkAccess((Permission)UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER)) {
                            data.put(this.field, new Json().toJson((Object)new SelectOption(this.value, "")));
                        } else {
                            data.put(this.field, this.value);
                        }
                    }
                    fieldDefs = DynamicExtensionManager.getInstance().get(TicketFieldDefinition.class);
                    for (TicketFieldDefinition d : fieldDefs) {
                        if (!d.getKey().equals(this.field) || d.getEditDefinition() == null) continue;
                        if (d.getEditDefinition().getDisplayType().equals("datevalue") || d.getEditDefinition().getDisplayType().equals("dateonlyvalue")) {
                            if (this.value == null || this.value.trim().isEmpty()) {
                                data.put(this.field, this.value);
                            } else {
                                timePeriodInMinutes = Long.valueOf(this.value);
                                try {
                                    ticket = TicketManager.getReader().getTicket(ticketId.intValue());
                                }
                                catch (AccessDeniedException e) {
                                    HDLogger.warn((Object)("Access denied when reading ticket " + ticketId + " in SetTicketFieldAction: " + e.getMessage()));
                                    continue;
                                }
                                resourceID = ticket.getResourceID();
                                if (this.applyWorkingHours && this.field.equals(Tickets.FIELD_DEADLINE.getKey()) && resourceID != null) {
                                    resID = HDUsersAndGroups.getResourceId((GUID)resourceID);
                                    timelineHandler = (TimelineDataHandler)ServerPluginManager.getInstance().getSingleInstance(TimelineDataHandler.class);
                                    newDate = timelineHandler.calcMomentUsingResourceWorkingHours(new Date(), (double)timePeriodInMinutes.longValue() / 60.0, Integer.valueOf(resID));
                                    data.put(this.field, "" + newDate.getTime());
                                } else {
                                    data.put(this.field, "" + (System.currentTimeMillis() + timePeriodInMinutes * 60L * 1000L));
                                }
                            }
                        } else if (d.getEditDefinition().getDisplayType().equals("select")) {
                            chosenValue = ((SelectOption)new Json().fromJson(this.value, SelectOption.class)).getValue();
                            if (chosenValue == null) {
                                chosenValue = "";
                            }
                            editDefinition = (SelectEditDefinition)d.getEditDefinition();
                            selectOptions = editDefinition.getSelectOptions(null, "", 10000, 0);
                            chosenValue_ = chosenValue;
                            chosenOption = selectOptions.getOptions().stream().filter((Predicate<SelectOption>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$handle$2(java.lang.String com.inet.field.SelectOption ), (Lcom/inet/field/SelectOption;)Z)((String)chosenValue_)).findFirst().map((Function<SelectOption, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getValue(), (Lcom/inet/field/SelectOption;)Ljava/lang/String;)());
                            if (chosenOption.isEmpty()) {
                                optionMatchingDisplayString = selectOptions.getOptions().stream().filter((Predicate<SelectOption>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$handle$3(java.lang.String com.inet.field.SelectOption ), (Lcom/inet/field/SelectOption;)Z)((String)chosenValue_)).findFirst().map((Function<SelectOption, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getValue(), (Lcom/inet/field/SelectOption;)Ljava/lang/String;)());
                                optionMatchingDisplayString.ifPresent((Consumer<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$handle$4(java.util.Map java.lang.String ), (Ljava/lang/String;)V)((SetTicketFieldAction)this, data));
                            }
                        }
                        d.getEditDefinition().updateTicketData(ticketData, data);
                    }
                    if (ticketData.isEmpty()) continue;
                    tm.updateTicketData(ticketId.intValue(), ticketData);
                    continue;
                    {
                        catch (Throwable var9_11) {
                            throw var9_11;
                        }
                    }
                    finally {
                        if (addReaStepData == null) continue;
                        addReaStepData.close();
                    }
                }
                catch (Exception e) {
                    toThrow.add((Exception)new TaskExecutionException((Throwable)e, (ErrorCode)TaskPlannerCodes.GenericExecutionError));
                }
            }
            if (toThrow.size() > 0) {
                throw HDTaskPlannerUtils.combinedException(toThrow);
            }
            this.setProgress(100);
        }
        finally {
            if (scope != null) {
                scope.close();
            }
        }
    }

    protected String getValue() {
        return this.value;
    }

    @Nullable
    protected TaskExecution getTaskExecution() {
        return TaskPlanner.getInstance().getTaskExecution(this.taskID);
    }

    private /* synthetic */ void lambda$handle$4(Map data, String s) {
        data.put(this.field, new Json().toJson((Object)new SelectOption(s, "")));
    }

    private static /* synthetic */ boolean lambda$handle$3(String chosenValue_, SelectOption o) {
        return chosenValue_.equals(o.getLabel());
    }

    private static /* synthetic */ boolean lambda$handle$2(String chosenValue_, SelectOption o) {
        return chosenValue_.equals(o.getValue());
    }

    private static /* synthetic */ GUID lambda$handle$1(UserGroupInfo u) {
        return u.getID();
    }

    private static /* synthetic */ boolean lambda$handle$0(String resIDString, UserGroupInfo r) {
        return resIDString.equals(r.getDisplayName());
    }
}

