/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.taskplanner.server.action;

import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.core.ticketmanager.TicketEmailSenderInformation;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.argcontainers.ProcessingTime;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepField;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.WithAdditionalReaStepData;
import com.inet.helpdesk.core.ticketmanager.timeline.TimelineDataHandler;
import com.inet.helpdesk.plugins.taskplanner.server.HDPlaceholderUtils;
import com.inet.helpdesk.plugins.taskplanner.server.HDTaskPlannerUtils;
import com.inet.helpdesk.shared.TicketEmailSenderInformationCreator;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.permissions.AccessDeniedException;
import com.inet.plugin.ServerPluginManager;
import com.inet.taskplanner.server.api.TaskExecution;
import com.inet.taskplanner.server.api.TaskPlanner;
import com.inet.taskplanner.server.api.action.PlaceholderResolver;
import com.inet.taskplanner.server.api.action.ResultAction;
import com.inet.taskplanner.server.api.action.ResultActionDefinition;
import com.inet.taskplanner.server.api.error.TaskExecutionException;
import com.inet.taskplanner.server.api.job.JobResultContainer;
import com.inet.taskplanner.server.api.result.ResultFlavor;
import com.inet.taskplanner.server.api.result.TextResult;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountScope;
import com.inet.usersandgroups.api.user.UserManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ApplyActionToTicketAction
extends ResultAction {
    private final Map<String, String> props;
    private GUID taskID;

    public ApplyActionToTicketAction(ResultActionDefinition definition, GUID taskID) {
        this.props = definition.getProperties();
        this.taskID = taskID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handle(List<JobResultContainer> results) throws TaskExecutionException {
        this.setProgress(0);
        try (WithAdditionalReaStepData addReaStepData = WithAdditionalReaStepData.create((ReaStepField)ReaStepVO.FIELD_TASKPLANNER_TASKID, (Object)this.taskID);
             UserAccountScope scope = null;){
            GUID ownerId;
            TaskExecution ex = this.getTaskExecution();
            GUID gUID = ownerId = ex != null ? ex.getOwnerId() : UserManager.getInstance().getCurrentUserAccountID();
            if (ownerId != null && !ownerId.equals((Object)UserManager.PRIVILEGED_ACCOUNT_ID) && !ownerId.equals((Object)UserManager.getInstance().getCurrentUserAccountID())) {
                scope = UserAccountScope.create((GUID)ownerId);
            }
            String actionToApply = this.props.get("PROPERTY_ACTION_TO_APPLY");
            Integer actionId = Integer.valueOf(actionToApply);
            List<Integer> ticketIds = HDPlaceholderUtils.getTicketIds(this.props.get("Ticket ID"));
            ArrayList<Exception> toThrow = new ArrayList<Exception>();
            for (Integer ticketId : ticketIds) {
                try {
                    String timeSpentValue;
                    ActionVO replacement;
                    TicketVO ticket;
                    try {
                        ticket = TicketManager.getReader().getTicket(ticketId.intValue());
                    }
                    catch (AccessDeniedException e) {
                        HDLogger.warn((Object)("Access denied when reading ticket " + ticketId + " in ApplyActionToTicketAction: " + e.getMessage()));
                        continue;
                    }
                    if (ticket == null) {
                        HDLogger.warn((Object)("ticket " + ticketId + " is null in ApplyAction TP."));
                        continue;
                    }
                    if (actionId == 947474) {
                        TicketManager.getManipulator().changeTicketStatusToUnread(ticketId.intValue());
                        continue;
                    }
                    if (actionId == 947475) {
                        TicketManager.getManipulator().changeTicketStatusToRead(ticketId.intValue());
                        continue;
                    }
                    ActionVO actionVO = (ActionVO)ActionManager.getInstance().get(actionId.intValue());
                    if (actionVO == null) continue;
                    GUID resourceID = ticket.getResourceID();
                    @Nonnull MutableReaStepData mutableData = new MutableReaStepData();
                    String message = this.props.getOrDefault("prop_message", "");
                    if (message == null) {
                        message = "";
                    }
                    PlaceholderResolver msg = new PlaceholderResolver(message);
                    for (int i = 0; i < results.size(); ++i) {
                        JobResultContainer container = results.get(i);
                        HashMap<String, String> metaData = container.getMetaProperties();
                        HashMap<String, String> hashMap = metaData = metaData == null ? new HashMap<String, String>() : new HashMap(metaData);
                        if (message.contains("[jobresult]")) {
                            for (TextResult result : container.getResults(ResultFlavor.TEXT)) {
                                try {
                                    String text = result.getText();
                                    metaData.put("jobresult", text);
                                }
                                catch (IOException e) {
                                    throw new TaskExecutionException((Throwable)e);
                                }
                            }
                            if (metaData.get("jobresult") == null) {
                                metaData.put("jobresult", "");
                            }
                        }
                        msg.addMetaData(metaData);
                    }
                    message = msg.resolve();
                    boolean treatAsHtml = message != null && message.toLowerCase().contains("<html>");
                    @Nonnull ReaStepTextVO text = ReaStepTextVO.of((String)message, (boolean)true);
                    @Nullable ExtensionArguments extArgs = ExtensionArguments.create();
                    if (actionId == 10 || actionId == -3 || actionVO.getStatusID() == 260 || actionVO.getStatusID() == 150) {
                        String dateValueToSet = this.props.getOrDefault("dateValueToSet", "").trim();
                        Long timePeriodInMinutes = Long.valueOf(dateValueToSet);
                        ExtensionArguments.ExtArg extargDate = ExtensionArguments.EXTARG_APPOINTMENT;
                        if (Boolean.valueOf(this.props.get("workingHours")).booleanValue()) {
                            if (resourceID != null) {
                                int resID = HDUsersAndGroups.getResourceId((GUID)resourceID);
                                TimelineDataHandler timelineHandler = (TimelineDataHandler)ServerPluginManager.getInstance().getSingleInstance(TimelineDataHandler.class);
                                Date newDate = timelineHandler.calcMomentUsingResourceWorkingHours(new Date(), (double)timePeriodInMinutes.longValue() / 60.0, Integer.valueOf(resID));
                                extArgs.put(extargDate, (Object)newDate.getTime());
                            }
                        } else {
                            extArgs.put(extargDate, (Object)(System.currentTimeMillis() + timePeriodInMinutes * 60L * 1000L));
                        }
                    } else if (actionId == -7 || actionVO.getStatusID() == 211) {
                        String receiver = this.props.get("prop_receiver");
                        String subject = this.props.get("prop_subject");
                        TaskExecution execution = this.getTaskExecution();
                        GUID currentUser = execution != null && execution.getOwnerId() != null ? execution.getOwnerId() : UserManager.getInstance().getCurrentUserAccountID();
                        UserAccount userAccount = UserManager.getInstance().getUserAccount(currentUser);
                        if (userAccount == null) {
                            toThrow.add((Exception)new TaskExecutionException((Throwable)new IllegalStateException("User null")));
                            continue;
                        }
                        List senderInformation = TicketEmailSenderInformationCreator.getSenderInformation((UserAccount)userAccount, (GUID)resourceID, (Integer)ticket.getCategoryID(), (String)ticket.getEmailEingang());
                        if (senderInformation.size() > 0) {
                            mutableData.put((ReaStepField)ReaStepVO.FIELD_EMAIL_IN, (Object)((TicketEmailSenderInformation)senderInformation.get(0)).getEmail());
                        }
                        mutableData.put((ReaStepField)ReaStepVO.FIELD_EMAIL_AN, (Object)receiver);
                        if (subject != null && !subject.isBlank()) {
                            mutableData.put((ReaStepField)ReaStepVO.FIELD_DESC, (Object)subject);
                        }
                        extArgs.put(ExtensionArguments.EXTARG_APPLY_ANSWER, (Object)ExtensionArguments.AdditionalEmailAction.SEND_ONLY);
                    }
                    List allPossibleActionsForTicket = TicketManager.getTicketActionChecker().getAllPossibleActionsForTicket(ticketId.intValue());
                    if (!allPossibleActionsForTicket.contains(actionVO) && (replacement = (ActionVO)allPossibleActionsForTicket.stream().filter(a -> a.getId() == actionId.intValue()).findFirst().orElse(null)) != null) {
                        actionVO = replacement;
                    }
                    if ((timeSpentValue = this.props.get("timeSpent")) != null && !timeSpentValue.trim().isEmpty() && actionId != -12 && actionId != -22) {
                        PlaceholderResolver timeSpentResolver = new PlaceholderResolver(timeSpentValue);
                        for (int i = 0; i < results.size(); ++i) {
                            JobResultContainer container = results.get(i);
                            HashMap metaData = container.getMetaProperties();
                            metaData = metaData == null ? new HashMap() : new HashMap(metaData);
                            timeSpentResolver.addMetaData(metaData);
                        }
                        String resolvedTimeSpentValue = timeSpentResolver.resolve();
                        try {
                            int timeSpentMinutes = Integer.valueOf(resolvedTimeSpentValue.trim());
                            if (timeSpentMinutes > 0) {
                                mutableData.put((ReaStepField)ReaStepVO.FIELD_PROCESSING_TIME, (Object)ProcessingTime.ofEffort((int)timeSpentMinutes));
                            } else {
                                mutableData.put((ReaStepField)ReaStepVO.FIELD_PROCESSING_TIME, (Object)ProcessingTime.ofEffort((int)0));
                            }
                        }
                        catch (NumberFormatException e) {
                            HDLogger.error((Object)e);
                        }
                    }
                    TicketManager.getManipulator().applyAction(ticketId.intValue(), mutableData, text, actionVO, extArgs);
                }
                catch (Exception exc) {
                    toThrow.add(exc);
                }
            }
            if (toThrow.size() > 0) {
                throw HDTaskPlannerUtils.combinedException(toThrow);
            }
        }
        this.setProgress(100);
    }

    protected TaskExecution getTaskExecution() {
        return TaskPlanner.getInstance().getTaskExecution(this.taskID);
    }
}

