/*
 * Decompiled with CFR 0.152.
 */
package com.inet.shared.statistics.server;

import com.inet.cache.CacheStrategy;
import com.inet.cache.HardDiskStoreMap;
import com.inet.cache.shutdown.ShutdownFinalizer;
import com.inet.cache.shutdown.ShutdownManager;
import com.inet.lib.io.FastBufferedInputStream;
import com.inet.lib.io.FastBufferedOutputStream;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonException;
import com.inet.lib.util.IOFunctions;
import com.inet.persistence.Persistence;
import com.inet.persistence.PersistenceEntry;
import com.inet.shared.statistics.StatisticsPlugin;
import com.inet.shared.statistics.api.StatisticsMemory;
import com.inet.thread.timer.DefaultTimer;
import com.inet.thread.timer.DefaultTimerTask;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class b {
    private DefaultTimerTask ae;
    private List<StatisticsMemory<?>> af = new ArrayList();
    private List<String> ag = new ArrayList<String>();
    private boolean ah = false;
    private int ai;
    private ShutdownFinalizer aj = () -> this.a(true);
    private HardDiskStoreMap<String, Serializable> ak = new HardDiskStoreMap(CacheStrategy.Normal);

    public b() {
        this(300000);
    }

    public b(int n) {
        this.ai = n;
    }

    public void a(StatisticsMemory<?> statisticsMemory) {
        if (this.ah) {
            throw new IllegalStateException("No StatisticsMemory can be added after the backup was loaded!");
        }
        if (this.ag.contains(statisticsMemory.getKey())) {
            throw new IllegalArgumentException("Memory '" + statisticsMemory.getKey() + "' is already present and cannot be added again!");
        }
        this.ag.add(statisticsMemory.getKey());
        this.af.add(statisticsMemory);
    }

    private synchronized void a(boolean bl) {
        PersistenceEntry persistenceEntry = Persistence.getInstance().resolve(".cr_statisticsPluginBackup.zip");
        try (OutputStream outputStream = persistenceEntry.getOutputStream();
             ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);){
            zipOutputStream.setLevel(0);
            for (StatisticsMemory<?> statisticsMemory : this.af) {
                zipOutputStream.putNextEntry(new ZipEntry(statisticsMemory.getKey() + ".json"));
                try {
                    Object obj = this.a(statisticsMemory, bl);
                    FastBufferedOutputStream fastBufferedOutputStream = new FastBufferedOutputStream((OutputStream)zipOutputStream);
                    new Json().toJson(obj, (OutputStream)fastBufferedOutputStream);
                    fastBufferedOutputStream.flush();
                }
                catch (Throwable throwable) {
                    StatisticsPlugin.LOGGER.error((Object)("Cannot store statistical data for " + statisticsMemory.getKey()));
                    StatisticsPlugin.LOGGER.error(throwable);
                }
            }
        }
        catch (IOException iOException) {
            StatisticsPlugin.LOGGER.error((Throwable)iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends Serializable> T a(StatisticsMemory<T> statisticsMemory, boolean bl) {
        HardDiskStoreMap<String, Serializable> hardDiskStoreMap = this.ak;
        synchronized (hardDiskStoreMap) {
            Serializable serializable = (Serializable)this.ak.get((Object)statisticsMemory.getKey());
            T t = statisticsMemory.update(statisticsMemory.cast(serializable), bl, true);
            if (!bl) {
                this.ak.put((Object)statisticsMemory.getKey(), t);
            }
            return t;
        }
    }

    public synchronized void i() {
        this.ah = true;
        this.ag = null;
        Persistence persistence = Persistence.getInstance();
        PersistenceEntry persistenceEntry = persistence.resolve(".cr_statisticsPluginBackup.zip");
        boolean bl = false;
        if (persistenceEntry.exists()) {
            try (InputStream inputStream = persistenceEntry.getInputStream();
                 ZipInputStream zipInputStream = new ZipInputStream(inputStream);){
                ZipEntry zipEntry;
                while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                    if ("backupData.json".equals(zipEntry.getName())) {
                        this.j();
                        return;
                    }
                    if (!zipEntry.getName().endsWith(".json")) continue;
                    String string = zipEntry.getName().substring(0, zipEntry.getName().length() - 5);
                    Optional<StatisticsMemory> optional = this.af.stream().filter(statisticsMemory -> statisticsMemory.getKey().equals(string)).findFirst();
                    if (!optional.isPresent()) continue;
                    StatisticsMemory statisticsMemory2 = optional.get();
                    bl |= this.a(zipInputStream, statisticsMemory2);
                }
            }
            catch (Throwable throwable) {
                StatisticsPlugin.LOGGER.error(throwable);
                bl = true;
            }
        }
        if (bl) {
            StatisticsPlugin.LOGGER.error((Object)"Statistics backup file seems to be corrupted, see previous exception.");
            persistenceEntry.deleteValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends Serializable> boolean a(InputStream inputStream, StatisticsMemory<T> statisticsMemory) {
        try {
            String string = IOFunctions.readString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            try {
                T t = statisticsMemory.fromJson(string);
                statisticsMemory.loadFromBackup(statisticsMemory.cast(t));
                HardDiskStoreMap<String, Serializable> hardDiskStoreMap = this.ak;
                synchronized (hardDiskStoreMap) {
                    this.ak.put((Object)statisticsMemory.getKey(), t);
                }
            }
            catch (JsonException jsonException) {
                StatisticsPlugin.LOGGER.info((Object)("Statistical data found for '" + statisticsMemory.getKey() + "' is incompatible."));
            }
        }
        catch (IOException iOException) {
            StatisticsPlugin.LOGGER.error((Throwable)iOException);
            return true;
        }
        return false;
    }

    private synchronized void j() {
        Persistence persistence = Persistence.getInstance();
        PersistenceEntry persistenceEntry = persistence.resolve(".cr_statisticsPlugin.backup");
        PersistenceEntry persistenceEntry2 = persistence.resolve(".cr_statisticsPluginBackup.zip");
        boolean bl = false;
        try (InputStream inputStream = persistenceEntry2.getInputStream();){
            Cloneable cloneable;
            InputStream inputStream2;
            InputStream inputStream3 = null;
            if (inputStream != null) {
                inputStream2 = new ZipInputStream(inputStream);
                while ((cloneable = ((ZipInputStream)inputStream2).getNextEntry()) != null) {
                    if (!"backupData.json".equals(cloneable.getName())) continue;
                    inputStream3 = inputStream2;
                    break;
                }
            } else {
                inputStream3 = persistenceEntry.getInputStream();
            }
            if (inputStream3 == null) {
                return;
            }
            try {
                inputStream2 = new ObjectInputStream((InputStream)new FastBufferedInputStream(inputStream3));
                try {
                    cloneable = (HashMap)((ObjectInputStream)inputStream2).readObject();
                    for (StatisticsMemory<?> statisticsMemory : this.af) {
                        this.a((HashMap<String, String>)cloneable, statisticsMemory);
                    }
                }
                finally {
                    ((ObjectInputStream)inputStream2).close();
                }
            }
            catch (IOException | ClassNotFoundException exception) {
                StatisticsPlugin.LOGGER.error((Throwable)exception);
                bl = true;
            }
        }
        catch (Throwable throwable) {
            StatisticsPlugin.LOGGER.error(throwable);
            bl = true;
        }
        if (bl) {
            StatisticsPlugin.LOGGER.error((Object)"Statistics backup file seems to be corrupted, see previous exception.");
            persistenceEntry2.deleteValue();
        }
        persistenceEntry.deleteValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends Serializable> void a(HashMap<String, String> hashMap, StatisticsMemory<T> statisticsMemory) {
        String string = hashMap.get(statisticsMemory.getKey());
        if (string != null) {
            try {
                T t = statisticsMemory.fromJson(string);
                statisticsMemory.loadFromBackup(statisticsMemory.cast(t));
                HardDiskStoreMap<String, Serializable> hardDiskStoreMap = this.ak;
                synchronized (hardDiskStoreMap) {
                    this.ak.put((Object)statisticsMemory.getKey(), t);
                }
            }
            catch (JsonException jsonException) {
                StatisticsPlugin.LOGGER.info((Object)("Statistical data found for '" + statisticsMemory.getKey() + "' is incompatible."));
            }
        } else {
            StatisticsPlugin.LOGGER.info((Object)("No statistical data found for '" + statisticsMemory.getKey() + "' - no data prior to the server start is available."));
        }
    }

    public void start() {
        this.ae = new DefaultTimerTask(){

            public void runImpl() throws Throwable {
                b.this.a(false);
            }
        };
        DefaultTimer.getInstance().schedule(this.ae, (long)this.ai, (long)this.ai);
        for (StatisticsMemory<?> statisticsMemory : this.af) {
            statisticsMemory.start();
        }
        ShutdownManager.add((ShutdownFinalizer)this.aj);
    }

    public void stop() {
        if (this.ae == null) {
            return;
        }
        try {
            ShutdownManager.remove((ShutdownFinalizer)this.aj);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        for (StatisticsMemory<?> statisticsMemory : this.af) {
            statisticsMemory.stop();
        }
        this.a(true);
        this.ae.cancel();
    }

    public <T extends Serializable> T b(StatisticsMemory<T> statisticsMemory) {
        return statisticsMemory.update(statisticsMemory.cast(this.ak.get((Object)statisticsMemory.getKey())), false, false);
    }
}

