/*
 * Decompiled with CFR 0.152.
 */
package com.inet.shared.statistics.eventlog;

import com.inet.annotations.InternalApi;
import com.inet.http.servlet.SessionStore;
import com.inet.lib.util.StringFunctions;
import com.inet.persistence.Persistence;
import com.inet.plugin.NamedExtension;
import com.inet.plugin.ServerPluginManager;
import com.inet.shared.statistics.StatisticsPlugin;
import com.inet.shared.statistics.api.table.TableData;
import com.inet.shared.statistics.eventlog.EventLogColumnDescription;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;

@InternalApi
public abstract class EventLogDescription
implements NamedExtension {
    private List<EventLogColumnDescription> O;
    public static final String COL_DATA = "statistics.entry.eventlog.data";
    protected static final boolean USERMANAGER_LOADED = ServerPluginManager.getInstance().isPluginLoaded("usersandgroupsmanager");

    @Nonnull
    public String getTitle() {
        return this.getExtensionName();
    }

    @Nonnull
    protected List<EventLogColumnDescription> getColumns() {
        ArrayList<EventLogColumnDescription> arrayList = new ArrayList<EventLogColumnDescription>();
        arrayList.add(new EventLogColumnDescription(StatisticsPlugin.MSG, "statistics.entry.eventlog.date", 0, 0));
        arrayList.add(new EventLogColumnDescription(StatisticsPlugin.MSG, "statistics.entry.eventlog.account", 258, 2){

            @Override
            public TableData.TableCell<?> getCellValue(String[] line, @Nonnull Map<String, Object> states) {
                String string = line[1];
                String string2 = null;
                if (!StringFunctions.isEmpty((String)string) && USERMANAGER_LOADED && Objects.requireNonNullElse((Boolean)states.get("hasUserManagerAccess"), Boolean.FALSE).booleanValue()) {
                    string2 = SessionStore.getRootURL() + "usersandgroups/user/" + string;
                }
                return new TableData.TableCell<String>(string, line[2], string2);
            }
        });
        arrayList.add(new EventLogColumnDescription(StatisticsPlugin.MSG, "statistics.entry.eventlog.event", 257, 3));
        arrayList.add(new EventLogColumnDescription(StatisticsPlugin.MSG, "statistics.entry.eventlog.msg", 2, 4));
        arrayList.add(new EventLogColumnDescription(StatisticsPlugin.MSG, COL_DATA, 3, 5));
        return arrayList;
    }

    @Nonnull
    public List<EventLogColumnDescription> getAllColumns() {
        if (this.O == null) {
            List<EventLogColumnDescription> list = this.getColumns();
            if (!Persistence.isFilePersistence()) {
                int n = 6;
                for (EventLogColumnDescription eventLogColumnDescription : list) {
                    n = Math.max(n, eventLogColumnDescription.getSourceColumnIdx() + 1);
                }
                list.add(new EventLogColumnDescription(StatisticsPlugin.MSG, "statistics.entry.eventlog.node", 258, n));
            }
            this.O = Collections.unmodifiableList(list);
        }
        return this.O;
    }
}

