/*
 * Decompiled with CFR 0.152.
 */
package com.inet.shared.statistics.api.table;

import com.inet.annotations.JsonData;
import com.inet.lib.i18n.DisplayableKey;
import java.util.ArrayList;

@JsonData
public class TableData {
    private ArrayList<TableCell<?>[]> rows = new ArrayList();
    private TableHeader[] header;
    private TableSort sort;

    public TableData(TableHeader[] header) {
        this.header = header;
    }

    public void addRow(TableCell<?>[] row) {
        this.rows.add(row);
    }

    public void setSort(TableSort sort) {
        this.sort = sort;
    }

    @JsonData
    public static class TableHeader {
        private String key;
        private final String displayName;
        private final ColumnType type;

        public TableHeader(ColumnType type, String displayName) {
            this.type = type;
            this.displayName = displayName;
        }

        public TableHeader(ColumnType type, String key, String displayName) {
            this.type = type;
            this.key = key;
            this.displayName = displayName;
        }
    }

    @JsonData
    public static class TableSort {
        private final String key;
        private String order = "asc";

        public TableSort(String key) {
            this.key = key;
        }

        public TableSort(String key, boolean descendingOrder) {
            this.key = key;
            this.order = "desc";
        }
    }

    @JsonData
    public static class TableCell<T extends Comparable<T>>
    implements DisplayableKey<T> {
        private final T key;
        private String displayName;
        private String link;

        public TableCell(T key) {
            this(key, null);
        }

        public TableCell(T key, String displayName) {
            this(key, displayName, null);
        }

        public TableCell(T key, String displayName, String link) {
            this.key = key;
            this.displayName = displayName;
            this.link = link;
        }

        public T getKey() {
            return this.key;
        }

        public String getDisplayName() {
            return this.displayName != null ? this.displayName : String.valueOf(this.key);
        }
    }

    @JsonData
    public static enum ColumnType {
        string,
        number,
        details;

    }
}

