/*
 * Decompiled with CFR 0.152.
 */
package com.inet.shared.statistics.server.entries.jobs;

import com.inet.http.servlet.ClientLocale;
import com.inet.http.servlet.ClientTimezone;
import com.inet.id.GUID;
import com.inet.shared.statistics.StatisticsPlugin;
import com.inet.shared.statistics.api.table.StatisticsTable;
import com.inet.shared.statistics.api.table.TableData;
import com.inet.shared.statistics.server.entries.jobs.b;
import com.inet.shared.statistics.server.entries.jobs.d;
import com.inet.thread.job.JobInfo;
import com.inet.thread.job.ManageableJobState;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

public class c
extends StatisticsTable {
    private HashMap<Locale, DateFormat> aA = new HashMap();
    private d f;
    private HashMap<b.a, Long> aB = new HashMap<b.a, Long>(){
        {
            this.put(b.a.as, Long.MAX_VALUE);
            this.put(b.a.at, TimeUnit.DAYS.toMillis(1L));
            this.put(b.a.au, TimeUnit.DAYS.toMillis(3L));
            this.put(b.a.av, TimeUnit.DAYS.toMillis(7L));
            this.put(b.a.aw, TimeUnit.DAYS.toMillis(14L));
            this.put(b.a.ax, TimeUnit.DAYS.toMillis(30L));
            this.put(b.a.ay, TimeUnit.DAYS.toMillis(90L));
        }
    };

    public c(d d2) {
        this.f = d2;
    }

    @Override
    public String getTitle() {
        return StatisticsPlugin.MSG.getMsg("statistics.entry.jobs.table.title", new Object[0]);
    }

    @Nonnull
    public String getExtensionName() {
        return "jobs_table";
    }

    @Override
    public TableData getData(Map<String, String> filterSettings) {
        ArrayList arrayList = (ArrayList)this.f.getUpdatedValue();
        TableData.TableHeader[] tableHeaderArray = new TableData.TableHeader[]{new TableData.TableHeader(TableData.ColumnType.string, "jobs.job", StatisticsPlugin.MSG.getMsg("statistics.entry.jobs.table.job", new Object[0])), new TableData.TableHeader(TableData.ColumnType.number, "jobs.state", StatisticsPlugin.MSG.getMsg("statistics.entry.jobs.table.state", new Object[0])), new TableData.TableHeader(TableData.ColumnType.string, "jobs.user", StatisticsPlugin.MSG.getMsg("statistics.entry.jobs.table.user", new Object[0])), new TableData.TableHeader(TableData.ColumnType.number, "jobs.added", StatisticsPlugin.MSG.getMsg("statistics.entry.jobs.table.added", new Object[0])), new TableData.TableHeader(TableData.ColumnType.number, "jobs.uptime", StatisticsPlugin.MSG.getMsg("statistics.entry.jobs.table.uptime", new Object[0])), new TableData.TableHeader(TableData.ColumnType.details, StatisticsPlugin.MSG.getMsg("statistics.entry.jobs.table.details", new Object[0]))};
        UserManager userManager = UserManager.getInstance();
        GUID gUID = null;
        try {
            gUID = GUID.valueOf((String)filterSettings.get("jobs.id"));
            if (Objects.requireNonNull(gUID).equals((Object)UsersAndGroups.GROUPID_ALLUSERS)) {
                gUID = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean bl = gUID != null;
        b.a a2 = b.a.as;
        try {
            String string = filterSettings.get("jobs.exectime");
            if (string != null) {
                a2 = b.a.valueOf(string);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        long l = System.currentTimeMillis();
        TableData tableData = new TableData(tableHeaderArray);
        for (JobInfo jobInfo : arrayList) {
            UserAccount userAccount;
            if (l - Objects.requireNonNull(this.aB.get((Object)a2)) > jobInfo.getSubmitDate()) continue;
            TableData.TableCell[] tableCellArray = new TableData.TableCell[tableHeaderArray.length];
            String string = null;
            GUID gUID2 = jobInfo.getUserId();
            if (gUID2 != null && (userAccount = userManager.getUserAccount(gUID2)) != null) {
                string = userAccount.getDisplayName();
            }
            if (string == null) {
                string = jobInfo.getUserName();
            }
            if (string == null) {
                string = StatisticsPlugin.MSG.getMsg("statistics.entry.jobs.table.user.unknown", new Object[0]);
            }
            if (bl && gUID2 != null && !Objects.requireNonNull(gUID).toString().equals(gUID2.toString())) continue;
            tableCellArray[0] = new TableData.TableCell<String>(jobInfo.getName());
            tableCellArray[1] = new TableData.TableCell<Integer>(jobInfo.getState().ordinal() * 10000 + jobInfo.getProgress(), this.a(jobInfo.getState(), jobInfo.getProgress()));
            tableCellArray[2] = new TableData.TableCell<String>(string);
            tableCellArray[3] = new TableData.TableCell<Long>(jobInfo.getSubmitDate(), this.a(jobInfo.getSubmitDate()));
            tableCellArray[4] = new TableData.TableCell<Long>(jobInfo.getElapsedExecutionTime(), this.b(jobInfo.getElapsedExecutionTime()));
            tableCellArray[5] = new TableData.TableCell<String>(this.a(jobInfo));
            tableData.addRow(tableCellArray);
        }
        tableData.setSort(new TableData.TableSort("jobs.added", true));
        return tableData;
    }

    private String a(JobInfo jobInfo) {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(StatisticsPlugin.MSG.getMsg("statistics.entry.jobs.details.memory", new Object[0])).append(": ");
        stringBuilder.append(com.inet.shared.statistics.server.entries.memory.d.a(jobInfo.getMemorySize())).append(" (").append(com.inet.shared.statistics.server.entries.memory.d.a(jobInfo.getSwapSize())).append(")");
        stringBuilder.append("\n");
        stringBuilder.append(StatisticsPlugin.MSG.getMsg("statistics.entry.jobs.details.objecthandles", new Object[0])).append(": ");
        stringBuilder.append(jobInfo.getObjectHandles());
        stringBuilder.append("\n");
        if (jobInfo.getClientaddress() != null) {
            stringBuilder.append(StatisticsPlugin.MSG.getMsg("statistics.entry.jobs.details.clientadress", new Object[0])).append(": ");
            stringBuilder.append(jobInfo.getClientaddress());
            stringBuilder.append("\n");
        }
        if ((string = jobInfo.getFailureTrace()) != null) {
            stringBuilder.append(StatisticsPlugin.MSG.getMsg("statistics.entry.jobs.details.stacktraces", new Object[0])).append(": ");
            string = string.replace("\t", "    ");
            string = string.replace("\n", "\n    ");
            string = string.replace(" ", "\u00a0");
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    private String a(ManageableJobState manageableJobState, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(StatisticsPlugin.MSG.getMsg("statistics.entry.jobs.table.state." + manageableJobState.toString(), new Object[0]));
        if (n != 100 && !manageableJobState.equals((Object)ManageableJobState.FINISHED)) {
            stringBuilder.append(", ").append(n).append("%");
        }
        return stringBuilder.toString();
    }

    private String a(long l) {
        DateFormat dateFormat = this.aA.get(ClientLocale.getThreadLocale());
        if (dateFormat == null) {
            dateFormat = DateFormat.getDateTimeInstance(2, 3, ClientLocale.getThreadLocale());
            this.aA.put(ClientLocale.getThreadLocale(), dateFormat);
        }
        dateFormat.setTimeZone(ClientTimezone.getTimeZone());
        return dateFormat.format(l);
    }

    public String b(long l) {
        long l2 = TimeUnit.MILLISECONDS.toHours(l);
        long l3 = TimeUnit.MILLISECONDS.toMinutes(l);
        long l4 = TimeUnit.MILLISECONDS.toSeconds(l);
        long l5 = TimeUnit.MILLISECONDS.toMillis(l);
        StringBuilder stringBuilder = new StringBuilder();
        if (l2 > 0L) {
            stringBuilder.append(l2).append("h ");
        }
        if (l3 > 0L) {
            stringBuilder.append(l3 - TimeUnit.HOURS.toMinutes(l2)).append("min ");
        }
        if (l4 > 0L) {
            stringBuilder.append(l4 - TimeUnit.MINUTES.toSeconds(l3)).append(".");
            stringBuilder.append(l5 - TimeUnit.SECONDS.toMillis(l4)).append("s ");
        } else if (l5 > 0L) {
            stringBuilder.append(l5 - TimeUnit.SECONDS.toMillis(l4)).append("ms ");
        }
        return stringBuilder.toString();
    }
}

