/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.statistics.reports;

import com.inet.annotations.JsonData;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonException;
import com.inet.report.Engine;
import com.inet.report.EngineStatistics;
import com.inet.report.Fields;
import com.inet.report.PromptField;
import com.inet.report.ReportException;
import com.inet.report.event.EngineFinishEvent;
import com.inet.report.event.EngineFinishListener;
import com.inet.report.event.EngineStartedListener;
import com.inet.report.statistics.CRStatisticsPlugin;
import com.inet.report.statistics.reports.Entry;
import com.inet.shared.statistics.api.StatisticsMemory;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;

@JsonData
public class RenderedReportsMemory
extends StatisticsMemory<ArrayList<Entry>>
implements EngineFinishListener,
EngineStartedListener,
Serializable {
    private static final long MEMORIZED_MAX_INTERVAL = 8640000000L;
    private ArrayList<Entry> data = new ArrayList();
    private static final int MAX_TOTAL = 20000;

    public void loadFromBackup(ArrayList<Entry> value) {
        for (Entry entry : value) {
            if (entry.getPages() == 0) {
                entry.setPages(-1);
                entry.setRenderTime(System.currentTimeMillis() - entry.getRenderDate());
            }
            if (entry.getExportFormat() != null) continue;
            entry.setExportFormat("<unknown>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Entry> update(ArrayList<Entry> cachedValue, boolean shutdown, boolean clearNewData) {
        cachedValue = cachedValue == null ? new ArrayList() : new ArrayList<Entry>(cachedValue);
        ArrayList<Entry> arrayList = this.data;
        synchronized (arrayList) {
            cachedValue.removeIf(en -> this.data.stream().anyMatch(de -> de.getId() == en.getId()));
            cachedValue.addAll(this.data);
            if (clearNewData) {
                this.data.removeIf(en -> {
                    boolean bl;
                    boolean bl2 = bl = en.getPages() != 0;
                    if (bl) {
                        en.setId(0);
                    }
                    return bl;
                });
                long l = System.currentTimeMillis() - 8640000000L;
                cachedValue.removeIf(en -> en.getRenderDate() < l);
                this.data.removeIf(en -> en.getRenderDate() < l);
                while (cachedValue.size() > 20000) {
                    cachedValue.remove(0);
                }
                CRStatisticsPlugin.LOGGER.debug((Object)String.format("RenderedReports: %d items", cachedValue.size()));
            }
        }
        return cachedValue;
    }

    public ArrayList<Entry> fromJson(String json) {
        try {
            return (ArrayList)new Json().fromJson(json, Json.NULL_MAP, ArrayList.class, new Type[]{Entry.class});
        }
        catch (JsonException jsonException) {
            return ((RenderedReportsMemory)new Json().fromJson((String)json, RenderedReportsMemory.class)).data;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void engineStarted(Engine engine, URL url) {
        EngineStatistics engineStatistics = engine.getStatistics();
        Properties properties = engine.getUserProperties();
        if (properties == null) {
            return;
        }
        UserAccount userAccount = UserManager.getInstance().getCurrentUserAccount();
        String string = userAccount != null ? userAccount.getDisplayName() : "Anonymous";
        String string2 = properties.getProperty("export_fmt");
        if (string2 == null) {
            CRStatisticsPlugin.LOGGER.info((Object)("Skipping engine without report-format: " + String.valueOf(url)));
            return;
        }
        String string3 = url.toString();
        String string4 = null;
        Object object = engine.getMetaProperties().get("adhocReportName");
        Object object2 = engine.getMetaProperties().get("adhocReportURL");
        if (object != null && object2 != null) {
            string4 = String.valueOf(object);
            string3 = String.valueOf(object2);
        }
        Entry entry = new Entry(string4, string3, System.identityHashCode(engine), engineStatistics.getRenderStartDate(), string, string2);
        Fields fields = this.data;
        synchronized (fields) {
            this.data.add(entry);
        }
        try {
            fields = engine.getFields();
            for (int i = 0; i < fields.getPromptFieldsCount(); ++i) {
                PromptField promptField = fields.getPromptField(i);
                String string5 = promptField.getPromptValueAsFormula();
                if (string5 == null) {
                    string5 = "<null>";
                }
                entry.getPrompts().put(promptField.getName(), string5);
            }
        }
        catch (ReportException reportException) {
            CRStatisticsPlugin.LOGGER.error((Throwable)reportException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void engineFinish(EngineFinishEvent event) {
        Engine engine = event.getEngine();
        int n = System.identityHashCode(engine);
        ArrayList<Entry> arrayList = this.data;
        synchronized (arrayList) {
            for (int i = this.data.size() - 1; i >= 0; --i) {
                Entry entry = this.data.get(i);
                if (entry.getId() != n) continue;
                try {
                    entry.setPages(engine.getDocumentPageCount());
                    entry.setRenderTime(engine.getStatistics().getTotalSystemTime() / 1000000L);
                }
                catch (ReportException reportException) {
                    entry.setPages(-1);
                    entry.setRenderTime(System.currentTimeMillis() - entry.getRenderDate());
                    CRStatisticsPlugin.LOGGER.error((Throwable)reportException);
                }
                break;
            }
        }
    }

    public String getKey() {
        return "RenderedReports";
    }
}

