Imports System
Imports System.IO
Imports System.Net
Imports System.Globalization


Namespace com.inet.proxy

    Public Class ClientProxy
        Inherits System.Web.UI.Page

        Dim ccRequest As HttpWebRequest

        Dim AppContext As String
        Dim BackendContext As String

        Dim Request As HttpRequest
        Dim Response As HttpResponse

        Public Overrides Sub ProcessRequest(ByVal context As HttpContext)
            Try
                'workaround for .NET 4 which not accept a & character in prompt values else you add <httpRuntime requestValidationMode="2.0" /> to web.config which is not valid for .NET 2.
                context.Request.QueryString.ToString()
            Catch ex As HttpRequestValidationException
            End Try

            ' Add this line if you want call the follow lines from the aspx file.
            ' But  it is faster to call it directly here.
            ' MyBase.ProcessRequest(context)

            Request = context.Request
            Response = context.Response

            ' Connect to application and init some variables, must end with a slash
            Connect("http://localhost:9000/")

            ' Connect and add or override addition report parameters for example
            ' Dim params As New StringDictionary
            ' params.Add("report", "startpage/start.rpt")
            ' Connect("http://localhost:9000/", params)

            ' start the report generation
            Run()
        End Sub


        ' Init some variables
        ' backendServer is the address of a server
        ' for example "http://localhost:9000/"
        Public Sub Connect(ByVal backendServer As String)
            Connect(backendServer, Nothing)
        End Sub


        ' Init some variables
        ' backendServer is the address of a server
        ' for example "http://localhost:9000/"
        ' params are additional parameters
        Public Sub Connect(ByVal backendServer As String, ByVal params As StringDictionary)
            '*** put the needed server enviroment
            Dim url As String
            If Request.ServerVariables("HTTPS").ToLower = "off" Then
                url = "http"
            Else
                url = "https"
            End If
            url = url & "://" & Request.ServerVariables("HTTP_HOST")

            AppContext = CStr(Request.ServerVariables("URL"))
            BackendContext = New Uri(backendServer).AbsolutePath
            If BackendContext.EndsWith("/") Then
                BackendContext = BackendContext.SubString(0, BackendContext.Length - 1)
            End If

            If AppContext = Request.ServerVariables("PATH_INFO") Then
                url = Request.ServerVariables("PATH_INFO") & "/"
                If Request.Url.Query.Length > 1 Then
                    url = url + Request.Url.Query
                End If
                Response.Redirect(url)
                Response.End()
            End If

            Dim Context As String
            Context = Uri.EscapeUriString(mid(CStr(Request.ServerVariables("PATH_INFO")), len(AppContext) + 2)) + "?"
            Context = Context.Replace( "#", "%23" )

            Dim isNoData As Boolean
            isNoData = "GET".Equals(Request.HttpMethod) Or "HEAD".Equals(Request.HttpMethod)

            Dim query As String
            query = Request.Url.Query
            If query.Length > 1 Then
                ' Add the additional parameters before the other parameters 
                If isNoData And Not params Is Nothing And Not isProgramCode(Context) Then
                    Dim param As DictionaryEntry
                    For Each param In params
                        Context = Context + "&" + Server.URLEncode(param.Key) + "=" & Server.URLEncode(param.Value & "")
                    Next
                End If
                Context = Context + "&" + query.Substring(1)
            End If
            ' Add the additional parameters after the other parameters 
            If isNoData And Not params Is Nothing And Not isProgramCode(Context) Then
                Dim param As DictionaryEntry
                For Each param In params
                    Context = Context + "&" + Server.URLEncode(param.Key) + "=" & Server.URLEncode(param.Value & "")
                Next
            End If

            ccRequest = CType(WebRequest.Create(backendServer + Context), HttpWebRequest)
            ccRequest.Method = Request.HttpMethod
            ccRequest.AllowAutoRedirect = False
            ccRequest.AllowWriteStreamBuffering = False
            ccRequest.Timeout = 60000 ' 60 seconds timeout

            ' With KeepAlive and HTTP 1.1 a frequently count of POST request results in WebException with status RequestCanceled
            ccRequest.KeepAlive = False
            ccRequest.ProtocolVersion = HttpVersion.Version10

            Dim contentLength As Integer
            contentLength = Request.ContentLength
            If contentLength = 0 Then
                Dim contentLengthStr As String = Request.Headers.Item("Content-Length")
                If contentLengthStr Is Nothing Then
                    contentLength = -1
                End If
            End If
            ccRequest.ContentType = Request.ContentType

            SetRequestHeaders()

            If Not isNoData Then
                If contentLength < 0 Or Not params Is Nothing Then
                    ccRequest.SendChunked = True
                Else
                    ccRequest.ContentLength = ContentLength
                End If

                Dim output As Stream
                Try
                    output = ccRequest.GetRequestStream()
                Catch ex As WebException
                    handleWebException(ex)
                End Try
                ' Add the additional parameters before the other parameters
                If Not params Is Nothing And Not isProgramCode(Context) Then
                    Dim encoding As System.Text.Encoding = System.Text.Encoding.GetEncoding("ISO8859-1")
                    Dim param As DictionaryEntry
                    For Each param In params
                        Dim bytes As Byte()
                        bytes = encoding.getBytes(Server.URLEncode(param.Key))
                        output.write(bytes, 0, bytes.Length)
                        ' Character =
                        output.writeByte(61)
                        bytes = encoding.getBytes(Server.URLEncode(param.Value & ""))
                        output.write(bytes, 0, bytes.Length)
                        ' Character &
                        output.writeByte(38)
                    Next
                End If
                copyStream(Request.InputStream, output)
                ' Add the additional parameters after the other parameters
                If Not params Is Nothing And Not isProgramCode(Context) Then
                    Dim encoding As System.Text.Encoding = System.Text.Encoding.GetEncoding("ISO8859-1")
                    Dim param As DictionaryEntry
                    For Each param In params
                        ' Character &
                        output.writeByte(38)
                        Dim bytes As Byte()
                        bytes = encoding.getBytes(Server.URLEncode(param.Key))
                        output.write(bytes, 0, bytes.Length)
                        ' Character =
                        output.writeByte(61)
                        bytes = encoding.getBytes(Server.URLEncode(param.Value & ""))
                        output.write(bytes, 0, bytes.Length)
                    Next
                End If
                output.Close()
            End If
        End Sub

        ' Send a nice error message to the client
        Private Function handleWebException(ByVal ex As WebException)
            Response.TrySkipIisCustomErrors = true
            Dim ccResponse As HttpWebResponse = ex.Response
            If ccResponse Is Nothing Then
                If ex.Status = WebExceptionStatus.Timeout Then
                    Response.StatusCode = 504
                    Response.Write("<html><title>504 Gateway Time-out</title>" + Chr(13))
                    Response.Write("<h1>504 Gateway Time-out</h1>")
                Else
                    Response.StatusCode = 502
                    Response.Write("<html><title>502 Bad Gateway</title>" + Chr(13))
                    Response.Write("<h1>502 Bad Gateway</h1>")
                End If
                Dim exc As Exception
                exc = ex
                While Not exc Is Nothing
                    Response.Write(exc.Message)
                    Response.Write("<p>" + Chr(13))
                    exc = exc.InnerException
                End While
                Response.End()
            End If
            handleWebException = ccResponse
        End Function


        ' Is it a program code request and no additional params should be added
        Private Function isProgramCode(ByVal Context As String) As Boolean
            isProgramCode = Not Request.QueryString("serviceId") Is Nothing Or _
                                Context.StartsWith("core/") Or _
                                Context.StartsWith("client/")
        End Function


        'Set the needed header for the Backend Server
        Private Sub SetRequestHeaders()
            CopyHttpHeader("Cookie")
            Dim header As String
            For Each header In Request.Headers.AllKeys
                If header.StartsWith("X-", True, New CultureInfo("en-US")) Then
                    ccRequest.Headers.Set(header, Request.Headers.Item(header))
                End If
            Next
            CopyHttpHeader("Accept-Language")
            ccRequest.Headers.Set("X-Host", Request.ServerVariables("HTTP_HOST"))
            ccRequest.Headers.Set("X-Forwarded-Host", Request.ServerVariables("HTTP_HOST"))
            ccRequest.Headers.Set("X-Forwarded-For", Request.ServerVariables("REMOTE_ADDR"))
            ccRequest.Headers.Set("X-Forwarded-Context", Uri.EscapeUriString(Request.ServerVariables("URL")))
            ccRequest.UserAgent = Request.UserAgent
            ccRequest.Accept = Request.Headers("Accept")

            Dim protocol As String
            If "on".Equals(Request.ServerVariables("HTTPS"), StringComparison.OrdinalIgnoreCase) Then
                protocol = "https"
            Else
                protocol = "http"
            End If
            ccRequest.Headers.Set("X-Forwarded-Proto", protocol)

            CopyHttpHeader("Authorization")
            CopyHttpHeader("Depth")
            CopyHttpHeader("Destination")
            CopyHttpHeader("Origin")
        End Sub

        Private Sub CopyHttpHeader(ByVal header As String)
            Dim value As String
            value = Request.Headers.Item(header)
            If Not value Is Nothing Then
                ccRequest.Headers.Set(header, value)
            End If
        End Sub

        ' Start the request
        Public Sub Run()
            Dim ccResponse As HttpWebResponse
            Try
                ccResponse = CType(ccRequest.GetResponse(), HttpWebResponse)
            Catch ex As WebException
                ccResponse = handleWebException(ex)
            End Try
            Response.ClearHeaders()
            Response.TrySkipIisCustomErrors = true
            Response.StatusCode = ccResponse.StatusCode
            Response.StatusDescription = ccResponse.StatusDescription
            Dim key As String
            For Each key In ccResponse.Headers.Keys
                If (String.Compare(key, "transfer-encoding", True) <> 0) And (String.Compare(key, "server", True) <> 0) Then
                    Dim values As String()
                    values = ccResponse.Headers.GetValues(key)
                    Dim value As String
                    If key = "WWW-Authenticate" Then
                        For Each value In values
                            If Not value.Equals("Negotiate", StringComparison.OrdinalIgnoreCase) And Not value.Equals("NTLM", StringComparison.OrdinalIgnoreCase) Then
                                Response.AddHeader(key, value)
                            End If
                        Next value
                    ElseIf key = "Set-Cookie" Then
                        For Each value In values
                            value = value.Replace( "Path=" + BackendContext, "Path=" + AppContext )
                            Response.AddHeader(key, value)
                        Next value
                    Else
                        For Each value In values
                            Response.AddHeader(key, value)
                        Next value
                    End If
                End If
            Next key

            copyStream(ccResponse.GetResponseStream(), Response.OutputStream)
            Response.OutputStream.Close()
        End Sub

        Private Sub copyStream(ByVal input As Stream, ByVal output As Stream)

            ' Transfer Data in a loop
            Dim bytes(4000) As Byte
            While True
                Dim n As Integer = input.Read(bytes, 0, 4000)
                If n <= 0 Then
                    Exit While
                End If
                output.Write(bytes, 0, n)
            End While
            input.Close()
        End Sub

    End Class

End Namespace
