/*
 * Decompiled with CFR 0.152.
 */
package com.inet.setupwizard.execution;

import com.inet.annotations.JsonData;
import com.inet.setupwizard.SetupWizardPlugin;
import com.inet.setupwizard.api.InfoMessageGetter;
import com.inet.setupwizard.api.SetupStep;
import com.inet.setupwizard.api.StepExecutionWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class StepExecutionWarningsImpl
extends StepExecutionWarnings {
    private List<Entry> aF = new ArrayList<Entry>();
    private boolean v = false;

    @Override
    public void info(InfoMessageGetter warning) {
        this.a(warning, LEVEL.INFO);
    }

    @Override
    public void warn(InfoMessageGetter warning) {
        this.a(warning, LEVEL.WARNING);
    }

    @Override
    public void error(InfoMessageGetter warning) {
        this.a(warning, LEVEL.ERROR);
    }

    @Override
    public boolean hasErrors() {
        return this.aF.stream().anyMatch(entry -> entry.warnings.stream().anyMatch(warning -> warning.level == LEVEL.ERROR));
    }

    @Override
    public boolean hasInfos() {
        return this.aF.stream().anyMatch(entry -> entry.warnings.stream().anyMatch(warning -> warning.level == LEVEL.INFO));
    }

    @Override
    public boolean hasWarnings() {
        return this.aF.stream().anyMatch(entry -> entry.warnings.stream().anyMatch(warning -> warning.level == LEVEL.WARNING));
    }

    private void a(InfoMessageGetter infoMessageGetter, LEVEL lEVEL) {
        if (this.aF.isEmpty() || this.v) {
            throw new IllegalStateException("No Step is currently executing. You can only call this when a step is executed!");
        }
        Entry entry = this.aF.get(this.aF.size() - 1);
        if (entry.warnings.size() < 30) {
            entry.warnings.add(new Warning(lEVEL, infoMessageGetter));
        }
    }

    public void d(SetupStep<?> setupStep) {
        this.E();
        this.aF.add(new Entry(() -> setupStep.getStepDisplayName()));
    }

    private void E() {
        if (!this.aF.isEmpty() && this.aF.get(this.aF.size() - 1).getWarnings().isEmpty()) {
            this.aF.remove(this.aF.size() - 1);
        }
    }

    public List<Entry> F() {
        return new ArrayList<Entry>(this.aF);
    }

    public void G() {
        this.E();
        this.aF.add(new Entry(() -> SetupWizardPlugin.MSG.getMsg("stepExecutionWarnings.AfterLastStep", new Object[0])));
    }

    public void H() {
        this.E();
        this.v = true;
        StepExecutionWarnings.set(null);
    }

    @JsonData
    public static enum LEVEL {
        ERROR,
        WARNING,
        INFO;

    }

    @JsonData
    public static class Entry {
        private transient InfoMessageGetter step;
        private String stepDisplayName;
        private List<Warning> warnings = new ArrayList<Warning>();

        private Entry() {
        }

        public Entry(InfoMessageGetter step) {
            this.step = step;
        }

        public void localize() {
            if (this.step != null) {
                this.stepDisplayName = this.step.getMsg();
            }
            for (Warning warning : this.warnings) {
                if (warning.i18n == null) continue;
                warning.message = warning.i18n.getMsg();
            }
            List list = this.getWarnings().stream().distinct().collect(Collectors.toList());
            this.getWarnings().clear();
            this.getWarnings().addAll(list);
        }

        public InfoMessageGetter getStep() {
            return this.step;
        }

        public List<Warning> getWarnings() {
            return this.warnings;
        }

        public void setStepDisplayName(String stepDisplayName) {
            this.stepDisplayName = stepDisplayName;
        }

        public String getStepDisplayName() {
            return this.stepDisplayName;
        }

        public int hashCode() {
            int n = 31;
            int n2 = 1;
            n2 = 31 * n2 + (this.stepDisplayName == null ? (this.step != null ? this.step.hashCode() : 0) : this.stepDisplayName.hashCode());
            n2 = 31 * n2 + (this.warnings == null ? 0 : this.warnings.hashCode());
            return n2;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Entry entry = (Entry)obj;
            if (this.stepDisplayName == null) {
                if (entry.stepDisplayName != null) {
                    return false;
                }
                if (!Objects.equals(this.step, entry.step)) {
                    return false;
                }
            } else if (!this.stepDisplayName.equals(entry.stepDisplayName)) {
                return false;
            }
            return !(this.warnings == null ? entry.warnings != null : !this.warnings.equals(entry.warnings));
        }
    }

    @JsonData
    public static class Warning {
        private LEVEL level;
        private transient InfoMessageGetter i18n;
        private String message;

        private Warning() {
        }

        public Warning(LEVEL level, InfoMessageGetter i18n) {
            this.level = level;
            this.i18n = i18n;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public LEVEL getLevel() {
            return this.level;
        }

        public InfoMessageGetter getI18n() {
            return this.i18n;
        }

        public int hashCode() {
            int n = 31;
            int n2 = 1;
            n2 = 31 * n2 + (this.level == null ? 0 : this.level.hashCode());
            n2 = 31 * n2 + (this.message == null ? (this.i18n != null ? this.i18n.hashCode() : 0) : this.message.hashCode());
            return n2;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Warning warning = (Warning)obj;
            if (this.level != warning.level) {
                return false;
            }
            if (this.message == null) {
                if (warning.message != null) {
                    return false;
                }
                if (!Objects.equals(this.i18n, warning.i18n)) {
                    return false;
                }
            } else if (!this.message.equals(warning.message)) {
                return false;
            }
            return true;
        }
    }
}

