/*
 * Decompiled with CFR 0.152.
 */
package com.inet.setupwizard.basicsteps.defaultwebserver.newinstallation;

import com.inet.config.ConfigKey;
import com.inet.config.Configuration;
import com.inet.config.ConfigurationManager;
import com.inet.setupwizard.api.SetupLogger;
import java.net.URL;
import java.util.Objects;

public class ServerURLConfigValueSetter {
    public static final int MAX_PORT = 65535;

    public void setServerURLInCurrentConfiguration(boolean isSecureProtocol, String address, int port, String context) {
        if (address == null) {
            throw new IllegalArgumentException("address must not be null");
        }
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("port must not be negative or greater than 65535");
        }
        if (context == null) {
            throw new IllegalArgumentException("context must not be null");
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(isSecureProtocol ? "https" : "http").append("://").append(address).append((String)(!isSecureProtocol && port == 80 || isSecureProtocol && port == 443 ? "" : ":" + port)).append("/").append((String)(context.isEmpty() ? "" : context + "/"));
        this.setServerURLInCurrentConfiguration(stringBuilder.toString());
    }

    public void setServerURLInCurrentConfiguration(String serverUrl) {
        Configuration configuration = ConfigurationManager.getInstance().getCurrent();
        String string = configuration.get(ConfigKey.SERVER_URL.getKey());
        if (string == null) {
            String string2 = ConfigKey.SERVER_URL.getDefault();
            try {
                int n;
                String string3;
                URL uRL = new URL(serverUrl);
                URL uRL2 = new URL(string2);
                String string4 = uRL.getPath();
                if (string4.length() == 0) {
                    string4 = "/";
                }
                if ((string3 = uRL2.getPath()).length() == 0) {
                    string3 = "/";
                }
                if ((n = uRL.getPort()) < 0) {
                    n = uRL.getDefaultPort();
                }
                int n2 = (Integer)ConfigKey.LISTENER_PORT.getCurrent();
                if (uRL.getProtocol().equals(uRL2.getProtocol()) && uRL.getHost().equals(uRL2.getHost()) && string4.equals(string3) && n == n2) {
                    SetupLogger.LOGGER.info((Object)("Use default ServerUrl: " + serverUrl));
                    return;
                }
            }
            catch (Exception exception) {
                SetupLogger.LOGGER.info((Object)exception);
            }
        }
        if (!Objects.equals(serverUrl, string)) {
            SetupLogger.LOGGER.info((Object)("Setting ServerUrl config value to " + serverUrl));
            configuration.put(ConfigKey.SERVER_URL, serverUrl);
        } else {
            SetupLogger.LOGGER.info((Object)("Current ServerUrl config value is: " + string));
        }
    }
}

