/*
 * Decompiled with CFR 0.152.
 */
package com.inet.setupwizard.basicsteps.defaultwebserver;

import com.inet.setupwizard.api.StepExecutionException;
import com.inet.setupwizard.api.StepExecutionWarnings;
import com.inet.setupwizard.basicsteps.CommandExecutor;
import com.inet.setupwizard.basicsteps.defaultwebserver.resources.DefaultResourceExtractor;
import com.inet.setupwizard.basicsteps.webserver.ListenerPortSetter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;

public class DefaultMicrosoftIISExecutionTask {
    private final CommandExecutor Q = new CommandExecutor();
    private final Path V;
    private final ListenerPortSetter W;
    private final DefaultResourceExtractor X = new DefaultResourceExtractor();

    public DefaultMicrosoftIISExecutionTask(Path installationDir, ListenerPortSetter listenerPortSetter) {
        if (installationDir == null) {
            throw new IllegalArgumentException("installation directory path must not be null");
        }
        if (listenerPortSetter == null) {
            throw new IllegalArgumentException("listener port setter must not be null");
        }
        this.V = installationDir;
        this.W = listenerPortSetter;
    }

    public void executeNewInstallation(String context, String protocol) throws StepExecutionException {
        this.o();
        this.g(context, protocol);
        this.W.setPortThatServerIsListeningOnIntoCurrentConfig();
    }

    public void executeUpdate(String context, String protocol) {
        try {
            this.o();
            this.g(context, protocol);
        }
        catch (StepExecutionException stepExecutionException) {
            StepExecutionWarnings.get().error(() -> stepExecutionException.getMessage());
        }
    }

    private void o() throws StepExecutionException {
        Path path = this.V.resolve("IIS");
        try {
            if (!Files.exists(path, new LinkOption[0])) {
                Files.createDirectory(path, new FileAttribute[0]);
            }
            this.X.copyResourceToDir("index.htm", path);
            this.X.copyResourceToDir("web.config", path);
            this.X.copyResourceToDir("ClientProxy.vb", path);
            this.X.copyResourceToDir("default.aspx", path);
        }
        catch (IOException iOException) {
            throw new StepExecutionException(iOException);
        }
    }

    private void g(String string, String string2) throws StepExecutionException {
        Path path = Paths.get(System.getenv("WINDIR"), "system32", "inetsrv", "appcmd.exe");
        boolean bl = Files.isExecutable(path);
        if (!bl) {
            throw new StepExecutionException("The AppCmd.exe command line could not be found");
        }
        String string3 = this.V.toAbsolutePath().toString();
        this.a(path, "add", "app", "/site.name:Default Web Site", "/path:/" + string, "/physicalPath:" + string3 + "\\IIS", "/applicationPool:DefaultAppPool");
        this.a(path, "set", "app", "/app.name:Default Web Site/" + string, "/enabledProtocols:" + string2);
    }

    private void a(Path path, String ... stringArray) throws StepExecutionException {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\"").append(path.toAbsolutePath().toString()).append("\"");
            for (String string : stringArray) {
                stringBuilder.append(" ").append("\"").append(string).append("\"");
            }
            this.Q.executeCommand(stringBuilder.toString());
        }
        catch (Exception exception) {
            throw new StepExecutionException(exception);
        }
    }
}

