/*
 * Decompiled with CFR 0.152.
 */
package com.inet.setupwizard.basicsteps;

import com.inet.lib.util.PreferencesUtils;
import com.inet.setupwizard.api.SetupLogger;
import com.inet.setupwizard.basicsteps.CommandExecutor;
import java.util.Arrays;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import java.util.stream.Collectors;

public class WinRegistryManipulator {
    private final CommandExecutor Q = new CommandExecutor();
    private final String R;
    private final String S;
    private final String T;
    private final String U;

    private WinRegistryManipulator(String rootNode) {
        this.R = rootNode + "\\SOFTWARE\\Wow6432Node\\JavaSoft\\Prefs\\com\\inet\\report\\config\\cc";
        this.S = rootNode + "\\SOFTWARE\\JavaSoft\\Prefs\\com\\inet\\report\\config\\cc";
        this.T = rootNode + "\\SOFTWARE\\Wow6432Node\\JavaSoft\\Prefs\\com\\inet\\report\\config\\datasource";
        this.U = rootNode + "\\SOFTWARE\\JavaSoft\\Prefs\\com\\inet\\report\\config\\datasource";
    }

    public static WinRegistryManipulator forSystemNode() {
        return new WinRegistryManipulator("HKEY_LOCAL_MACHINE");
    }

    public static WinRegistryManipulator forCurrentUserNode() {
        return new WinRegistryManipulator("HKEY_CURRENT_USER");
    }

    public boolean doesDataSourcesNodeExistInNode32() throws CommandExecutor.UnsuccessfulExecutionException {
        return this.c(this.T);
    }

    public boolean doesDataSourcesNodeExistInNode64() throws CommandExecutor.UnsuccessfulExecutionException {
        return this.c(this.U);
    }

    public boolean doesNonEmptyDataSourcesNodeExistInNode32() throws CommandExecutor.UnsuccessfulExecutionException {
        return this.d(this.T);
    }

    public boolean doesNonEmptyDataSourcesNodeExistInNode64() throws CommandExecutor.UnsuccessfulExecutionException {
        return this.d(this.U);
    }

    public boolean doesConfigExistInNode32(String configurationName) throws CommandExecutor.UnsuccessfulExecutionException {
        String string = this.a(configurationName);
        return this.a(string, this.R);
    }

    public boolean doesConfigExistInNode64(String configurationName) throws CommandExecutor.UnsuccessfulExecutionException {
        String string = this.a(configurationName);
        return this.a(string, this.S);
    }

    public void createDataSourcesNode64IfDoesNotExist() throws CommandExecutor.UnsuccessfulExecutionException {
        this.b(this.U);
    }

    private String a(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (char c2 : string.toCharArray()) {
            if (Character.isUpperCase(c2)) {
                stringBuilder.append('/');
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    public void copyConfigurationFromNode32ToNode64(String configurationName) throws CommandExecutor.UnsuccessfulExecutionException {
        String string = this.a(configurationName);
        String string2 = this.R + "\\" + string;
        String string3 = this.S + "\\" + string;
        if (this.a(string, this.S)) {
            this.f("com/inet/report/config/cc/" + configurationName);
        }
        this.b(string2, string3);
    }

    private boolean a(String string, String string2) throws CommandExecutor.UnsuccessfulExecutionException {
        boolean bl = this.c(string2) && this.g(string2).contains(string);
        SetupLogger.LOGGER.info((Object)("Does key '" + string + "' exist in node '" + string2 + "'? " + bl));
        return bl;
    }

    public void copyDataSourcesFromNode32ToNode64() throws CommandExecutor.UnsuccessfulExecutionException {
        List<String> list = this.c(this.T, this.U);
        List<String> list2 = this.a(list, this.U);
        this.f(list2);
        this.b(this.T, this.U);
    }

    private void b(String string) throws CommandExecutor.UnsuccessfulExecutionException {
        if (!this.c(string)) {
            this.Q.executeCommand(String.format("reg add \"%s\" /f", string));
        }
    }

    private boolean c(String string) throws CommandExecutor.UnsuccessfulExecutionException {
        try {
            this.Q.executeCommand(String.format("reg query \"%s\"", string));
            return true;
        }
        catch (CommandExecutor.UnsuccessfulExecutionException unsuccessfulExecutionException) {
            if ((Integer)unsuccessfulExecutionException.getExitStatus().orElse(null) != 1) {
                throw unsuccessfulExecutionException;
            }
            return false;
        }
    }

    private boolean d(String string) throws CommandExecutor.UnsuccessfulExecutionException {
        try {
            String string2 = this.Q.executeCommand(String.format("reg query \"%s\"", string));
            return !string2.trim().isEmpty();
        }
        catch (CommandExecutor.UnsuccessfulExecutionException unsuccessfulExecutionException) {
            if ((Integer)unsuccessfulExecutionException.getExitStatus().orElse(null) != 1) {
                throw unsuccessfulExecutionException;
            }
            return false;
        }
    }

    private void b(String string, String string2) throws CommandExecutor.UnsuccessfulExecutionException {
        SetupLogger.LOGGER.info((Object)("copy key: " + string + " to " + string2));
        String string3 = String.format("reg copy \"%s\" \"%s\" /s /f", string, string2);
        this.Q.executeCommand(string3);
    }

    private void f(List<String> list) throws CommandExecutor.UnsuccessfulExecutionException {
        for (String string : list) {
            this.e(string);
        }
    }

    private void e(String string) throws CommandExecutor.UnsuccessfulExecutionException {
        SetupLogger.LOGGER.info((Object)("Delete key: " + string));
        String string2 = String.format("reg delete \"%s\" /f", string);
        this.Q.executeCommand(string2);
    }

    private void f(String string) throws CommandExecutor.UnsuccessfulExecutionException {
        Preferences preferences = PreferencesUtils.systemRoot();
        try {
            Preferences preferences2 = preferences.node(string);
            SetupLogger.LOGGER.info((Object)("Delete key by java prefs: " + preferences2.absolutePath()));
            Preferences preferences3 = preferences2.parent();
            preferences2.removeNode();
            preferences3.flush();
        }
        catch (BackingStoreException backingStoreException) {
            throw new CommandExecutor.UnsuccessfulExecutionException(backingStoreException);
        }
    }

    private List<String> a(List<String> list, String string) {
        return list.stream().map(string2 -> string + "\\" + string2).collect(Collectors.toList());
    }

    private List<String> c(String string, String string2) throws CommandExecutor.UnsuccessfulExecutionException {
        List<String> list = this.g(string);
        List<String> list2 = this.g(string2);
        list.retainAll(list2);
        return list;
    }

    private List<String> g(String string) throws CommandExecutor.UnsuccessfulExecutionException {
        String string3 = this.Q.executeCommand(String.format("reg query \"%s\"", string));
        return Arrays.asList(string3.split("\n")).stream().filter(string2 -> string2.startsWith(string + "\\")).map(string2 -> string2.substring(string.length() + 1)).collect(Collectors.toList());
    }
}

