/*
 * Decompiled with CFR 0.152.
 */
package com.inet.setupwizard.basicsteps.webserver;

import com.inet.annotations.JsonData;

@JsonData
public class ProxySetupMetaData {
    public static final String DEPRECATED_APACHE = "apache";
    private String context;
    @Deprecated
    private transient String apacheConfigPath;
    private String protocol;
    private String proxyType;
    private String version;

    public ProxySetupMetaData() {
    }

    public ProxySetupMetaData(String proxyType, String context, String protocol, String version) {
        this.setProxyType(proxyType);
        this.setContext(context);
        this.setProtocol(protocol);
        this.setVersion(version);
    }

    public void setVersion(String version) {
        if (version == null || version.trim().isEmpty()) {
            throw new IllegalArgumentException("Invalid version: " + version);
        }
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.checkContext(context);
        this.context = context;
    }

    private void checkContext(String context) {
        if (context == null) {
            return;
        }
        if (context.matches(".*[/\\\\%].*")) {
            throw new IllegalArgumentException("Invalid context: " + context);
        }
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.checkProtocol(protocol);
        this.protocol = protocol;
    }

    private void checkProtocol(String protocol) {
        if (protocol == null || protocol.isEmpty()) {
            return;
        }
        if (!protocol.equals("http") && !protocol.equals("https")) {
            throw new IllegalArgumentException("Invalid protocol: " + protocol);
        }
    }

    public String getProxyType() {
        return this.proxyType;
    }

    public void setProxyType(String proxyType) {
        this.proxyType = proxyType = this.checkType(proxyType);
    }

    private String checkType(String proxyType) {
        if (proxyType == null) {
            throw new IllegalArgumentException("Invalid type: " + proxyType);
        }
        switch (proxyType) {
            case "iis": 
            case "standalone": 
            case "apache": {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid type: " + proxyType);
            }
        }
        return proxyType;
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + (this.context == null ? 0 : this.context.hashCode());
        n2 = 31 * n2 + (this.protocol == null ? 0 : this.protocol.hashCode());
        n2 = 31 * n2 + (this.proxyType == null ? 0 : this.proxyType.hashCode());
        n2 = 31 * n2 + (this.version == null ? 0 : this.version.hashCode());
        return n2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProxySetupMetaData proxySetupMetaData = (ProxySetupMetaData)obj;
        if (this.context == null ? proxySetupMetaData.context != null : !this.context.equals(proxySetupMetaData.context)) {
            return false;
        }
        if (this.protocol == null ? proxySetupMetaData.protocol != null : !this.protocol.equals(proxySetupMetaData.protocol)) {
            return false;
        }
        if (this.proxyType == null ? proxySetupMetaData.proxyType != null : !this.proxyType.equals(proxySetupMetaData.proxyType)) {
            return false;
        }
        return !(this.version == null ? proxySetupMetaData.version != null : !this.version.equals(proxySetupMetaData.version));
    }
}

