/*
 * Decompiled with CFR 0.152.
 */
package com.inet.setupwizard.basicsteps.updatewebserver;

import com.inet.setupwizard.SetupWizardPlugin;
import com.inet.setupwizard.api.EmptyStepConfig;
import com.inet.setupwizard.api.InfoMessageGetter;
import com.inet.setupwizard.api.SetupStep;
import com.inet.setupwizard.api.SetupStepPriority;
import com.inet.setupwizard.api.StepConfigurationStorage;
import com.inet.setupwizard.api.StepExecutionException;
import com.inet.setupwizard.api.StepExecutionWarnings;
import com.inet.setupwizard.api.StepKey;
import com.inet.setupwizard.api.StepsRepository;
import com.inet.setupwizard.basicsteps.BasicStepPriorities;
import com.inet.setupwizard.basicsteps.updatewebserver.AdditionalActionRequiredException;
import com.inet.setupwizard.basicsteps.webserver.ProxySetupMetaData;
import com.inet.setupwizard.basicsteps.webserver.ProxySetupMetaDataReader;
import java.util.Map;

public abstract class UpdateWebServerStep
extends SetupStep<EmptyStepConfig> {
    public static final StepKey KEY = new StepKey("updateproxy");

    @Override
    public StepKey stepKey() {
        return KEY;
    }

    @Override
    public String getStepDisplayName() {
        return SetupWizardPlugin.MSG.getMsg("updateproxy.displayName", new Object[0]);
    }

    protected boolean isProxyInstalled(ProxySetupMetaDataReader metaDataReader) {
        if (metaDataReader == null) {
            throw new IllegalArgumentException("metaDataReader must not be null");
        }
        ProxySetupMetaData proxySetupMetaData = metaDataReader.read();
        return proxySetupMetaData != null && !proxySetupMetaData.getProxyType().equals("standalone");
    }

    @Override
    public boolean doesRequireToRestartServerAfterExecution(EmptyStepConfig stepConfig) {
        return false;
    }

    @Override
    public SetupStepPriority getPriority() {
        return BasicStepPriorities.UPDATE_WEBSERVER;
    }

    @Override
    public InfoMessageGetter getExecutionInfoMessage(EmptyStepConfig stepConfig) {
        return () -> SetupWizardPlugin.MSG.getMsg("updateproxy.executionMessage", new Object[0]);
    }

    @Override
    public EmptyStepConfig updateConfiguration(StepConfigurationStorage storage, StepsRepository repository, EmptyStepConfig stepConfig, StepKey changedStep) {
        return new EmptyStepConfig();
    }

    public abstract void execute0(EmptyStepConfig var1) throws StepExecutionException, AdditionalActionRequiredException;

    @Override
    public void execute(EmptyStepConfig stepConfig, Map<String, String> metaData) throws StepExecutionException {
        try {
            this.execute0(stepConfig);
        }
        catch (AdditionalActionRequiredException additionalActionRequiredException) {
            this.deleteProxyMetaData();
            UpdateWebServerStep.addStepExecutionWarningForProxyUpdateError(additionalActionRequiredException);
        }
    }

    public static void addStepExecutionWarningForProxyUpdateError(AdditionalActionRequiredException ex) {
        StepExecutionWarnings.get().error(() -> SetupWizardPlugin.MSG.getMsg("updateproxy.errorMessage.moreActions", new Object[]{ex.getMessage()}));
    }

    protected abstract void deleteProxyMetaData();
}

