/*
 * Decompiled with CFR 0.152.
 */
package com.inet.setupwizard.basicsteps.permissions.init;

import com.inet.permissions.Permission;
import com.inet.setupwizard.SetupWizardPlugin;
import com.inet.setupwizard.api.AutoSetupStep;
import com.inet.setupwizard.api.EmptyStepConfig;
import com.inet.setupwizard.api.InfoMessageGetter;
import com.inet.setupwizard.api.SetupLogger;
import com.inet.setupwizard.api.SetupStepPriority;
import com.inet.setupwizard.api.StepExecutionException;
import com.inet.setupwizard.api.StepKey;
import com.inet.setupwizard.basicsteps.BasicStepPriorities;
import com.inet.setupwizard.basicsteps.UserManagerWait;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public class SystemPermissionInitStep
extends AutoSetupStep {
    public static final StepKey KEY = new StepKey("SystemPermissionInitialization");
    @Nonnull
    private final List<Permission> aq;

    public SystemPermissionInitStep(Permission ... defaultPermissionsForAllUsers) {
        this.aq = Arrays.asList(defaultPermissionsForAllUsers);
    }

    @Override
    public StepKey stepKey() {
        return KEY;
    }

    @Override
    public String getStepDisplayName() {
        return SetupWizardPlugin.MSG.getMsg("systempermissionsinit.displayname", new Object[0]);
    }

    @Override
    public boolean hasPendingTasks() {
        return this.getLastMigratedVersionOfThisPlugin() == null && !Boolean.getBoolean("setupautoexecution");
    }

    @Override
    public void execute(EmptyStepConfig stepConfig, Map<String, String> metaData) throws StepExecutionException {
        UserManagerWait.waitForUserManagerVeto(this.getStepExecutionProgressListener(), this);
        this.w();
    }

    private void w() {
        UserGroupManager userGroupManager = UserGroupManager.getInstance();
        UserGroupInfo userGroupInfo = userGroupManager.getGroup(UsersAndGroups.GROUP_ALLUSERS);
        HashSet<Permission> hashSet = new HashSet<Permission>(this.aq);
        userGroupManager.updateGroupPermissions(userGroupInfo.getID(), hashSet, Collections.emptySet());
        SetupLogger.LOGGER.info((Object)"[SystemPermisionInit] Added default permissions for all users");
    }

    @Override
    public SetupStepPriority getPriority() {
        return BasicStepPriorities.SYSTEMPERMISSIONS_INIT;
    }

    @Override
    public InfoMessageGetter getExecutionInfoMessage(EmptyStepConfig stepConfig) {
        return () -> SetupWizardPlugin.MSG.getMsg("systempermissionsinit.executionMessage", new Object[0]);
    }
}

