/*
 * Decompiled with CFR 0.152.
 */
package com.inet.setupwizard.basicsteps.license;

import com.inet.config.ConfigKey;
import com.inet.config.Configuration;
import com.inet.config.ConfigurationManager;
import com.inet.lib.util.StringFunctions;
import com.inet.setupwizard.api.SetupLogger;
import com.inet.setupwizard.api.SetupStepProblems;
import com.inet.setupwizard.api.StepExecutionException;
import com.inet.setupwizard.basicsteps.license.LicenseStepConfig;
import com.inet.setupwizard.basicsteps.license.LicenseStepConfigChecker;

public class LicenseStepExecutionTask {
    private LicenseStepConfigChecker ah;

    public LicenseStepExecutionTask(LicenseStepConfigChecker configChecker) {
        if (configChecker == null) {
            throw new IllegalArgumentException("config checker must not be null");
        }
        this.ah = configChecker;
    }

    public void execute(LicenseStepConfig stepConfig) throws StepExecutionException {
        String string;
        SetupStepProblems setupStepProblems = this.ah.findProblemsWithConfig(stepConfig);
        if (setupStepProblems.hasErrors()) {
            throw new IllegalStateException("stepConfig must be valid at this point, errors: " + String.valueOf(setupStepProblems.getErrors()));
        }
        if (stepConfig.isIncludedInConfiguration()) {
            SetupLogger.LOGGER.info((Object)"[License] Nothing to do because license key is already included in configuration.");
            return;
        }
        Configuration configuration = ConfigurationManager.getInstance().getCurrent();
        String string2 = configuration.get(ConfigKey.LICENSEKEY);
        if (!string2.contains(string = stepConfig.licenseKey())) {
            string = StringFunctions.isEmpty((String)string2) ? string : string + "," + string2;
            configuration.put(ConfigKey.LICENSEKEY, string);
        }
    }
}

