/*
 * Decompiled with CFR 0.152.
 */
package com.inet.setupwizard.basicsteps.license;

import com.inet.config.ConfigKey;
import com.inet.plugin.ApplicationDescription;
import com.inet.plugin.ServerPluginManager;
import com.inet.setupwizard.api.StepConfigurationStorage;
import com.inet.setupwizard.basicsteps.license.LicenseStepConfig;
import com.inet.setupwizard.basicsteps.license.LicenseStepConfigChecker;
import com.inet.setupwizard.basicsteps.license.SystemInformationProvider;
import com.inet.setupwizard.basicsteps.license.TrialLicenseKeyProvider;

public class LicenseStepConfigUpdater {
    private LicenseStepConfigChecker ah;
    private TrialLicenseKeyProvider ai;
    private SystemInformationProvider aj;

    public LicenseStepConfigUpdater(LicenseStepConfigChecker configChecker, TrialLicenseKeyProvider trialLicenseKeyProvider, SystemInformationProvider systemInformationProvider) {
        if (configChecker == null) {
            throw new IllegalArgumentException("license step config checker must not be null");
        }
        if (trialLicenseKeyProvider == null) {
            throw new IllegalArgumentException("trial license key provider must not be null");
        }
        this.ah = configChecker;
        this.ai = trialLicenseKeyProvider;
        this.aj = systemInformationProvider;
    }

    public LicenseStepConfig updateConfiguration(StepConfigurationStorage stepConfigurationStorage, LicenseStepConfig stepConfig) {
        if (stepConfig != null) {
            return stepConfig;
        }
        String string = (String)ConfigKey.LICENSEKEY.getCurrent();
        if (string != null && !string.isEmpty()) {
            String string2 = this.ah.getFirstValidLicenseKey(string);
            if (string2 != null) {
                return new LicenseStepConfig(string2, true, false, this.aj.getSystemInformations());
            }
            return new LicenseStepConfig(string, true, false, this.aj.getSystemInformations());
        }
        return new LicenseStepConfig(LicenseStepConfigUpdater.getTrialLicenseUrl(), this.aj.getSystemInformations());
    }

    public static String getTrialLicenseUrl() {
        ApplicationDescription applicationDescription = (ApplicationDescription)ServerPluginManager.getInstance().getSingleInstance(ApplicationDescription.class);
        String string = applicationDescription.getTrialLicenseBrowserURL();
        if (string != null) {
            return string;
        }
        return "mailto:" + applicationDescription.getDefaultSupportAddress();
    }
}

