/*
 * Decompiled with CFR 0.152.
 */
package com.inet.setupwizard;

import com.inet.config.ConfigurationManager;
import com.inet.logging.LogLevel;
import com.inet.logging.LogManager;
import com.inet.logging.LoggingAppender;
import com.inet.logging.LoggingEvent;
import com.inet.plugin.ServerPluginManager;
import com.inet.setupwizard.SetupWizardPlugin;
import com.inet.setupwizard.api.SetupStepsExecutionListener;
import com.inet.setupwizard.api.StepKey;
import com.inet.shared.utils.ProductionEnvironmentCheck;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import javax.annotation.Nonnull;
import javax.annotation.SuppressFBWarnings;

public class b
implements SetupStepsExecutionListener {
    private File d;
    private LoggingAppender e;
    private PrintStream f;

    b() {
        if (!ProductionEnvironmentCheck.inProduction()) {
            return;
        }
        if (ConfigurationManager.isHelpCenterMode()) {
            return;
        }
        if (ConfigurationManager.isRecoveryMode()) {
            return;
        }
        this.d = this.d();
        try {
            this.f = new PrintStream(this.d);
            this.e = new LoggingAppender(){

                public void append(LoggingEvent event) {
                    Object object = event.getMessage();
                    if (object instanceof Throwable) {
                        b.this.a(b.this.f, (Throwable)object, event);
                    } else {
                        b.a(b.this.f, event.getModule(), event.getLevel(), String.valueOf(object), event.getLogID());
                    }
                }
            };
            LogManager.addLoggingAppender((LoggingAppender)this.e);
            b.a(this.f, "SetupLogger", LogLevel.STATUS, "This file contains normal log up to the point when the setup is completed.", "0000");
        }
        catch (FileNotFoundException fileNotFoundException) {
            SetupWizardPlugin.LOGGER.warn((Object)("Cannot create a logfile for setup: " + String.valueOf(this.d)));
        }
    }

    public void a(ServerPluginManager serverPluginManager) {
        if (!ProductionEnvironmentCheck.inProduction()) {
            return;
        }
        serverPluginManager.register(SetupStepsExecutionListener.class, (Object)this);
    }

    public void b() {
        if (this.e != null) {
            LogManager.removeLoggingAppender((LoggingAppender)this.e);
        }
        if (this.f != null) {
            this.f.close();
        }
    }

    public void reset() {
        this.b();
        if (this.d != null) {
            this.d.delete();
        }
        this.e = null;
        this.d = null;
    }

    public File c() {
        return this.d;
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Generates new Filename")
    private File d() {
        Object object = "SetupLog.txt";
        while (Files.exists(Paths.get((String)object, new String[0]), new LinkOption[0])) {
            long l = System.currentTimeMillis();
            object = "SetupLog_" + l + ".txt";
        }
        return Paths.get((String)object, new String[0]).toFile();
    }

    private void a(@Nonnull PrintStream printStream, @Nonnull Throwable throwable, LoggingEvent loggingEvent) {
        int n;
        Object object;
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        if (throwable instanceof SQLException) {
            object = (SQLException)throwable;
            while ((object = ((SQLException)object).getNextException()) != null) {
                stringWriter.write("\n\t" + String.valueOf(object));
            }
        }
        if ((n = ((String)(object = stringWriter.toString())).indexOf("\n")) >= 0) {
            b.a(printStream, loggingEvent.getModule(), loggingEvent.getLevel(), ((String)object).substring(0, n), loggingEvent.getLogID());
            b.a(printStream, loggingEvent.getModule(), LogLevel.TRACE, ((String)object).substring(n), loggingEvent.getLogID());
            return;
        }
        b.a(printStream, loggingEvent.getModule(), loggingEvent.getLevel(), throwable.toString(), loggingEvent.getLogID());
    }

    private static final void a(@Nonnull PrintStream printStream, String string, LogLevel logLevel, String string2, String string3) {
        String string4 = "[" + string + "," + String.valueOf(logLevel) + "," + DateFormat.getDateTimeInstance().format(new Date()) + "," + string3 + "] ";
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "\n\r");
        while (stringTokenizer.hasMoreTokens()) {
            printStream.println(string4 + stringTokenizer.nextToken());
        }
        printStream.flush();
    }

    @Override
    public void executionPhaseFinished(boolean serverWillRestart, List<StepKey> executedSteps) {
        if (this.f != null) {
            b.a(this.f, "SetupLogger", LogLevel.STATUS, "Setup Phase finished: SUCCESS", "0000");
        }
    }

    @Override
    public void setupCompleted(boolean serverWillRestart) {
        if (this.f != null) {
            b.a(this.f, "SetupLogger", LogLevel.STATUS, "Setup finished: SUCCESS", "0000");
        }
    }

    @Override
    public void executionFailed(String failingStepMessage, Throwable error, List<StepKey> executedSteps) {
        if (this.f != null) {
            b.a(this.f, "SetupLogger", LogLevel.STATUS, "Setup finished: FAILURE", "0000");
        }
    }
}

