/*
 * Decompiled with CFR 0.152.
 */
package com.inet.setupwizard.basicsteps.webserver;

import com.inet.config.ConfigKey;
import com.inet.config.Configuration;
import com.inet.config.ConfigurationManager;
import com.inet.lib.util.NetworkFunctions;
import com.inet.setupwizard.api.SetupLogger;
import com.inet.setupwizard.api.StepExecutionException;
import com.inet.shared.servlet.PortChecker;
import com.inet.webserver.SSLSelfSignedCertificateGenerator;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Locale;
import javax.annotation.Nonnull;

public class StandaloneExecutionTask {
    public static final int DEFAULT_HTTPS_PORT = 443;
    private PortChecker Y;

    public StandaloneExecutionTask(PortChecker portChecker) {
        if (portChecker == null) {
            throw new IllegalArgumentException("port checker must not be null");
        }
        this.Y = portChecker;
    }

    public void execute(int port, Path sslCerificatePath, Path privateKeyPath) throws StepExecutionException {
        this.a(port);
        if (port == 80) {
            this.a(sslCerificatePath, privateKeyPath);
        }
    }

    public boolean willRestartServer(int port) {
        if (!this.Y.isSameAsPortThatServerIsListeningOn(port)) {
            return true;
        }
        return port == 80 && this.Y.isAvailable(443);
    }

    private boolean a(Path path, Path path2) {
        if (!this.Y.isAvailable(443)) {
            SetupLogger.LOGGER.info((Object)"[Proxy] HTTPS port is used by someone else");
            return false;
        }
        SetupLogger.LOGGER.info((Object)"[Proxy] Enable SSL and generate a default certificate");
        if (this.b(path, path2)) {
            Configuration configuration = ConfigurationManager.getInstance().getCurrent();
            configuration.put(ConfigKey.LISTENER_CONNECTION_TYPE.getKey(), "plain_and_secure");
            configuration.put(ConfigKey.LISTENER_SSL_PRIVATEKEY.getKey(), path2.toAbsolutePath().toString());
            configuration.put(ConfigKey.LISTENER_SSL_CERTIFICATE.getKey(), path.toAbsolutePath().toString());
            configuration.put(ConfigKey.LISTENER_SSL_PORT.getKey(), String.valueOf(443));
            return true;
        }
        return false;
    }

    private void a(int n) throws StepExecutionException {
        SetupLogger.LOGGER.info((Object)String.format("[Proxy] Set Listener Port to %d", n));
        Configuration configuration = ConfigurationManager.getInstance().getCurrent();
        configuration.put(ConfigKey.LISTENER_PORT.getKey(), String.valueOf(n));
    }

    private boolean b(Path path, Path path2) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        SSLSelfSignedCertificateGenerator sSLSelfSignedCertificateGenerator = new SSLSelfSignedCertificateGenerator();
        try {
            String string = NetworkFunctions.getCanonicalLocalHostName();
            String string2 = "";
            String string3 = "";
            String string4 = Locale.getDefault().getCountry();
            sSLSelfSignedCertificateGenerator.createCertificateAndPrivateKey((OutputStream)byteArrayOutputStream, (OutputStream)byteArrayOutputStream2, string, string2, string3, string4);
            this.a(byteArrayOutputStream, path2);
            this.a(byteArrayOutputStream2, path);
            return true;
        }
        catch (Exception exception) {
            SetupLogger.LOGGER.warn((Object)"[Proxy] Cannot generate SSL certificate.");
            SetupLogger.LOGGER.warn((Object)exception);
            return false;
        }
    }

    private void a(ByteArrayOutputStream byteArrayOutputStream, @Nonnull Path path) throws IOException {
        File file = path.toFile();
        File file2 = file.getAbsoluteFile().getParentFile();
        if (file2 != null) {
            file2.mkdirs();
        }
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            byteArrayOutputStream.writeTo(fileOutputStream);
        }
    }
}

