/*
 * Decompiled with CFR 0.152.
 */
package com.inet.setupwizard.basicsteps.webserver.uninstaller;

import com.inet.setupwizard.api.SetupLogger;
import com.inet.setupwizard.basicsteps.CommandExecutor;
import com.inet.setupwizard.basicsteps.webserver.ProxySetupMetaData;
import com.inet.setupwizard.basicsteps.webserver.ProxySetupMetaDataReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;

public class ProxySettingsAndResourcesRemover {
    private final CommandExecutor av = new CommandExecutor();
    private final ProxySetupMetaDataReader aE;

    public ProxySettingsAndResourcesRemover(ProxySetupMetaDataReader metaDataReader) {
        if (metaDataReader == null) {
            throw new IllegalArgumentException("metaDataReader must not be null");
        }
        this.aE = metaDataReader;
    }

    public void removeProxySettingsAndResourcesIfNeeded(MicrosoftIISProxyResourcesRemovalTask microsoftIISProxyResourcesRemovalTask) {
        ProxySetupMetaData proxySetupMetaData = this.aE.read();
        if (proxySetupMetaData == null) {
            SetupLogger.LOGGER.error((Object)"Proxy setup meta data is missing or could not be read.");
            return;
        }
        String string = proxySetupMetaData.getProxyType();
        boolean bl = "iis".equals(string);
        if (bl) {
            String string2;
            if (microsoftIISProxyResourcesRemovalTask != null) {
                microsoftIISProxyResourcesRemovalTask.removeProxyResourcesOfMicrosoftIIS();
            }
            if ((string2 = proxySetupMetaData.getContext()) == null || string2.trim().isEmpty()) {
                SetupLogger.LOGGER.error((Object)"Could not remove proxy settings because proxy setup meta data does not include value of the context.");
                return;
            }
            this.removeProxySettingsOfMicrosoftIIS(string2);
        }
    }

    public void removeProxySettingsOfMicrosoftIIS(String context) {
        Path path = Paths.get(System.getenv("WINDIR"), "system32", "inetsrv", "appcmd.exe");
        boolean bl = Files.isExecutable(path);
        if (!bl) {
            SetupLogger.LOGGER.error((Object)"Could not remove proxy settings from Microsoft IIS because AppCmd.exe command line can not be found");
            return;
        }
        try {
            String string = String.format("\"%s\" delete app \"Default Web Site/%s\"", path, context);
            this.av.executeCommand(string);
        }
        catch (CommandExecutor.UnsuccessfulExecutionException unsuccessfulExecutionException) {
            SetupLogger.LOGGER.error((Throwable)unsuccessfulExecutionException);
        }
    }

    public static interface MicrosoftIISProxyResourcesRemovalTask {
        public void removeProxyResourcesOfMicrosoftIIS();
    }
}

