/*
 * Decompiled with CFR 0.152.
 */
package com.inet.setupwizard.basicsteps.webserver;

import com.inet.config.ConfigurationManager;
import com.inet.lib.util.NetworkFunctions;
import com.inet.plugin.ServerPluginManager;
import com.inet.setupwizard.basicsteps.webserver.ProxyConnectionRecognizer;
import com.inet.setupwizard.basicsteps.webserver.WebServerStepConfig;
import com.inet.setupwizard.basicsteps.webserver.WebServerStepConfigAdditionalData;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;

public class WebServerStepInitialConfigurationCreator {
    private final ProxyConnectionRecognizer aC;
    private final String aD;

    public WebServerStepInitialConfigurationCreator(ProxyConnectionRecognizer proxyConnectionRecognizer, String defaultContext) {
        if (proxyConnectionRecognizer == null) {
            throw new IllegalArgumentException("proxy connection recognizer must not be null");
        }
        if (defaultContext == null) {
            throw new IllegalArgumentException("default context must not be null");
        }
        this.aC = proxyConnectionRecognizer;
        this.aD = defaultContext;
    }

    public WebServerStepConfig createInitialStepConfig() {
        boolean bl;
        if (!ConfigurationManager.isWriteable((int)1)) {
            return this.C();
        }
        try {
            Properties properties = ServerPluginManager.getInstance().getStartProperties();
            String string = properties.getProperty("UrlString");
            URL uRL = new URL(string);
            int n = uRL.getPort();
            if (n < 0) {
                n = uRL.getDefaultPort();
            }
            bl = n != 80 && this.aC.isMicrosoftIISListeningOnHttpPort();
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
        if (!bl) {
            return this.C();
        }
        boolean bl2 = this.aC.isPlainTextConnectionPossible();
        boolean bl3 = this.aC.isSecureConnectionPossible();
        boolean bl4 = bl2 && bl3;
        String string = bl3 ? "https" : "http";
        String string2 = "iis";
        String string3 = NetworkFunctions.getCanonicalLocalHostName();
        WebServerStepConfig webServerStepConfig = new WebServerStepConfig(string2, this.aD, string, 0, string3);
        WebServerStepConfigAdditionalData webServerStepConfigAdditionalData = new WebServerStepConfigAdditionalData(bl4, bl);
        webServerStepConfig.setAdditionalData(webServerStepConfigAdditionalData);
        return webServerStepConfig;
    }

    private WebServerStepConfig C() {
        WebServerStepConfig webServerStepConfig = new WebServerStepConfig("standalone", "http");
        WebServerStepConfigAdditionalData webServerStepConfigAdditionalData = new WebServerStepConfigAdditionalData(false, false);
        webServerStepConfig.setAdditionalData(webServerStepConfigAdditionalData);
        String string = NetworkFunctions.getCanonicalLocalHostName();
        webServerStepConfig.setServerHostName(string);
        return webServerStepConfig;
    }
}

