/*
 * Decompiled with CFR 0.152.
 */
package com.inet.setupwizard.basicsteps.license;

import com.inet.config.ConfigKeyParser;
import com.inet.config.LicenseInfo;
import com.inet.remote.gui.angular.ServiceMethod;
import com.inet.setupwizard.basicsteps.license.LicenseStepConfigUpdater;
import com.inet.setupwizard.basicsteps.license.LoadTrialLicenseResponse;
import com.inet.setupwizard.basicsteps.license.TrialLicenseKeyProvider;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import javax.annotation.Nonnull;

public class LoadTrialLicenseMethod
extends ServiceMethod<Void, LoadTrialLicenseResponse> {
    private TrialLicenseKeyProvider ai;

    public LoadTrialLicenseMethod(@Nonnull TrialLicenseKeyProvider trialLicenseKeyProvider) {
        this.ai = trialLicenseKeyProvider;
    }

    public LoadTrialLicenseResponse invoke(HttpServletRequest req, HttpServletResponse resp, Void payload) throws IOException {
        String string = this.ai.tryToDownloadTrialLicenseKey();
        if (string == null) {
            return LoadTrialLicenseResponse.forTrialLicenseUrl(LicenseStepConfigUpdater.getTrialLicenseUrl());
        }
        LicenseInfo licenseInfo = new ConfigKeyParser().getLicenseInfo(string).getCurrent();
        boolean bl = licenseInfo.isTrial();
        return LoadTrialLicenseResponse.forTrialKey(string, bl);
    }

    public String getMethodName() {
        return "loadTrialLicense";
    }

    public short getMethodType() {
        return 1;
    }
}

