/*
 * Decompiled with CFR 0.152.
 */
package com.inet.setupwizard.basicsteps.defaultwebserver.update;

import com.inet.plugin.ApplicationDescription;
import com.inet.plugin.ServerPluginManager;
import com.inet.setupwizard.SetupWizardPlugin;
import com.inet.setupwizard.api.EmptyStepConfig;
import com.inet.setupwizard.api.SetupLogger;
import com.inet.setupwizard.api.StepExecutionException;
import com.inet.setupwizard.api.StepExecutionWarnings;
import com.inet.setupwizard.basicsteps.defaultwebserver.DefaultMicrosoftIISExecutionTask;
import com.inet.setupwizard.basicsteps.defaultwebserver.uninstaller.DefaultProxySettingsAndResourcesRemover;
import com.inet.setupwizard.basicsteps.updatewebserver.UpdateWebServerStep;
import com.inet.setupwizard.basicsteps.webserver.ListenerPortSetter;
import com.inet.setupwizard.basicsteps.webserver.ProxySetupMetaData;
import com.inet.setupwizard.basicsteps.webserver.ProxySetupMetaDataInConfigurationIO;
import com.inet.shared.utils.Version;
import java.nio.file.Path;

public class DefaultUpdateWebServerStep
extends UpdateWebServerStep {
    private final Path V;
    private final ProxySetupMetaDataInConfigurationIO ag;

    public DefaultUpdateWebServerStep(Path installationDir) {
        if (installationDir == null) {
            throw new IllegalArgumentException("installationDir must not be null");
        }
        this.V = installationDir;
        this.ag = new ProxySetupMetaDataInConfigurationIO();
    }

    @Override
    public boolean hasPendingTasks() {
        boolean bl;
        ProxySetupMetaData proxySetupMetaData = this.ag.read();
        if (proxySetupMetaData == null) {
            return false;
        }
        String string = proxySetupMetaData.getProxyType();
        boolean bl2 = bl = "iis".equals(string) || "apache".equals(string);
        if (!bl) {
            return false;
        }
        Version version = ((ApplicationDescription)ServerPluginManager.getInstance().getSingleInstance(ApplicationDescription.class)).getVersion();
        Version version2 = new Version(proxySetupMetaData.getVersion());
        return version.isHigherThan(version2);
    }

    @Override
    public void execute0(EmptyStepConfig stepConfig) throws StepExecutionException {
        ProxySetupMetaData proxySetupMetaData = this.ag.read();
        new DefaultProxySettingsAndResourcesRemover().removeProxySettingsAndResourcesIfNeeded(this.V, this.ag);
        this.b(proxySetupMetaData);
        switch (proxySetupMetaData.getProxyType()) {
            case "iis": {
                SetupLogger.LOGGER.info((Object)"[Proxy] Update the MS IIS Proxy");
                DefaultMicrosoftIISExecutionTask defaultMicrosoftIISExecutionTask = new DefaultMicrosoftIISExecutionTask(this.V, new ListenerPortSetter());
                defaultMicrosoftIISExecutionTask.executeUpdate(proxySetupMetaData.getContext(), proxySetupMetaData.getProtocol());
                break;
            }
            case "apache": {
                SetupLogger.LOGGER.info((Object)"[Proxy] Clear the Apache Proxy");
                StepExecutionWarnings.get().info(() -> SetupWizardPlugin.MSG.getMsg("webserver.apache.notSupported", new Object[0]));
                proxySetupMetaData = new ProxySetupMetaData("standalone", "", proxySetupMetaData.getProtocol(), proxySetupMetaData.getVersion());
                this.b(proxySetupMetaData);
                break;
            }
            default: {
                throw new IllegalStateException("This step cannot be executed for standalone");
            }
        }
    }

    private void b(ProxySetupMetaData proxySetupMetaData) throws StepExecutionException {
        String string = ((ApplicationDescription)ServerPluginManager.getInstance().getSingleInstance(ApplicationDescription.class)).getVersion().toString();
        proxySetupMetaData.setVersion(string);
        this.ag.save(proxySetupMetaData);
    }

    @Override
    protected void deleteProxyMetaData() {
        this.ag.delete();
    }
}

