/*
 * Decompiled with CFR 0.152.
 */
package com.inet.setupwizard.api;

import com.inet.setupwizard.api.SetupStep;
import com.inet.setupwizard.api.StepConfiguration;
import com.inet.setupwizard.api.StepKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class StepsRepository {
    private List<SetupStep<?>> F;

    public StepsRepository(List<SetupStep<?>> steps) {
        if (steps == null) {
            throw new IllegalArgumentException("list of steps must not be null");
        }
        if (steps.contains(null)) {
            throw new IllegalArgumentException("list of steps must not contain null as element");
        }
        if (!this.e(steps)) {
            throw new InternalError("all steps must have unique keys");
        }
        this.d(steps);
        this.F = new ArrayList(steps);
    }

    private void d(List<SetupStep<?>> list) {
        Collections.sort(list, new Comparator<SetupStep>(){

            public int a(SetupStep setupStep, SetupStep setupStep2) {
                boolean bl;
                int n = setupStep.getPriority().compareTo(setupStep2.getPriority());
                boolean bl2 = bl = n == 0;
                if (bl && !setupStep.stepKey().equals(setupStep2.stepKey())) {
                    throw new InternalError(String.format("Step-Priorities must be unique! Priority %s is used by %s and %s", setupStep.getPriority().toString(), setupStep.stepKey().toString(), setupStep2.stepKey().toString()));
                }
                return n;
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((SetupStep)object, (SetupStep)object2);
            }
        });
    }

    private boolean e(List<SetupStep<?>> list) {
        List list2 = list.stream().map(setupStep -> setupStep.stepKey().toString()).distinct().collect(Collectors.toList());
        return list.size() == list2.size();
    }

    public boolean containsStep(StepKey stepKey) {
        if (stepKey == null) {
            throw new IllegalArgumentException("stepKey must not be null");
        }
        return this.F.stream().anyMatch(setupStep -> setupStep.stepKey().equals(stepKey));
    }

    public SetupStep<?> getFirstStep() {
        if (this.F.size() > 0) {
            return this.F.get(0);
        }
        return null;
    }

    public <T extends StepConfiguration> SetupStep<T> getStep(StepKey stepKey) {
        if (!this.containsStep(stepKey)) {
            throw new IllegalArgumentException(String.valueOf(stepKey) + " not found");
        }
        return this.F.stream().filter(setupStep -> setupStep.stepKey().equals(stepKey)).findFirst().get();
    }

    public List<SetupStep<?>> allSteps() {
        return new ArrayList(this.F);
    }

    public SetupStep<?> getNextStep(StepKey currentStepKey) {
        int n = this.a(currentStepKey);
        if (n >= 0 && n < this.F.size() - 1) {
            return this.F.get(n + 1);
        }
        throw new IllegalArgumentException(String.format("Cannot find a next step for %s", currentStepKey.toString()));
    }

    private int a(StepKey stepKey) {
        for (int i = 0; i < this.F.size(); ++i) {
            SetupStep<?> setupStep = this.F.get(i);
            if (!setupStep.stepKey().equals(stepKey)) continue;
            return i;
        }
        return -1;
    }
}

