/*
 * Decompiled with CFR 0.152.
 */
package com.inet.usersandgroups.user.persistence;

import com.inet.annotations.JsonData;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonException;
import com.inet.lib.json.JsonParameterizedType;
import com.inet.usersandgroups.api.user.LoginSettings;
import com.inet.usersandgroups.api.user.UserAccountType;
import com.inet.usersandgroups.user.search.SearchTagLoginSettings;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;

@JsonData
public class UserPersistenceUnit {
    private static final String PROPERTY_TYPE = "accountType";
    private static final String PROPERTY_LASTMODIFIED = "lastModified";
    private static final String PROPERTY_LASTACCESS = "lastAccess";
    private static final String PROPERTY_ACTIVE = "active";
    private static final String PROPERTY_LOGINSETTINGS = "loginSettings";
    private static final String PROPERTY_PERMISSIONS = "permissions";
    private HashMap<String, String> properties;
    private HashMap<String, String> fields;

    private UserPersistenceUnit() {
    }

    public UserPersistenceUnit(UserAccountType type, long lastModified, long lastAccess, boolean active, HashMap<String, String> fields, List<LoginSettings> loginSettings, Set<String> permissions) {
        this.properties = new HashMap();
        this.properties.put(PROPERTY_TYPE, type.name());
        this.properties.put(PROPERTY_LASTMODIFIED, String.valueOf(lastModified));
        this.properties.put(PROPERTY_LASTACCESS, String.valueOf(lastAccess));
        this.properties.put(PROPERTY_ACTIVE, String.valueOf(active));
        this.properties.put(PROPERTY_LOGINSETTINGS, new Json().toJson(loginSettings));
        this.properties.put(PROPERTY_PERMISSIONS, new Json().toJson(permissions));
        this.fields = fields;
    }

    public static UserPersistenceUnit createReplacementForCorruptedData() {
        return new UserPersistenceUnit();
    }

    public UserAccountType getAccountType() {
        try {
            String string = this.getProperty(PROPERTY_TYPE);
            return UserAccountType.valueOf(string);
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            return UserAccountType.Standard;
        }
    }

    public long getLastModified() {
        try {
            String string = this.getProperty(PROPERTY_LASTMODIFIED);
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            return System.currentTimeMillis();
        }
    }

    public long getLastAccess() {
        try {
            String string = this.getProperty(PROPERTY_LASTACCESS);
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0L;
        }
    }

    public boolean isActive() {
        String string = this.getProperty(PROPERTY_ACTIVE);
        return Boolean.parseBoolean(string);
    }

    public HashMap<String, String> getFields() {
        return this.fields == null ? new HashMap<String, String>() : this.fields;
    }

    public List<LoginSettings> getLoginSettings() {
        try {
            String string = this.getProperty(PROPERTY_LOGINSETTINGS);
            return (List)new Json().fromJson(string, (Type)new JsonParameterizedType((Type)((Object)List.class), new Type[]{LoginSettings.class}));
        }
        catch (JsonException jsonException) {
            return new ArrayList<LoginSettings>();
        }
    }

    public Set<String> getPermissions() {
        try {
            String string = this.getProperty(PROPERTY_PERMISSIONS);
            return (Set)new Json().fromJson(string, (Type)new JsonParameterizedType((Type)((Object)Set.class), new Type[]{String.class}));
        }
        catch (JsonException jsonException) {
            return new HashSet<String>();
        }
    }

    private String getProperty(String key) {
        return this.properties == null ? null : this.properties.get(key);
    }

    public static List<LoginSettings> updateLoginSettings(@Nonnull List<LoginSettings> loginSettings, @Nonnull List<LoginSettings> settingsToAdd, @Nonnull List<LoginSettings> settingsToRemove) {
        ArrayList<LoginSettings> arrayList = new ArrayList<LoginSettings>(loginSettings);
        arrayList.removeAll(settingsToRemove);
        for (LoginSettings loginSettings2 : settingsToAdd) {
            boolean bl = true;
            String string = SearchTagLoginSettings.settingsAsToken(loginSettings2.getLoginSource(), loginSettings2.getLoginID());
            for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                LoginSettings loginSettings3 = (LoginSettings)arrayList.get(i2);
                String string2 = SearchTagLoginSettings.settingsAsToken(loginSettings3.getLoginSource(), loginSettings3.getLoginID());
                if (!string2.equals(string)) continue;
                arrayList.set(i2, loginSettings2);
                bl = false;
                break;
            }
            if (!bl) continue;
            arrayList.add(loginSettings2);
        }
        return arrayList;
    }
}

