/*
 * Decompiled with CFR 0.152.
 */
package com.inet.usersandgroups.api.user;

import com.inet.annotations.InternalApi;

@InternalApi
public class UserNameUtils {
    public static String normalizeSlashChars(String userName) {
        UserNameUtils.throwIfInvalid(userName);
        return userName.replace("\\", "/");
    }

    public static boolean containsDomain(String userName) {
        String string = UserNameUtils.normalizeSlashChars(userName);
        return string.indexOf(47) > -1;
    }

    public static String removeDomain(String userName) {
        String string = UserNameUtils.normalizeSlashChars(userName);
        int n2 = string.indexOf(47);
        if (n2 > -1) {
            return string.substring(n2 + 1);
        }
        return userName;
    }

    public static boolean isValid(String userName) {
        try {
            UserNameUtils.throwIfInvalid(userName);
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public static void throwIfInvalid(String userName) {
        if (userName == null) {
            throw new IllegalArgumentException("user name must not be null");
        }
        if (userName.trim().isEmpty()) {
            throw new IllegalArgumentException("user name must not be empty after trim");
        }
    }
}

