/*
 * Decompiled with CFR 0.152.
 */
package com.inet.usersandgroups.api.user;

import com.inet.error.ErrorCode;
import com.inet.id.GUID;
import com.inet.search.AbstractSearchDataCache;
import com.inet.search.SearchDataCacheChangeListener;
import com.inet.search.SearchResult;
import com.inet.search.SearchTag;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.index.IndexSearchEngine;
import com.inet.usersandgroups.api.user.BaseUserManager;
import com.inet.usersandgroups.api.user.UserManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AuthGroupManager {
    private static final String KEY = "names";
    private static AuthGroupManager a;
    private final IndexSearchEngine<String> b = new IndexSearchEngine<String>("authgroupname", null, true, String.class);
    private final a c;

    private AuthGroupManager() throws IOException {
        this.b.addTag(new SearchTag(KEY, 0));
        this.c = new a();
        this.b.setData(this.c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AuthGroupManager getInstance() {
        if (a != null) return a;
        Class<AuthGroupManager> clazz = AuthGroupManager.class;
        synchronized (AuthGroupManager.class) {
            if (a != null) return a;
            try {
                a = new AuthGroupManager();
            }
            catch (IOException iOException) {
                ErrorCode.throwAny(iOException);
            }
            return a;
        }
    }

    @Nonnull
    public List<String> createDisplayValuesIterator(String searchTerm) {
        SearchCommand searchCommand = new SearchCommand(KEY, SearchCondition.SearchTermOperator.StartsWith, searchTerm);
        Set<String> set = this.b.simpleSearch(searchCommand);
        ArrayList<String> arrayList = new ArrayList<String>(set);
        Collections.sort(arrayList, String.CASE_INSENSITIVE_ORDER);
        return arrayList;
    }

    public IndexSearchEngine<String> getSearchEngine() {
        return this.b;
    }

    void a(@Nonnull Set<String> set, @Nonnull Set<String> set2) {
        String string;
        String string2;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String iterator : set) {
            hashMap.put(iterator.toLowerCase(), iterator);
        }
        HashMap hashMap2 = new HashMap();
        for (String string3 : set2) {
            hashMap2.put(string3.toLowerCase(), string3);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            string2 = (String)entry.getKey();
            string = (String)entry.getValue();
            if (hashMap2.containsKey(string2)) {
                if (set2.contains(entry.getValue())) continue;
                this.c.c(string);
                this.c.b((String)hashMap2.get(string2));
                continue;
            }
            if (this.a(string)) continue;
            this.c.c(string);
        }
        for (Map.Entry entry : hashMap2.entrySet()) {
            string2 = (String)entry.getKey();
            string = (String)entry.getValue();
            if (hashMap.containsKey(string2) || !this.a(string)) continue;
            this.c.b(string);
        }
    }

    public void clearUserAuthGroupNames(@Nonnull Set<String> oldNames) {
        this.a(oldNames, Collections.emptySet());
    }

    private boolean a(String string) {
        SearchCommand searchCommand;
        IndexSearchEngine<GUID> indexSearchEngine = UserManager.getRecoveryEnabledInstance().getSearchEngine();
        SearchResult<GUID> searchResult = indexSearchEngine.search(searchCommand = new SearchCommand("authgroupname", SearchCondition.SearchTermOperator.Equals, string));
        return !searchResult.getEntries().isEmpty();
    }

    private static class a
    extends AbstractSearchDataCache<String> {
        private a() {
        }

        @Nullable
        public Map<String, Object> a(@Nonnull String string) {
            return Collections.singletonMap(AuthGroupManager.KEY, string);
        }

        @Override
        public Iterator<String> iterator() {
            UserManager userManager = UserManager.getRecoveryEnabledInstance();
            Iterator<GUID> iterator = userManager.getIteratorOverUserAccountIDs(BaseUserManager.ROLES_KEY);
            HashSet<String> hashSet = new HashSet<String>();
            while (iterator.hasNext()) {
                GUID gUID = iterator.next();
                hashSet.addAll(userManager.getAuthGroupsForUser(gUID));
            }
            return hashSet.iterator();
        }

        void b(String string) {
            for (SearchDataCacheChangeListener<String> searchDataCacheChangeListener : this.getListeners()) {
                searchDataCacheChangeListener.entryAdded(string, Collections.singletonMap(AuthGroupManager.KEY, string));
            }
        }

        void c(String string) {
            for (SearchDataCacheChangeListener<String> searchDataCacheChangeListener : this.getListeners()) {
                searchDataCacheChangeListener.entryRemoved(string, Collections.singletonMap(AuthGroupManager.KEY, string));
            }
        }

        @Override
        @Nullable
        public /* synthetic */ Map getCacheEntry(@Nonnull Object object) {
            return this.a((String)object);
        }
    }
}

