/*
 * Decompiled with CFR 0.152.
 */
package com.inet.usersandgroups.api.ui.fields.user;

import com.inet.lib.json.Json;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.ui.fields.user.UserFieldDefinition;
import com.inet.usersandgroups.api.ui.fields.values.FieldValue;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public abstract class StringListUserFieldDefinition
extends UserFieldDefinition<List<String>> {
    public StringListUserFieldDefinition(String groupKey, UserField<List<String>> field, int prio) {
        super(groupKey, "fieldtype_string_list", prio, field);
    }

    public StringListUserFieldDefinition(String groupKey, String fieldKey, String displayType, int prio) {
        super(groupKey, fieldKey, displayType, prio);
    }

    @Override
    public FieldValue getFieldValue(UserAccount userAccount) {
        String string = "[]";
        if (userAccount != null) {
            string = (String)userAccount.getValue(UserManager.getRecoveryEnabledInstance().getField(this.getFieldKey()));
        }
        Object object = this.convertFromString(string);
        FieldValue fieldValue = new FieldValue(new Json().toJson(object));
        fieldValue.setVisibleInPreview(object != null && object.size() > 0);
        fieldValue.setEnabled(this.isEnabled());
        return fieldValue;
    }

    @Override
    public List<String> convertFromString(String value) {
        return new Json().fromJson(value, ArrayList.class, new Type[]{String.class});
    }
}

