/*
 * Decompiled with CFR 0.152.
 */
package com.inet.usersandgroups.api.groups;

import com.inet.annotations.InternalApi;
import com.inet.id.GUID;
import com.inet.usersandgroups.api.UserGroupField;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

@InternalApi
public class MutableUserGroupData {
    private Map<UserGroupField<Object>, Object> a = new HashMap<UserGroupField<Object>, Object>();

    public static MutableUserGroupData createAndFillWithValidValues(@Nullable GUID groupID, List<UserGroupField<Object>> groupFields, Map<UserGroupField<Object>, Object> groupData) {
        MutableUserGroupData mutableUserGroupData = new MutableUserGroupData();
        for (UserGroupField<Object> userGroupField : groupFields) {
            Object VALUE = groupData.containsKey(userGroupField) ? userGroupField.getValidOrDefaultValue(groupData.get(userGroupField), groupID) : userGroupField.getDefaultValue();
            mutableUserGroupData.a.put(userGroupField, VALUE);
        }
        return mutableUserGroupData;
    }

    public <VALUE> void put(UserGroupField<VALUE> field, VALUE value) {
        field.validate(value);
        this.a.put(field, value);
    }

    public <VALUE> VALUE get(UserGroupField<VALUE> field) {
        return (VALUE)this.a.get(field);
    }

    public void remove(UserGroupField<?> field) {
        this.a.remove(field);
    }

    public boolean containsField(UserGroupField<?> field) {
        return this.a.containsKey(field);
    }

    public Set<UserGroupField<Object>> getIncludedFields() {
        return new HashSet<UserGroupField<Object>>(this.a.keySet());
    }

    public boolean isEmpty() {
        return this.a.isEmpty();
    }

    public MutableUserGroupData copy() {
        MutableUserGroupData mutableUserGroupData = new MutableUserGroupData();
        for (Map.Entry<UserGroupField<Object>, Object> entry : this.a.entrySet()) {
            UserGroupField<Object> userGroupField = entry.getKey();
            mutableUserGroupData.a.put(userGroupField, userGroupField.copyValue(entry.getValue()));
        }
        return mutableUserGroupData;
    }

    public MutableUserGroupData copyWithSpecifiedFieldsOnly(Collection<UserGroupField<Object>> fieldsToInclude, boolean insertDefaultValuesForMissingFields) {
        MutableUserGroupData mutableUserGroupData = new MutableUserGroupData();
        for (UserGroupField<Object> userGroupField : fieldsToInclude) {
            if (this.containsField(userGroupField)) {
                Object object = this.get(userGroupField);
                mutableUserGroupData.a.put(userGroupField, userGroupField.copyValue(object));
                continue;
            }
            if (!insertDefaultValuesForMissingFields) continue;
            mutableUserGroupData.a.put(userGroupField, userGroupField.getDefaultValue());
        }
        return mutableUserGroupData;
    }
}

