/*
 * Decompiled with CFR 0.152.
 */
package com.inet.usersandgroups.api;

import com.inet.annotations.InternalApi;
import com.inet.field.Field;
import com.inet.field.fieldtypes.FieldTypeFactory;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.ui.fields.user.UserFieldDefinition;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.function.BooleanSupplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public abstract class UserField<VALUE>
extends Field<VALUE> {
    public UserField(String key) {
        this(key, null, FieldTypeFactory.auto().withoutSearchTag());
    }

    public UserField(String key, VALUE defaultValue) {
        this(key, defaultValue, FieldTypeFactory.auto().withoutSearchTag());
    }

    public UserField(String key, FieldTypeFactory factory) {
        this(key, null, factory);
    }

    public UserField(String key, VALUE defaultValue, FieldTypeFactory factory) {
        super(key, defaultValue, factory.withIsInTextSearchEnabled(UserField.includeInTextSearchDependingOnFieldAvailability(key)));
    }

    protected UserField(@Nonnull String key, @Nullable VALUE defaultValue, FieldTypeFactory factory, @Nonnull Class<VALUE> valueType) {
        super(key, defaultValue, factory.withIsInTextSearchEnabled(UserField.includeInTextSearchDependingOnFieldAvailability(key)), valueType);
    }

    public static BooleanSupplier includeInTextSearchDependingOnFieldAvailability(String key) {
        return () -> {
            UserFieldDefinition userFieldDefinition = UsersAndGroups.getUserFieldDefinitionByKey(key);
            if (userFieldDefinition == null) {
                return false;
            }
            if (UserManager.getInstance().getCurrentUserAccountID() == null) {
                return true;
            }
            return userFieldDefinition.isAvailable(null);
        };
    }

    public boolean isCustomField() {
        return false;
    }

    @Override
    public String getLabel() {
        return UsersAndGroups.getFieldDisplayName(this.getKey());
    }

    public VALUE getValueForPrivilegedUser() {
        return this.copyValue(this.getDefaultValue());
    }

    public boolean isValueChangeLoggable() {
        return true;
    }
}

