/*
 * Decompiled with CFR 0.152.
 */
package com.inet.plugin.website.data;

import com.inet.annotations.JsonData;
import com.inet.plugin.website.data.DownloadLink;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nonnull;

@JsonData
public class WebsiteDownloadResponseData {
    private String version;
    private String orderVersion;
    private String lastUpdate;
    private List<DownloadLink> downloadLinks;
    private transient Date lastUpdateDate;

    public WebsiteDownloadResponseData() {
    }

    public WebsiteDownloadResponseData(String version, String orderVersion, String lastUpdate, List<DownloadLink> downloadLinks) {
        this.version = version;
        this.orderVersion = orderVersion;
        this.lastUpdate = lastUpdate;
        this.downloadLinks = downloadLinks;
    }

    public String getVersion() {
        return this.version;
    }

    public String getOrderVersion() {
        return this.orderVersion;
    }

    public String getLastUpdate() {
        return this.lastUpdate;
    }

    @Nonnull
    public Date getLastUpdateDate() {
        Date date = this.lastUpdateDate;
        if (date == null) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("d-MMM-yyyy", Locale.ENGLISH);
            try {
                date = simpleDateFormat.parse(Objects.requireNonNullElse(this.lastUpdate, ""));
            }
            catch (ParseException parseException) {
                date = new Date();
            }
            this.lastUpdateDate = date;
        }
        return date;
    }

    public List<DownloadLink> getDownloadLinks() {
        return this.downloadLinks;
    }
}

